/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.system.entity.ElsSystemBusinessRule;
import com.els.modules.system.mapper.ElsSystemBusinessRuleMapper;
import com.els.modules.system.service.ElsSystemBusinessRuleService;
import com.els.modules.template.util.CreateJsonFileUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ElsSystemBusinessRuleServiceImpl
extends ServiceImpl<ElsSystemBusinessRuleMapper, ElsSystemBusinessRule>
implements ElsSystemBusinessRuleService {
    @Override
    public void saveElsSystemBusinessRule(ElsSystemBusinessRule elsSystemBusinessRule) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("business_type", elsSystemBusinessRule.getBusinessType());
        queryMap.put("item_code", elsSystemBusinessRule.getItemCode());
        List businessRules = ((ElsSystemBusinessRuleMapper)this.baseMapper).selectByMap(queryMap);
        if (!businessRules.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_same_elsSystemBusinessRule", (String)"\u5df2\u7ecf\u5b58\u5728\u8be5\u4e1a\u52a1\u89c4\u5219\u7f16\u7801\uff01"));
        }
        ((ElsSystemBusinessRuleMapper)this.baseMapper).insert((Object)elsSystemBusinessRule);
    }

    @Override
    public void updateElsSystemBusinessRule(ElsSystemBusinessRule elsSystemBusinessRule) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("business_type", elsSystemBusinessRule.getBusinessType());
        queryMap.put("item_code", elsSystemBusinessRule.getItemCode());
        List businessRules = ((ElsSystemBusinessRuleMapper)this.baseMapper).selectByMap(queryMap);
        ElsSystemBusinessRule businessRule = (ElsSystemBusinessRule)((Object)((ElsSystemBusinessRuleMapper)this.baseMapper).selectById((Serializable)((Object)elsSystemBusinessRule.getId())));
        List rules = businessRules.stream().filter(o -> o.getBusinessType().equals(businessRule.getBusinessType()) && o.getItemCode().equals(businessRule.getItemCode())).collect(Collectors.toList());
        if (!rules.isEmpty() && rules.size() == 1) {
            ((ElsSystemBusinessRuleMapper)this.baseMapper).updateById((Object)elsSystemBusinessRule);
            return;
        }
        if (rules.isEmpty() && businessRules.isEmpty()) {
            ((ElsSystemBusinessRuleMapper)this.baseMapper).updateById((Object)elsSystemBusinessRule);
            return;
        }
        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_same_elsSystemBusinessRule", (String)"\u5df2\u7ecf\u5b58\u5728\u8be5\u4e1a\u52a1\u89c4\u5219\u7f16\u7801\uff01"));
    }

    @Override
    public void delElsSystemBusinessRule(String id) {
        ((ElsSystemBusinessRuleMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsSystemBusinessRule(List<String> idList) {
        ((ElsSystemBusinessRuleMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void exportJson(ElsSystemBusinessRule elsSystemBusinessRule, HttpServletRequest req, HttpServletResponse res) throws Exception {
        String selections = req.getParameter("selections");
        List businessRuleList = null;
        if (StrUtil.isNotBlank((CharSequence)selections)) {
            queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"id", (Object[])selections.split(","));
            businessRuleList = this.list((Wrapper)queryWrapper);
        } else {
            queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsSystemBusinessRule), (Map)req.getParameterMap());
            businessRuleList = this.list((Wrapper)queryWrapper);
        }
        if (businessRuleList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_importData_empty", (String)"\u5bfc\u51fa\u7684\u6570\u636e\u4e3a\u7a7a\uff01"));
        }
        JSONArray jsonObject = JSONArray.parseArray((String)JSON.toJSONString((Object)businessRuleList));
        CreateJsonFileUtil.createFile(jsonObject.toString(), "", res);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void importJson(List<ElsSystemBusinessRule> businessRuleList) {
        String elsAccount = TenantContext.getTenant();
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        List businessTypeList = businessRuleList.parallelStream().map(ElsSystemBusinessRule::getBusinessType).distinct().collect(Collectors.toList());
        List itemCodeList = businessRuleList.parallelStream().map(ElsSystemBusinessRule::getItemCode).distinct().collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.in((Object)"business_type", businessTypeList);
        queryWrapper.in((Object)"item_code", itemCodeList);
        List myRuleList = this.list((Wrapper)queryWrapper);
        List notExistRuleList = businessRuleList.parallelStream().filter(vo -> !myRuleList.parallelStream().map(my -> my.getBusinessType() + "_" + my.getItemCode()).collect(Collectors.toList()).contains(vo.getBusinessType() + "_" + vo.getItemCode())).collect(Collectors.toList());
        List existRuleList = businessRuleList.parallelStream().filter(vo -> myRuleList.parallelStream().map(my -> my.getBusinessType() + "_" + my.getItemCode()).collect(Collectors.toList()).contains(vo.getBusinessType() + "_" + vo.getItemCode())).collect(Collectors.toList());
        for (ElsSystemBusinessRule rule : existRuleList) {
            String str = rule.getBusinessType() + "_" + rule.getItemCode();
            Optional<ElsSystemBusinessRule> optional = myRuleList.parallelStream().filter(o -> (o.getBusinessType() + "_" + o.getItemCode()).equals(str)).findFirst();
            if (!optional.isPresent()) {
                throw new ELSBootException("No Support System Business Rule.");
            }
            rule.setId(optional.get().getId());
            rule.setElsAccount(elsAccount);
            rule.setCreateBy(optional.get().getCreateBy());
            rule.setCreateTime(optional.get().getCreateTime());
            rule.setUpdateBy(loginUser.getSubAccount());
            rule.setUpdateTime(new Date());
        }
        if (!notExistRuleList.isEmpty()) {
            this.saveBatch(notExistRuleList, 2000);
        }
        if (!existRuleList.isEmpty()) {
            this.updateBatchById(existRuleList, 20000);
        }
    }
}

