/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import java.util.List;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelStyleUtil {
    private static final short STRING_FORMAT = (short)BuiltinFormats.getBuiltinFormat((String)"TEXT");
    private static final short FONT_SIZE_TEN = 10;
    public static final short FONT_SIZE_ELEVEN = 11;
    private static final short FONT_SIZE_TWELVE = 12;
    private static final short height = 30;

    private ExcelStyleUtil() {
    }

    public static CellStyle getStyles(Workbook workbook, int style) {
        CellStyle cellStyle = null;
        switch (style) {
            case 1: {
                cellStyle = ExcelStyleUtil.initHeaderStyle(workbook);
                break;
            }
            case 2: {
                cellStyle = ExcelStyleUtil.initTitleStyle(workbook, true, (short)11);
                break;
            }
            case 3: {
                cellStyle = ExcelStyleUtil.initStyles(workbook);
                break;
            }
            default: {
                cellStyle = ExcelStyleUtil.initStyles(workbook);
            }
        }
        cellStyle.setDataFormat(STRING_FORMAT);
        return cellStyle;
    }

    public static CellStyle initHeaderStyle(Workbook workbook) {
        CellStyle style = ExcelStyleUtil.getBaseCellStyle(workbook);
        style.setFont(ExcelStyleUtil.getFont(workbook, (short)12, true));
        return style;
    }

    public static CellStyle initTitleStyle(Workbook workbook, boolean isBold, short size) {
        CellStyle style = ExcelStyleUtil.getBaseCellStyle(workbook);
        style.setFont(ExcelStyleUtil.getFont(workbook, size, isBold));
        style.setFillForegroundColor(IndexedColors.TAN.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        return style;
    }

    public static CellStyle initStyles(Workbook workbook) {
        CellStyle style = ExcelStyleUtil.getBaseCellStyle(workbook);
        style.setFont(ExcelStyleUtil.getFont(workbook, (short)10, false));
        style.setDataFormat(STRING_FORMAT);
        return style;
    }

    public static CellStyle getRowBackground(Workbook workbook) {
        CellStyle style = ExcelStyleUtil.getBaseCellStyle(workbook);
        style.setFont(ExcelStyleUtil.getFont(workbook, (short)10, false));
        style.setFillForegroundColor(IndexedColors.LAVENDER.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setDataFormat(STRING_FORMAT);
        return style;
    }

    private static CellStyle getBaseCellStyle(Workbook workbook) {
        CellStyle style = workbook.createCellStyle();
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(true);
        return style;
    }

    private static Font getFont(Workbook workbook, short size, boolean isBold) {
        Font font = workbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setBold(isBold);
        font.setFontHeightInPoints(size);
        return font;
    }

    public static void setStyleByType(Workbook workbook, String sheetName, int type, List<Integer> autoRowHeight) {
        if (sheetName != null && sheetName.length() > 0) {
            Sheet sheet = workbook.getSheet(sheetName);
            ExcelStyleUtil.setSheetStyleByType(workbook, sheet, type, autoRowHeight);
        } else {
            int sheetNum = workbook.getNumberOfSheets();
            for (int i = 0; i < sheetNum; ++i) {
                Sheet sheet = workbook.getSheetAt(i);
                ExcelStyleUtil.setSheetStyleByType(workbook, sheet, type, autoRowHeight);
            }
        }
    }

    public static void setSheetStyleByType(Workbook workbook, Sheet sheet, int type, List<Integer> autoRowHeight) {
        if (type == 1 || type == 3) {
            ExcelStyleUtil.setRowBackground(workbook, sheet);
        }
        int lastRowNum = sheet.getLastRowNum();
        for (int j = 0; j <= lastRowNum; ++j) {
            Row row = sheet.getRow(j);
            row.setHeightInPoints(30.0f);
            if (type != 2 && type != 3) continue;
            if (autoRowHeight != null && autoRowHeight.contains(j)) {
                ExcelStyleUtil.autoRowHeight(row);
                continue;
            }
            ExcelStyleUtil.autoRowHeight(row);
        }
    }

    public static void setRowBackground(Workbook workbook, Sheet sheet) {
        CellStyle styles = ExcelStyleUtil.getRowBackground(workbook);
        for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
            if (i % 2 != 0 || i <= 0) continue;
            Row row = sheet.getRow(i);
            for (int j = 0; j < row.getPhysicalNumberOfCells(); ++j) {
                Cell cell = row.getCell(j);
                cell.setCellStyle(styles);
            }
        }
    }

    public static void autoRowHeight(Row row) {
        int enterCnt = 0;
        for (int j = 0; j < row.getPhysicalNumberOfCells(); ++j) {
            int rwsTemp;
            Cell cell = row.getCell(j);
            if (cell == null || (rwsTemp = row.getCell(j).toString().length()) <= enterCnt) continue;
            enterCnt = rwsTemp;
        }
        row.setHeightInPoints(30.0f);
        if (enterCnt > 30) {
            long d = Math.round((double)enterCnt / 30.0) + 2L;
            row.setHeightInPoints((float)((long)enterCnt * d));
        }
    }
}

