/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.controller;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.DictModel;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.entity.PurchaseAttachmentRecord;
import com.els.modules.attachment.entity.SaleAttachment;
import com.els.modules.attachment.service.PurchaseAttachmentRecordService;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.attachment.service.SaleAttachmentService;
import com.els.modules.attachment.storage.StorageFileInfo;
import com.els.modules.attachment.storage.service.FileStoreSignService;
import com.els.modules.attachment.vo.AttachmentSendVO;
import com.els.modules.attachment.vo.PurchaseAttachmentVO;
import com.els.modules.system.service.DictService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Tag(name="\u91c7\u8d2d\u9644\u4ef6")
@RestController
@RequestMapping(value={"/attachment/purchaseAttachment"})
public class PurchaseAttachmentController
extends BaseController<PurchaseAttachment, PurchaseAttachmentService> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PurchaseAttachmentController.class);
    @Autowired
    private PurchaseAttachmentService purchaseAttachmentService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SaleAttachmentService saleAttachmentService;
    @Autowired
    private PurchaseAttachmentRecordService purchaseAttachmentRecordService;
    @Resource(name="fileStoreSignServiceImpl")
    private FileStoreSignService fileStoreSignServiceImpl;
    private static final String SERVICE_ADDRESS = ((Environment)SpringContextUtils.getBean(Environment.class)).getProperty("els.config.service.address");

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"attachment#purchaseAttachment:list"})
    public Result<?> queryPageList(PurchaseAttachment purchaseAttachment, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseAttachment), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.lambda().ne(PurchaseAttachment::getBusinessType, (Object)"knowledgeBase");
        IPage pageList = this.purchaseAttachmentService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/listFileCompare"})
    @RequiresPermissions(value={"attachment#purchaseAttachment:list"})
    public Result<?> listFileCompare(PurchaseAttachment purchaseAttachment, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseAttachment), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.lambda().ne(PurchaseAttachment::getBusinessType, (Object)"knowledgeBase");
        queryWrapper.and(q -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)q.lambda().likeLeft(PurchaseAttachment::getFileName, (Object)".doc")).or()).likeLeft(PurchaseAttachment::getFileName, (Object)".docx")).or()).likeLeft(PurchaseAttachment::getFileName, (Object)".pdf"));
        queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
        IPage pageList = this.purchaseAttachmentService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u67e5\u8be2\u7269\u6599\u6587\u6863", description="\u67e5\u8be2\u7269\u6599\u6587\u6863")
    @PostMapping(value={"/listEffectiveMaterialFile"})
    @RequiresPermissions(value={"attachment#purchaseAttachment:list"})
    public Result<?> listEffectiveMaterialFile(@RequestBody List<String> materialList) {
        Date now = new Date();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(PurchaseAttachment::getBusinessType, (Object)"materialFile")).in(PurchaseAttachment::getMaterialNumber, materialList)).and(i -> ((LambdaQueryWrapper)((LambdaQueryWrapper)i.or(b -> ((LambdaQueryWrapper)b.le(PurchaseAttachment::getEffectiveDate, (Object)now)).ge(PurchaseAttachment::getExpiryDate, (Object)now))).or(b -> ((LambdaQueryWrapper)b.isNull(PurchaseAttachment::getEffectiveDate)).ge(PurchaseAttachment::getExpiryDate, (Object)now))).or(b -> ((LambdaQueryWrapper)b.isNull(PurchaseAttachment::getExpiryDate)).le(PurchaseAttachment::getEffectiveDate, (Object)now)));
        List list = this.purchaseAttachmentService.list((Wrapper)queryWrapper);
        for (PurchaseAttachment attachment : list) {
            attachment.setSourceOptType("select");
            attachment.setHeadId(null);
            attachment.setRelationId(null);
            attachment.setEffectiveDate(null);
            attachment.setExpiryDate(null);
            attachment.setUploadElsAccount(SysUtil.getLoginUser().getElsAccount());
            attachment.setUploadSubAccount(SysUtil.getLoginUser().getSubAccount());
        }
        return Result.ok((Object)list);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u9644\u4ef6-\u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\u8bb0\u5f55", operateType=2)
    @Operation(summary="\u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\u8bb0\u5f55", description="\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/uploadLog"})
    @RequiresPermissions(value={"attachment#purchaseAttachment:upload"})
    public Result<?> uploadLog(@Valid @RequestBody List<PurchaseAttachment> attachmentList) {
        for (PurchaseAttachment attachment : attachmentList) {
            attachment.setUploadSubAccount(this.getCurrentUser().getSubAccount());
            attachment.setUploadElsAccount(TenantContext.getTenant());
            attachment.setSendStatus("0");
            attachment.setReceiveStatus("0");
            attachment.setUploadTime(new Date());
            attachment.setSaveType(CharSequenceUtil.emptyToDefault((CharSequence)attachment.getSaveType(), (String)this.fileStoreSignServiceImpl.activeType()));
            attachment.setSourceType("1");
            if (!CharSequenceUtil.isEmpty((CharSequence)attachment.getFileType())) continue;
            attachment.setFileType("5");
        }
        this.purchaseAttachmentService.saveBatch(attachmentList);
        return Result.ok(attachmentList);
    }

    @RequiresPermissions(value={"attachment#purchaseAttachment:upload"})
    @AutoLog(value="\u91c7\u8d2d\u9644\u4ef6-\u4e0a\u4f20", operateType=2)
    @Operation(summary="\u4e0a\u4f20\u6587\u4ef6", description="\u4e0a\u4f20\u6587\u4ef6")
    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    public Result<?> upload(HttpServletRequest request) {
        List<String> txFields = Arrays.asList("effectiveDate", "expiryDate", "caType", "saveType");
        JSONObject param = new JSONObject();
        Map parameterMap = request.getParameterMap();
        for (String key : parameterMap.keySet()) {
            if (txFields.contains(key)) continue;
            String[] values = (String[])parameterMap.get(key);
            param.put(key, (Object)values[0]);
        }
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)param), (String)I18nUtil.translate((String)"i18n_alert_RRESAc_50983d0e", (String)"\u7f3a\u5c11\u4e1a\u52a1\u7c7b\u578b"));
        Assert.hasText((String)param.getString("businessType"), (String)I18nUtil.translate((String)"i18n_alert_RRESAc_50983d0e", (String)"\u7f3a\u5c11\u4e1a\u52a1\u7c7b\u578b"));
        Assert.hasText((String)param.getString("headId"), (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a"));
        String actionRoutePath = request.getParameter("actionRoutePath");
        String effectiveDate = request.getParameter("effectiveDate");
        String expiryDate = request.getParameter("expiryDate");
        String saveType = request.getParameter("saveType");
        String caType = request.getParameter("caType");
        String elsAccount = this.getTenantId();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        try {
            for (Map.Entry entity : fileMap.entrySet()) {
                boolean result;
                MultipartFile uploadFile = (MultipartFile)entity.getValue();
                StorageFileInfo fileInfo = this.fileStoreSignServiceImpl.storeFile(uploadFile, null, saveType, caType);
                PurchaseAttachment attachment = (PurchaseAttachment)((Object)JSONObject.toJavaObject((JSON)param, PurchaseAttachment.class));
                if (StrUtil.isNotBlank((CharSequence)fileInfo.getId())) {
                    attachment.setId(fileInfo.getId());
                }
                if (CharSequenceUtil.isEmpty((CharSequence)attachment.getFileType())) {
                    attachment.setFileType("5");
                }
                attachment.setUploadSubAccount(this.getCurrentUser().getSubAccount());
                attachment.setUploadElsAccount(elsAccount);
                attachment.setFileName(uploadFile.getOriginalFilename());
                attachment.setFileSize(String.valueOf(uploadFile.getSize()));
                attachment.setFilePath(fileInfo.getPath());
                attachment.setSaveType(fileInfo.getSaveType());
                attachment.setActionRoutePath(actionRoutePath);
                attachment.setSendStatus("0");
                attachment.setReceiveStatus("0");
                attachment.setUploadTime(new Date());
                attachment.setSourceType("1");
                SysUtil.checkFileType((String)uploadFile.getOriginalFilename());
                try {
                    attachment.setEffectiveDate((Date)DateUtil.parseDate((CharSequence)effectiveDate));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    attachment.setExpiryDate((Date)DateUtil.parseDate((CharSequence)expiryDate));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!(result = this.purchaseAttachmentService.saveAttachment(attachment))) continue;
                attachment.setAbsoluteFilePath(this.fileStoreSignServiceImpl.getDownloadPath(attachment.getFilePath(), attachment.getSaveType()));
                return Result.ok((Object)((Object)attachment));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_field_XVKm_24addeea", (String)"\u4e0a\u4f20\u5931\u8d25"));
    }

    public static void checkFileType(String fileName) {
        List<DictModel> attachmentExtension;
        List types;
        if (CharSequenceUtil.isBlank((CharSequence)fileName)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xRuXVVmRJQI_1ca55fd1", (String)"\u4e0d\u652f\u6301\u4e0a\u4f20\u7a7a\u767d\u540d\u5b57\u6587\u4ef6"));
        }
        String lastName = fileName;
        int last = lastName.lastIndexOf(".");
        if (last != -1) {
            lastName = lastName.substring(last);
        }
        if ((types = (attachmentExtension = ((DictService)SpringContextUtils.getBean(DictService.class)).queryDictItemsByCode("attachmentExtension", TenantContext.getTenant(), "1")).stream().map(DictModel::getValue).collect(Collectors.toList())).isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VGRQIXVAcWRJCJCAoL[attachmentExtension]_a8f3fc17", (String)"\u8bf7\u8bbe\u7f6e\u6587\u4ef6\u4e0a\u4f20\u7c7b\u578b\u9650\u5236\u5b57\u5178\uff0c\u5b57\u5178\u7f16\u7801\u4e3a[attachmentExtension]"));
        }
        if (!types.contains(lastName)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QIXVHRuIIQImK_780a03fb", (String)"\u6587\u4ef6\u4e0a\u4f20\u4ec5\u652f\u6301\u4e00\u4e0b\u6587\u4ef6\u683c\u5f0f:") + types);
        }
    }

    private void headBuilder(HttpServletResponse response, HttpServletRequest request, String filename) throws Exception {
        filename = request.getHeader("User-Agent").toUpperCase().indexOf("MSIE") > 0 ? URLEncoder.encode(filename, "UTF-8") : new String(filename.getBytes("UTF-8"), "ISO8859-1");
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Disposition", "attachment;filename=\"" + filename + "\"");
        response.setContentType("application/octet-stream");
    }

    @RequiresPermissions(value={"attachment#purchaseAttachment:download"})
    @AutoLog(value="\u91c7\u8d2d\u9644\u4ef6-\u4e0b\u8f7d", operateType=1)
    @GetMapping(value={"/download"})
    public void download(@RequestParam(name="id") String id, HttpServletResponse response, HttpServletRequest request) {
        PurchaseAttachment attachment = (PurchaseAttachment)((Object)this.purchaseAttachmentService.getById((Serializable)((Object)id)));
        try {
            if (attachment == null) {
                SaleAttachment saleAttachment = (SaleAttachment)((Object)this.saleAttachmentService.getById((Serializable)((Object)id)));
                if (saleAttachment == null) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QIxMK_bbc974ee", (String)"\u6587\u4ef6\u4e0d\u5b58\u5728"));
                }
                this.headBuilder(response, request, saleAttachment.getFileName());
                this.fileStoreSignServiceImpl.downloadFileWithOutput(response, (OutputStream)response.getOutputStream(), saleAttachment.getFilePath(), saleAttachment.getSaveType());
            } else {
                this.headBuilder(response, request, attachment.getFileName());
                this.fileStoreSignServiceImpl.downloadFileWithOutput(response, (OutputStream)response.getOutputStream(), attachment.getFilePath(), attachment.getSaveType());
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"attachment#purchaseAttachment:downloadZip"})
    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u6279\u91cf\u4e0b\u8f7d", operateType=1)
    @PostMapping(value={"/downloadZip"})
    public void downloadZip(@RequestBody List<String> ids, HttpServletResponse response) throws IOException {
        List saleAttachmentList;
        List<String> saleIds;
        List attachmentList = this.purchaseAttachmentService.listByIds(ids);
        if (CollUtil.isNotEmpty(ids) && attachmentList.size() != ids.size() && CollUtil.isNotEmpty(saleIds = CollUtil.isEmpty((Collection)attachmentList) ? ids : ids.stream().filter(vo -> !attachmentList.stream().map(my -> my.getId()).collect(Collectors.toList()).contains(vo)).collect(Collectors.toList())) && CollUtil.isNotEmpty((Collection)(saleAttachmentList = this.saleAttachmentService.listByIds(saleIds)))) {
            ArrayList attachments = SysUtil.copyProperties((List)saleAttachmentList, PurchaseAttachment.class);
            attachmentList.addAll(attachments);
        }
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.setContentType("application/zip");
        response.setHeader("Content-Disposition", "attachment; filename=\"downloadZip.zip\"");
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
        BufferedInputStream bufferedInputStream = null;
        int bufSize = 51200;
        HashMap<String, Integer> nameIndex = new HashMap<String, Integer>();
        for (PurchaseAttachment attachment : attachmentList) {
            try {
                int length;
                InputStream inputStream = this.fileStoreSignServiceImpl.downloadFileWithInputStream(attachment.getFilePath(), attachment.getSaveType());
                bufferedInputStream = new BufferedInputStream(inputStream, bufSize);
                byte[] data = new byte[bufSize];
                Integer count = (Integer)nameIndex.get(attachment.getFileName());
                if (null == count) {
                    count = 1;
                } else {
                    Integer n = count;
                    count = count + 1;
                }
                nameIndex.put(attachment.getFileName(), count);
                Object fileName = attachment.getFileName();
                if (count > 1) {
                    int index = ((String)fileName).lastIndexOf(".");
                    String name = ((String)fileName).substring(0, index);
                    String sux = ((String)fileName).substring(index);
                    fileName = name + "(" + count.toString() + ")" + sux;
                }
                ZipEntry zipEntry = new ZipEntry((String)fileName);
                zipOutputStream.putNextEntry(zipEntry);
                while ((length = bufferedInputStream.read(data)) != -1) {
                    zipOutputStream.write(data, 0, length);
                    response.flushBuffer();
                }
            }
            catch (Exception e) {
                log.error("{}\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25:{}", (Object)attachment.getFileName(), (Object)e.getMessage());
            }
        }
        try {
            if (null != bufferedInputStream) {
                bufferedInputStream.close();
            }
        }
        finally {
            zipOutputStream.flush();
            zipOutputStream.close();
        }
    }

    @AutoLog(value="\u91c7\u8d2d\u9644\u4ef6-\u4e0b\u8f7d", operateType=1)
    @GetMapping(value={"/noToken/download"})
    public void downloadNoToken(@RequestParam(name="id") String id, @RequestParam(name="key", required=false) String key, HttpServletResponse response, HttpServletRequest request) {
        if (StrUtil.isNotBlank((CharSequence)key)) {
            Object o = this.redisUtil.get("sys:attachment:expire:" + key);
            Assert.isTrue((o != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_KyIKXVVVSM_715b11d2", (String)"\u94fe\u63a5\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\uff01"));
        }
        try {
            PurchaseAttachment attachment = (PurchaseAttachment)((Object)this.purchaseAttachmentService.getById((Serializable)((Object)id)));
            if (attachment == null) {
                SaleAttachment saleAttachment = (SaleAttachment)((Object)this.saleAttachmentService.getById((Serializable)((Object)id)));
                if (saleAttachment == null) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QIxMK_bbc974ee", (String)"\u6587\u4ef6\u4e0d\u5b58\u5728"));
                }
                this.headBuilder(response, request, saleAttachment.getFileName());
                this.fileStoreSignServiceImpl.downloadFileWithOutput(response, (OutputStream)response.getOutputStream(), saleAttachment.getFilePath(), saleAttachment.getSaveType());
            } else {
                this.headBuilder(response, request, attachment.getFileName());
                this.fileStoreSignServiceImpl.downloadFileWithOutput(response, (OutputStream)response.getOutputStream(), attachment.getFilePath(), attachment.getSaveType());
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
        }
    }

    @RequiresPermissions(value={"attachment#purchaseAttachment:delete"})
    @AutoLog(value="\u91c7\u8d2d\u9644\u4ef6-\u5220\u9664", operateType=4)
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        PurchaseAttachment attachment = (PurchaseAttachment)((Object)this.purchaseAttachmentService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        if (null == attachment) {
            return this.commonSuccessResult(4);
        }
        String elsAccount = TenantContext.getTenant();
        Assert.isTrue((boolean)elsAccount.equals(attachment.getUploadElsAccount()), (String)I18nUtil.translate((String)"i18n_alert_uvCXVQIWxqQG_7e96bcc2", (String)"\u975e\u672c\u65b9\u4e0a\u4f20\u6587\u4ef6\uff0c\u4e0d\u53ef\u5220\u9664"));
        Assert.isTrue((boolean)"0".equals(attachment.getSendStatus()), (String)I18nUtil.translate((String)"i18n_alert_IhdjQIWxqQG_29a7fa21", (String)"\u5df2\u53d1\u9001\u7684\u6587\u4ef6\uff0c\u4e0d\u53ef\u5220\u9664"));
        this.fileStoreSignServiceImpl.delete(attachment.getFilePath(), attachment.getSaveType());
        this.purchaseAttachmentService.delPurchaseAttachment(id);
        return this.commonSuccessResult(4);
    }

    @RequiresPermissions(value={"attachment#purchaseAttachment:deleteBatch"})
    @AutoLog(value="\u91c7\u8d2d\u9644\u4ef6-\u6279\u91cf\u5220\u9664", operateType=4)
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List purchaseAttachmentList;
        List<String> idList = Arrays.asList(ids.split(","));
        ArrayList<String> filePaths = new ArrayList<String>();
        String elsAccount = TenantContext.getTenant();
        if (CollectionUtil.isNotEmpty(idList) && CollectionUtil.isNotEmpty((Collection)(purchaseAttachmentList = this.purchaseAttachmentService.listByIds(idList)))) {
            for (PurchaseAttachment purchaseAttachment : purchaseAttachmentList) {
                Assert.isTrue((boolean)"0".equals(purchaseAttachment.getSendStatus()), (String)I18nUtil.translate((String)"i18n__QIWWWWWWIhdWxqQG_99c3bdd", (String)"\u6587\u4ef6[${0}]\u5df2\u53d1\u9001\uff0c\u4e0d\u53ef\u5220\u9664", (String[])new String[]{purchaseAttachment.getFileName()}));
                Assert.isTrue((boolean)elsAccount.equals(purchaseAttachment.getUploadElsAccount()), (String)I18nUtil.translate((String)"i18n_alert_QI[0]uvCXVQIxqQG_6ae1f04f", (String)"\u6587\u4ef6[${0}]\u975e\u672c\u65b9\u4e0a\u4f20\u6587\u4ef6\uff0c\u4e0d\u53ef\u5220\u9664", (String[])new String[]{purchaseAttachment.getFileName()}));
                filePaths.add(purchaseAttachment.getFilePath());
            }
        }
        this.fileStoreSignServiceImpl.deleteFileBatch(filePaths, null);
        this.purchaseAttachmentService.delBatchPurchaseAttachment(idList);
        return this.commonSuccessResult(4);
    }

    @RequiresPermissions(value={"attachment#purchaseAttachment:queryById"})
    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseAttachment attachmentBuy = (PurchaseAttachment)((Object)this.purchaseAttachmentService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        List<PurchaseAttachmentRecord> purchaseAttachmentRecordList = this.purchaseAttachmentRecordService.selectByMainId(id);
        PurchaseAttachmentVO attachmentVO = new PurchaseAttachmentVO();
        BeanUtil.copyProperties((Object)((Object)attachmentBuy), (Object)((Object)attachmentVO), (String[])new String[0]);
        attachmentVO.setPurchaseAttachmentRecordList(purchaseAttachmentRecordList);
        return Result.ok((Object)((Object)attachmentVO));
    }

    @RequiresPermissions(value={"attachment#purchaseAttachment:send"})
    @AutoLog(value="\u91c7\u8d2d\u9644\u4ef6-\u9644\u4ef6\u53d1\u9001", operateType=3)
    @Operation(summary="\u9644\u4ef6\u53d1\u9001", description="\u9644\u4ef6\u53d1\u9001")
    @PostMapping(value={"/send"})
    public Result<?> send(@RequestBody AttachmentSendVO sendVO) {
        this.purchaseAttachmentService.sendFile(sendVO);
        return this.commonSuccessResult(4);
    }

    @RequiresPermissions(value={"attachment#purchaseAttachment:getSignature"})
    @Operation(summary="\u83b7\u53d6\u6587\u4ef6\u7684\u9884\u89c8\u94fe\u63a5", description="\u83b7\u53d6\u6587\u4ef6\u7684\u9884\u89c8\u94fe\u63a5")
    @RequestMapping(value={"/getSignature"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Result<?> getSignature(@RequestBody PurchaseAttachment purchaseAttachment, HttpServletRequest request) {
        String signature = null;
        String header = request.getHeader("X-Access-Token");
        PurchaseAttachment dbPurchaseAttachment = (PurchaseAttachment)((Object)this.purchaseAttachmentService.getById((Serializable)((Object)purchaseAttachment.getId())));
        if (dbPurchaseAttachment == null) {
            SaleAttachment dbSaleAttachment = (SaleAttachment)((Object)this.saleAttachmentService.getById((Serializable)((Object)purchaseAttachment.getId())));
            if (dbSaleAttachment == null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QIxMK_bbc974ee", (String)"\u6587\u4ef6\u4e0d\u5b58\u5728"));
            }
            signature = SERVICE_ADDRESS + "/els/attachment/saleAttachment/download?id=" + dbSaleAttachment.getId() + "&fullfilename=" + dbSaleAttachment.getFileName().replace("&", "@") + "&token=" + header;
        } else {
            signature = SERVICE_ADDRESS + "/els/attachment/purchaseAttachment/download?id=" + dbPurchaseAttachment.getId() + "&fullfilename=" + dbPurchaseAttachment.getFileName().replace("&", "@") + "&token=" + header;
        }
        return Result.ok((String)signature.replace("\\", "/"));
    }

    @RequiresPermissions(value={"attachment#purchaseAttachment:download"})
    @Operation(summary="\u83b7\u53d6\u6587\u4ef6\u7684\u4e0b\u8f7d\u8def\u5f84", description="\u83b7\u53d6\u6587\u4ef6\u7684\u4e0b\u8f7d\u8def\u5f84")
    @GetMapping(value={"/getDownLoadUrl"})
    @ResponseBody
    public Result<?> getDownLoadUrl(@RequestParam(value="id") String id) {
        String signature = null;
        PurchaseAttachment dbPurchaseAttachment = (PurchaseAttachment)((Object)this.purchaseAttachmentService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        if (dbPurchaseAttachment == null) {
            SaleAttachment dbSaleAttachment = (SaleAttachment)((Object)this.saleAttachmentService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
            if (dbSaleAttachment == null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QIxMK_bbc974ee", (String)"\u6587\u4ef6\u4e0d\u5b58\u5728"));
            }
            signature = "/attachment/saleAttachment/download?id=" + dbSaleAttachment.getId();
        } else {
            signature = "/attachment/purchaseAttachment/download?id=" + dbPurchaseAttachment.getId();
        }
        return Result.ok((String)signature.replace("\\", "/"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresPermissions(value={"attachment#purchaseAttachment:getSignature"})
    @Operation(summary="\u83b7\u53d6\u5b89\u5168\u7684\u6587\u4ef6\u7684\u9884\u89c8\u94fe\u63a5", description="\u83b7\u53d6\u5b89\u5168\u7684\u6587\u4ef6\u9884\u89c8\u94fe\u63a5")
    @GetMapping(value={"/getSignatureSafe"})
    public Result<?> getSignatureSafe(PurchaseAttachment purchaseAttachment, HttpServletRequest request) {
        String signature = null;
        if (StrUtil.isNotBlank((CharSequence)purchaseAttachment.getSaveType()) && StrUtil.isNotBlank((CharSequence)purchaseAttachment.getFilePath())) {
            signature = this.fileStoreSignServiceImpl.loadDownloadSafePath(purchaseAttachment.getFilePath(), purchaseAttachment.getFileName(), purchaseAttachment.getSaveType());
            return Result.ok(signature);
        } else {
            if (!StrUtil.isNotBlank((CharSequence)purchaseAttachment.getId())) return Result.ok(signature);
            PurchaseAttachment attachmentServiceById = (PurchaseAttachment)((Object)this.purchaseAttachmentService.getById((Serializable)((Object)purchaseAttachment.getId())));
            if (attachmentServiceById == null) {
                SaleAttachment byId = (SaleAttachment)((Object)this.saleAttachmentService.getById((Serializable)((Object)purchaseAttachment.getId())));
                if (byId == null) {
                    String fileAddress = request.getParameter("fileAddress");
                    if (!StrUtil.isNotBlank((CharSequence)fileAddress)) throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QIxMK_bbc974ee", (String)"\u6587\u4ef6\u4e0d\u5b58\u5728"));
                    if (!StrUtil.isNotBlank((CharSequence)(fileAddress = fileAddress.substring(0, fileAddress.indexOf("-")))) || !StrUtil.isNumeric((CharSequence)fileAddress)) throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QIxMK_bbc974ee", (String)"\u6587\u4ef6\u4e0d\u5b58\u5728"));
                    PurchaseAttachment attachment = (PurchaseAttachment)((Object)this.purchaseAttachmentService.getById((Serializable)((Object)fileAddress)));
                    if (attachment == null) {
                        SaleAttachment saleAttachment = (SaleAttachment)((Object)this.saleAttachmentService.getById((Serializable)((Object)fileAddress)));
                        if (saleAttachment == null) throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QIxMK_bbc974ee", (String)"\u6587\u4ef6\u4e0d\u5b58\u5728"));
                        signature = this.fileStoreSignServiceImpl.loadDownloadSafePath(saleAttachment.getFilePath(), saleAttachment.getFileName(), saleAttachment.getSaveType());
                        return Result.ok(signature);
                    } else {
                        signature = this.fileStoreSignServiceImpl.loadDownloadSafePath(attachment.getFilePath(), attachment.getFileName(), attachment.getSaveType());
                    }
                    return Result.ok(signature);
                } else {
                    signature = this.fileStoreSignServiceImpl.loadDownloadSafePath(byId.getFilePath(), byId.getFileName(), byId.getSaveType());
                }
                return Result.ok(signature);
            } else {
                signature = this.fileStoreSignServiceImpl.loadDownloadSafePath(attachmentServiceById.getFilePath(), attachmentServiceById.getFileName(), attachmentServiceById.getSaveType());
            }
        }
        return Result.ok(signature);
    }

    @AutoLog(value="\u6587\u4ef6\u4e0a\u4f20", operateType=2)
    @Operation(summary="\u4e0a\u4f20\u6587\u4ef6", description="\u4e0a\u4f20\u6587\u4ef6")
    @RequestMapping(value={"/noToken/uploadFile"}, method={RequestMethod.POST})
    public Result<?> uploadFile(HttpServletRequest request, HttpServletResponse response) {
        block8: {
            String fileType = request.getParameter("fileType");
            String attachmentVersion = request.getParameter("attachmentVersion");
            String effectiveDate = request.getParameter("effectiveDate");
            String expiryDate = request.getParameter("expiryDate");
            String sourceNumber = request.getParameter("sourceNumber");
            String actionRoutePath = request.getParameter("actionRoutePath");
            String saveType = request.getParameter("saveType");
            String caType = request.getParameter("caType");
            response.setHeader("X-XSS-Protection", "1; mode=block");
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            Map fileMap = multipartRequest.getFileMap();
            try {
                Iterator iterator = fileMap.entrySet().iterator();
                if (!iterator.hasNext()) break block8;
                Map.Entry entity = iterator.next();
                MultipartFile uploadFile = (MultipartFile)entity.getValue();
                StorageFileInfo fileInfo = this.fileStoreSignServiceImpl.storeFile(uploadFile, null, saveType, caType);
                PurchaseAttachment attachment = new PurchaseAttachment();
                if (StrUtil.isNotBlank((CharSequence)fileInfo.getId())) {
                    attachment.setId(fileInfo.getId());
                }
                if (CharSequenceUtil.isEmpty((CharSequence)fileType)) {
                    fileType = "5";
                }
                attachment.setFileType(fileType);
                attachment.setUploadSubAccount("100000");
                attachment.setUploadElsAccount("100000");
                attachment.setFileName(uploadFile.getOriginalFilename());
                attachment.setFileSize(String.valueOf(uploadFile.getSize()));
                attachment.setFilePath(fileInfo.getPath());
                attachment.setSaveType(fileInfo.getSaveType());
                attachment.setSendStatus("0");
                attachment.setReceiveStatus("0");
                attachment.setUploadTime(new Date());
                attachment.setSourceType("1");
                attachment.setAttachmentVersion(attachmentVersion);
                attachment.setActionRoutePath(actionRoutePath);
                attachment.setSourceNumber(sourceNumber);
                SysUtil.checkFileType((String)uploadFile.getOriginalFilename());
                try {
                    attachment.setEffectiveDate((Date)DateUtil.parseDate((CharSequence)effectiveDate));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    attachment.setExpiryDate((Date)DateUtil.parseDate((CharSequence)expiryDate));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                attachment.setAbsoluteFilePath(this.fileStoreSignServiceImpl.getDownloadPath(attachment.getFilePath(), attachment.getSaveType()));
                return Result.ok((Object)((Object)attachment));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return Result.error((String)e.getMessage());
            }
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_field_XVKm_24addeea", (String)"\u4e0a\u4f20\u5931\u8d25"));
    }
}

