/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.barcode.entity.BarcodeSupplierList;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoDetail;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoHead;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoItem;
import com.els.modules.barcode.entity.SaleBarcodeInfoDetail;
import com.els.modules.barcode.entity.SaleBarcodeInfoHead;
import com.els.modules.barcode.entity.SaleBarcodeInfoItem;
import com.els.modules.barcode.mapper.SaleBarcodeInfoDetailMapper;
import com.els.modules.barcode.mapper.SaleBarcodeInfoHeadMapper;
import com.els.modules.barcode.mapper.SaleBarcodeInfoItemMapper;
import com.els.modules.barcode.service.SaleBarcodeInfoDetailService;
import com.els.modules.barcode.service.SaleBarcodeInfoHeadService;
import com.els.modules.barcode.service.SaleBarcodeInfoItemService;
import com.els.modules.barcode.service.SaleBarcodePoolHeadService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleBarcodeInfoHeadServiceImpl
extends BaseServiceImpl<SaleBarcodeInfoHeadMapper, SaleBarcodeInfoHead>
implements SaleBarcodeInfoHeadService {
    @Autowired
    private SaleBarcodeInfoHeadMapper saleBarcodeInfoHeadMapper;
    @Autowired
    private SaleBarcodeInfoItemMapper saleBarcodeInfoItemMapper;
    @Autowired
    private SaleBarcodeInfoItemService saleBarcodeInfoItemService;
    @Autowired
    private SaleBarcodeInfoDetailMapper saleBarcodeInfoDetailMapper;
    @Autowired
    private SaleBarcodeInfoDetailService saleBarcodeInfoDetailService;
    @Autowired
    private SaleBarcodePoolHeadService saleBarcodePoolHeadService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(SaleBarcodeInfoHead saleBarcodeInfoHead, List<SaleBarcodeInfoItem> saleBarcodeInfoItemList, List<SaleBarcodeInfoDetail> sysBarcodeList, List<SaleBarcodeInfoDetail> customBarcodeList) {
        this.saleBarcodeInfoHeadMapper.insert((Object)saleBarcodeInfoHead);
        this.insertData(saleBarcodeInfoHead, saleBarcodeInfoItemList, sysBarcodeList, customBarcodeList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(SaleBarcodeInfoHead saleBarcodeInfoHead, List<SaleBarcodeInfoItem> saleBarcodeInfoItemList, List<SaleBarcodeInfoDetail> sysBarcodeList, List<SaleBarcodeInfoDetail> customBarcodeList) {
        int count = this.saleBarcodeInfoHeadMapper.updateById((Object)saleBarcodeInfoHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.saleBarcodeInfoItemMapper.deleteByMainId(saleBarcodeInfoHead.getId());
        this.saleBarcodeInfoDetailMapper.deleteByMainId(saleBarcodeInfoHead.getId());
        this.insertData(saleBarcodeInfoHead, saleBarcodeInfoItemList, sysBarcodeList, customBarcodeList);
    }

    private void insertData(SaleBarcodeInfoHead saleBarcodeInfoHead, List<SaleBarcodeInfoItem> saleBarcodeInfoItemList, List<SaleBarcodeInfoDetail> sysBarcodeList, List<SaleBarcodeInfoDetail> customBarcodeList) {
        if (saleBarcodeInfoItemList != null && !saleBarcodeInfoItemList.isEmpty()) {
            for (SaleBarcodeInfoItem saleBarcodeInfoItem : saleBarcodeInfoItemList) {
                saleBarcodeInfoItem.setHeadId(saleBarcodeInfoHead.getId());
                SysUtil.setSysParam((BaseEntity)saleBarcodeInfoItem, (BaseEntity)saleBarcodeInfoHead);
            }
            this.saleBarcodeInfoItemService.saveBatch(saleBarcodeInfoItemList);
        }
        if (sysBarcodeList != null && !sysBarcodeList.isEmpty()) {
            for (SaleBarcodeInfoDetail saleBarcodeInfoDetail : sysBarcodeList) {
                saleBarcodeInfoDetail.setHeadId(saleBarcodeInfoHead.getId());
                saleBarcodeInfoDetail.setBarcodeType(1);
                SysUtil.setSysParam((BaseEntity)saleBarcodeInfoDetail, (BaseEntity)saleBarcodeInfoHead);
            }
            if (customBarcodeList != null && !customBarcodeList.isEmpty()) {
                for (SaleBarcodeInfoDetail saleBarcodeInfoDetail : customBarcodeList) {
                    saleBarcodeInfoDetail.setHeadId(saleBarcodeInfoHead.getId());
                    saleBarcodeInfoDetail.setBarcodeType(2);
                    SysUtil.setSysParam((BaseEntity)saleBarcodeInfoDetail, (BaseEntity)saleBarcodeInfoHead);
                }
                sysBarcodeList.addAll(customBarcodeList);
            }
            this.saleBarcodeInfoDetailService.saveBatch(sysBarcodeList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.saleBarcodeInfoItemMapper.deleteByMainId(id);
        this.saleBarcodeInfoDetailMapper.deleteByMainId(id);
        this.saleBarcodeInfoHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleBarcodeInfoItemMapper.deleteByMainId(serializable.toString());
            this.saleBarcodeInfoDetailMapper.deleteByMainId(serializable.toString());
            this.saleBarcodeInfoHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, SaleBarcodeInfoHead> addByPurchase(PurchaseBarcodeInfoHead purchaseBarcodeInfoHead, List<PurchaseBarcodeInfoItem> purchaseBarcodeInfoItemList, List<PurchaseBarcodeInfoDetail> sysBarcodeList, List<PurchaseBarcodeInfoDetail> customBarcodeList, List<BarcodeSupplierList> barcodeSupplierListList, boolean isSavePool) {
        HashMap<String, SaleBarcodeInfoHead> supplierBarcodeHeadMap = new HashMap<String, SaleBarcodeInfoHead>();
        ArrayList<SaleBarcodeInfoHead> headList = new ArrayList<SaleBarcodeInfoHead>();
        ArrayList<SaleBarcodeInfoItem> itemList = new ArrayList<SaleBarcodeInfoItem>();
        ArrayList<SaleBarcodeInfoDetail> detailList = new ArrayList<SaleBarcodeInfoDetail>();
        ArrayList<SaleBarcodeInfoDetail> sysDetailList = new ArrayList<SaleBarcodeInfoDetail>();
        for (BarcodeSupplierList supplier : barcodeSupplierListList) {
            SaleBarcodeInfoHead saleBarcodeInfoHead = new SaleBarcodeInfoHead();
            BeanUtils.copyProperties((Object)((Object)purchaseBarcodeInfoHead), (Object)((Object)saleBarcodeInfoHead));
            saleBarcodeInfoHead.setRelationId(purchaseBarcodeInfoHead.getId());
            saleBarcodeInfoHead.setElsAccount(supplier.getToElsAccount());
            saleBarcodeInfoHead.setToElsAccount(purchaseBarcodeInfoHead.getElsAccount());
            saleBarcodeInfoHead.setSupplierName(supplier.getSupplierName());
            saleBarcodeInfoHead.setSupplierCode(supplier.getSupplierCode());
            saleBarcodeInfoHead.setId(null);
            headList.add(saleBarcodeInfoHead);
            supplierBarcodeHeadMap.put(supplier.getToElsAccount(), saleBarcodeInfoHead);
        }
        this.saveBatch(headList);
        for (BarcodeSupplierList supplier : barcodeSupplierListList) {
            SaleBarcodeInfoDetail saleBarcodeInfoDetail;
            if (purchaseBarcodeInfoItemList != null && purchaseBarcodeInfoItemList.size() > 0) {
                for (PurchaseBarcodeInfoItem purchaseBarcodeInfoItem : purchaseBarcodeInfoItemList) {
                    SaleBarcodeInfoItem saleBarcodeInfoItem = new SaleBarcodeInfoItem();
                    BeanUtils.copyProperties((Object)((Object)purchaseBarcodeInfoItem), (Object)((Object)saleBarcodeInfoItem));
                    saleBarcodeInfoItem.setHeadId(((SaleBarcodeInfoHead)((Object)supplierBarcodeHeadMap.get(supplier.getToElsAccount()))).getId());
                    saleBarcodeInfoItem.setRelationId(purchaseBarcodeInfoItem.getId());
                    saleBarcodeInfoItem.setElsAccount(supplier.getToElsAccount());
                    saleBarcodeInfoItem.setToElsAccount(purchaseBarcodeInfoHead.getElsAccount());
                    saleBarcodeInfoItem.setSupplierName(supplier.getSupplierName());
                    saleBarcodeInfoItem.setSupplierCode(supplier.getSupplierCode());
                    saleBarcodeInfoItem.setId(null);
                    itemList.add(saleBarcodeInfoItem);
                }
            }
            if (sysBarcodeList == null || sysBarcodeList.size() <= 0) continue;
            for (PurchaseBarcodeInfoDetail purchaseBarcodeInfoDetail : sysBarcodeList) {
                saleBarcodeInfoDetail = new SaleBarcodeInfoDetail();
                BeanUtils.copyProperties((Object)((Object)purchaseBarcodeInfoDetail), (Object)((Object)saleBarcodeInfoDetail));
                saleBarcodeInfoDetail.setHeadId(((SaleBarcodeInfoHead)((Object)supplierBarcodeHeadMap.get(supplier.getToElsAccount()))).getId());
                saleBarcodeInfoDetail.setRelationId(purchaseBarcodeInfoDetail.getId());
                saleBarcodeInfoDetail.setElsAccount(supplier.getToElsAccount());
                saleBarcodeInfoDetail.setToElsAccount(purchaseBarcodeInfoHead.getElsAccount());
                saleBarcodeInfoDetail.setSupplierName(supplier.getSupplierName());
                saleBarcodeInfoDetail.setSupplierCode(supplier.getSupplierCode());
                saleBarcodeInfoDetail.setId(null);
                detailList.add(saleBarcodeInfoDetail);
                sysDetailList.add(saleBarcodeInfoDetail);
            }
            if (customBarcodeList == null || customBarcodeList.size() <= 0) continue;
            for (PurchaseBarcodeInfoDetail purchaseBarcodeInfoDetail : customBarcodeList) {
                saleBarcodeInfoDetail = new SaleBarcodeInfoDetail();
                BeanUtils.copyProperties((Object)((Object)purchaseBarcodeInfoDetail), (Object)((Object)saleBarcodeInfoDetail));
                saleBarcodeInfoDetail.setHeadId(((SaleBarcodeInfoHead)((Object)supplierBarcodeHeadMap.get(supplier.getToElsAccount()))).getId());
                saleBarcodeInfoDetail.setElsAccount(supplier.getToElsAccount());
                saleBarcodeInfoDetail.setToElsAccount(purchaseBarcodeInfoHead.getElsAccount());
                saleBarcodeInfoDetail.setSupplierName(supplier.getSupplierName());
                saleBarcodeInfoDetail.setSupplierCode(supplier.getSupplierCode());
                saleBarcodeInfoDetail.setId(null);
                detailList.add(saleBarcodeInfoDetail);
            }
        }
        this.saleBarcodeInfoItemService.saveBatch(itemList);
        this.saleBarcodeInfoDetailService.saveBatch(detailList);
        if (isSavePool) {
            Map<String, List<SaleBarcodeInfoItem>> itemMap = itemList.stream().collect(Collectors.groupingBy(ParentEntity::getElsAccount));
            Map<String, List<SaleBarcodeInfoDetail>> sysDetailMap = sysDetailList.stream().collect(Collectors.groupingBy(ParentEntity::getElsAccount));
            this.saleBarcodePoolHeadService.addByBarcodeInfo(supplierBarcodeHeadMap, itemMap, sysDetailMap);
        }
        return supplierBarcodeHeadMap;
    }
}

