/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.base.api.service.impl;

import cn.hutool.core.convert.Convert;
import com.els.common.aspect.annotation.RpcService;
import com.els.modules.attachment.storage.StorageFileInfo;
import com.els.modules.attachment.storage.service.FileStoreSignService;
import com.els.modules.base.api.dto.StorageFileInfoDTO;
import com.els.modules.base.api.service.FileRpcService;
import jakarta.annotation.Resource;
import java.io.InputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RpcService
public class FileBeanServiceImpl
implements FileRpcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileBeanServiceImpl.class);
    @Resource(name="fileStoreSignServiceImpl")
    private FileStoreSignService fileStoreSignServiceImpl;

    public String uploadFiles(byte[] bytes, String remothPath, String documentName) {
        try {
            StorageFileInfo fileInfo = new StorageFileInfo();
            fileInfo.setOriginalFilename(documentName);
            fileInfo.setFilename(documentName);
            fileInfo.setPath(remothPath);
            fileInfo.setSize(Long.valueOf(bytes.length));
            this.fileStoreSignServiceImpl.storeFile(bytes, fileInfo, null);
            return remothPath;
        }
        catch (Exception e) {
            log.error(":::{}", (Object)e.getMessage());
            return remothPath;
        }
    }

    public StorageFileInfoDTO storeFile(InputStream inputStream, String originalFilename, String filename, String path, String type) {
        try {
            StorageFileInfo fileInfo = new StorageFileInfo();
            fileInfo.setOriginalFilename(originalFilename);
            fileInfo.setFilename(filename);
            fileInfo.setPath(path);
            StorageFileInfo storageFileInfo = this.fileStoreSignServiceImpl.storeFile(inputStream, fileInfo, type);
            return (StorageFileInfoDTO)Convert.convert(StorageFileInfoDTO.class, (Object)storageFileInfo);
        }
        catch (Exception e) {
            log.error(":::{}", (Object)e.getMessage());
            return null;
        }
    }

    public String uploadFiles(byte[] bytes, String remothPath, String documentName, String type) {
        try {
            StorageFileInfo fileInfo = new StorageFileInfo();
            fileInfo.setOriginalFilename(documentName);
            fileInfo.setFilename(documentName);
            fileInfo.setPath(remothPath);
            fileInfo.setSize(Long.valueOf(bytes.length));
            this.fileStoreSignServiceImpl.storeFile(bytes, fileInfo, type);
            return remothPath;
        }
        catch (Exception e) {
            log.error(":::uploadFiles error{}", (Throwable)e);
            return remothPath;
        }
    }

    public String getRealPath(String path, String type, boolean safe) {
        if (safe) {
            return this.fileStoreSignServiceImpl.loadDownloadSafePath(path, null, type);
        }
        return this.fileStoreSignServiceImpl.getDownloadPath(path, type);
    }
}

