/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.ParentEntityDTO;
import com.els.common.api.service.AlertGroovyHandler;
import com.els.common.api.service.AlertRpcService;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.util.BusMessageUtil;
import com.els.common.util.SrmRpcUtil;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.supplier.api.service.SupplierRpcService;
import com.els.modules.system.entity.ElsAlertConfig;
import com.els.modules.system.entity.ElsAlertRecord;
import com.els.modules.system.enums.AlertFrequencyEnum;
import com.els.modules.system.enums.AlertNoticeObjectEnum;
import com.els.modules.system.rpc.service.JobExecuteService;
import com.els.modules.system.rpc.service.JobInvokeAccountRpcService;
import com.els.modules.system.service.AlertService;
import com.els.modules.system.service.ElsAlertRecordService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlertServiceImpl
implements AlertService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlertServiceImpl.class);
    @Autowired
    private ElsAlertRecordService elsAlertRecordService;
    @Resource
    private JobInvokeAccountRpcService jobInvokeAccountRpcService;
    @Resource
    private JobExecuteService jobExecuteService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void runAlert(ElsAlertConfig alertConfig) {
        AlertListBuilder result = this.getAlertList(alertConfig);
        List<?> alertList = result.getAlertList();
        for (int i = 0; i < alertList.size(); ++i) {
            Object obj = alertList.get(i);
            String urlParam = result.getUrlMap().get(i);
            boolean exeFlag = this.getExeFlag(alertConfig, obj);
            if (!exeFlag) continue;
            this.addAlertRecord(alertConfig, obj);
            JSONObject msgObj = new JSONObject();
            msgObj.put("msgKey", (Object)IdWorker.getIdStr());
            msgObj.put("busAccount", (Object)alertConfig.getElsAccount());
            msgObj.put("businessType", (Object)"alert");
            msgObj.put("operateType", (Object)"notice");
            msgObj.put("msgConfigHeadId", (Object)alertConfig.getId());
            msgObj.put("businessObj", obj);
            JSONObject sendObj = new JSONObject();
            sendObj.put("elsAccount", (Object)alertConfig.getElsAccount());
            sendObj.put("subAccount", (Object)"system");
            sendObj.put("realname", (Object)"system");
            msgObj.put("sendObj", (Object)sendObj);
            List<ElsSubAccountDTO> accountList = this.getReceiverAccountList(alertConfig, obj);
            Map<String, List<ElsSubAccountDTO>> accountMap = accountList.stream().collect(Collectors.groupingBy(ParentEntityDTO::getElsAccount));
            JSONArray array = new JSONArray();
            log.error("\u9884\u8b66\u6d88\u606f\u53d1\u9001----\u6d88\u606f\u914d\u7f6e:" + JSONObject.toJSONString((Object)((Object)alertConfig)) + "------->\u901a\u77e5\u4eba\u5217\u8868:" + JSONObject.toJSONString(accountMap));
            for (String elsAccount : accountMap.keySet()) {
                List<ElsSubAccountDTO> list = accountMap.get(elsAccount);
                JSONObject receiveObj = new JSONObject();
                receiveObj.put("toElsAccount", (Object)elsAccount);
                receiveObj.put("urlParam", (Object)urlParam);
                receiveObj.put("toSubAccountList", (Object)JSONObject.parseArray((String)JSON.toJSONString(list)));
                array.add((Object)receiveObj);
            }
            msgObj.put("receiveList", (Object)array);
            BusMessageUtil.sendBusMsg((String)msgObj.toJSONString(), (String)alertConfig.getId());
        }
    }

    private void addAlertRecord(ElsAlertConfig alertConfig, Object obj) {
        ElsAlertRecord record = new ElsAlertRecord();
        record.setElsAccount(alertConfig.getElsAccount());
        record.setAlertCofigId(alertConfig.getId());
        record.setBusinessId((String)BeanUtil.getProperty((Object)obj, (String)"id"));
        record.setAlertTime(new Date());
        this.elsAlertRecordService.save((Object)record);
    }

    private boolean getExeFlag(ElsAlertConfig alertConfig, Object obj) {
        String id = (String)BeanUtil.getProperty((Object)obj, (String)"id");
        List recordList = this.elsAlertRecordService.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)alertConfig.getElsAccount())).eq((Object)"alert_cofig_id", (Object)alertConfig.getId())).eq((Object)"business_id", (Object)id)).orderByDesc((Object)"alert_time"));
        if (recordList.isEmpty()) {
            return true;
        }
        String alertFrequency = alertConfig.getAlertFrequency();
        if (AlertFrequencyEnum.ONCE.getCode().equals(alertFrequency)) {
            return false;
        }
        if (AlertFrequencyEnum.DAY.getCode().equals(alertFrequency)) {
            return true;
        }
        if (AlertFrequencyEnum.WEEK.getCode().equals(alertFrequency)) {
            return this.compare((ElsAlertRecord)((Object)recordList.get(0)), 7);
        }
        if (AlertFrequencyEnum.MONTH.getCode().equals(alertFrequency)) {
            return this.compare((ElsAlertRecord)((Object)recordList.get(0)), 30);
        }
        return false;
    }

    private boolean compare(ElsAlertRecord record, int days) {
        String date2;
        Date alertTime = record.getAlertTime();
        DateTime checkDate = DateUtil.offsetDay((Date)alertTime, (int)days);
        String date1 = DateUtil.formatDate((Date)checkDate);
        return date1.compareTo(date2 = DateUtil.formatDate((Date)new Date())) <= 0;
    }

    private List<ElsSubAccountDTO> getReceiverAccountList(ElsAlertConfig alertConfig, Object obj) {
        ElsSubAccountDTO subAccount;
        List<String> userIdsByGroovy2;
        List<String> userIdsByGroovy;
        ElsSubAccountDTO account;
        String createById;
        ArrayList<Object> list = new ArrayList<ElsSubAccountDTO>();
        if (StrUtil.isNotBlank((CharSequence)alertConfig.getNoticeUser())) {
            String[] userIds;
            for (String userId : userIds = alertConfig.getNoticeUser().split(",")) {
                this.addSubAccount(list, userId);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)alertConfig.getNoticeRole())) {
            list.addAll(this.jobInvokeAccountRpcService.getAccountListByRoles(alertConfig.getNoticeRole()));
        }
        list.addAll(this.getPrincipalList(obj, alertConfig));
        JSONObject json = JSONObject.parseObject((String)JSONObject.toJSONString((Object)obj));
        String noticeObjPur = null;
        String noticeObjSale = null;
        String scriptPur = null;
        String scriptSale = null;
        String principalCode = "purchasePrincipal";
        String principalCodeSale = "salePrincipal";
        ArrayList<String> arrayList = new ArrayList<String>();
        noticeObjPur = alertConfig == null ? "" : alertConfig.getPurchaseNoticeObj();
        scriptPur = alertConfig == null ? "" : alertConfig.getPurScenario();
        noticeObjSale = alertConfig == null ? "" : alertConfig.getSaleNoticeObj();
        String string = scriptSale = alertConfig == null ? "" : alertConfig.getSaleScenario();
        if (noticeObjPur == null) {
            noticeObjPur = "";
        }
        if (noticeObjSale == null) {
            noticeObjSale = "";
        }
        if (noticeObjPur.contains(AlertNoticeObjectEnum.CREATE_BY.getValue()) && StrUtil.isNotBlank((CharSequence)(createById = json.getString("createById")))) {
            arrayList.add(createById);
        }
        if (noticeObjPur.contains(AlertNoticeObjectEnum.PRINCIPAL_BY.getValue())) {
            String principal = json.getString(principalCode);
            if (StrUtil.isBlank((CharSequence)principal) && json.containsKey((Object)"principal")) {
                principal = json.getString("principal");
            }
            if (StrUtil.isBlank((CharSequence)principal) && json.containsKey((Object)"personInCharge")) {
                principal = json.getString("personInCharge");
            }
            if (StrUtil.isNotBlank((CharSequence)principal)) {
                if (principal.contains("_")) {
                    principal = principal.split("_")[0];
                }
                if ((account = this.invokeAccountRpcService.getAccount(json.getString("elsAccount"), principal)) != null) {
                    arrayList.add(account.getId());
                }
            }
        }
        if (noticeObjSale.contains(AlertNoticeObjectEnum.PRINCIPAL_BY.getValue())) {
            String principalSale = json.getString(principalCodeSale);
            if (StrUtil.isBlank((CharSequence)principalSale) && json.containsKey((Object)"principal")) {
                principalSale = json.getString("principal");
            }
            if (StrUtil.isNotBlank((CharSequence)principalSale)) {
                if (principalSale.contains("_")) {
                    principalSale = principalSale.split("_")[0];
                }
                if ((account = this.invokeAccountRpcService.getAccount(json.getString("elsAccount"), principalSale)) != null) {
                    arrayList.add(account.getId());
                }
            }
        }
        if (noticeObjPur.contains(AlertNoticeObjectEnum.ASSIGNEE.getValue()) && alertConfig != null && StrUtil.isNotBlank((CharSequence)alertConfig.getNoticeUser())) {
            arrayList.addAll(Arrays.asList(alertConfig.getNoticeUser().split(",")));
        }
        if (noticeObjPur.contains(AlertNoticeObjectEnum.SCRIPT.getValue()) && StrUtil.isNotBlank((CharSequence)scriptPur) && (userIdsByGroovy = this.getUserIdsByGroovy(scriptPur, json)) != null) {
            arrayList.addAll(userIdsByGroovy);
        }
        if (noticeObjSale.contains(AlertNoticeObjectEnum.SCRIPT.getValue()) && StrUtil.isNotBlank((CharSequence)scriptSale) && (userIdsByGroovy2 = this.getUserIdsByGroovy(scriptSale, json)) != null) {
            arrayList.addAll(userIdsByGroovy2);
        }
        if (noticeObjSale.contains(AlertNoticeObjectEnum.JOB_FUNCTION.getValue()) && alertConfig != null && StrUtil.isNotBlank((CharSequence)alertConfig.getNoticeToFunction()) && (json.containsKey((Object)"busAccount") || json.containsKey((Object)"elsAccount")) && json.containsKey((Object)"toElsAccount")) {
            ElsSubAccountDTO subAccount2;
            String elsAccount = json.getString("busAccount") == null ? json.getString("elsAccount") : json.getString("busAccount");
            List accountIds = ((SupplierRpcService)SrmRpcUtil.getExecuteServiceImpl(SupplierRpcService.class)).getUserIdByJobFunction(alertConfig.getNoticeToFunction(), elsAccount, json.getString("toElsAccount"));
            if (CollUtil.isNotEmpty((Collection)accountIds)) {
                arrayList.addAll(accountIds);
            } else if (StrUtil.isNotBlank((CharSequence)json.getString("toElsAccount")) && (subAccount2 = this.invokeAccountRpcService.getAccount(json.getString("toElsAccount"), "1001")) != null) {
                arrayList.add(subAccount2.getId());
            }
        }
        if (!arrayList.isEmpty()) {
            list.addAll(this.invokeAccountRpcService.getAccountById(arrayList));
        }
        if ((list == null || list.isEmpty()) && json.containsKey((Object)"busAccount") && (subAccount = this.invokeAccountRpcService.getAccount(json.getString("elsAccount"), "1001")) != null) {
            list = new ArrayList();
            list.add(subAccount);
        }
        return list.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ElsSubAccountDTO>(Comparator.comparing(ParentEntityDTO::getId))), ArrayList::new));
    }

    private List<String> getUserIdsByGroovy(String transformScript, JSONObject data) {
        Class clazz = AlertRpcService.groovyClassLoader.parseClass(transformScript);
        if (clazz != null) {
            try {
                Object instance = clazz.newInstance();
                if (instance != null) {
                    if (instance instanceof AlertGroovyHandler) {
                        AlertGroovyHandler handler = (AlertGroovyHandler)instance;
                        return handler.transform(data);
                    }
                    System.err.println("\u8f6c\u6362\u5931\u8d25\uff01");
                }
            }
            catch (Exception e) {
                throw new ELSBootException("\u6267\u884cjavaBean\u5f02\u5e38" + e.getMessage());
            }
        }
        return null;
    }

    private void addSubAccount(List<ElsSubAccountDTO> list, String userId) {
        ElsSubAccountDTO account = this.jobInvokeAccountRpcService.getAccountById(userId);
        if (account != null) {
            list.add(account);
        }
    }

    private List<ElsSubAccountDTO> getPrincipalList(Object obj, ElsAlertConfig alertConfig) {
        AlertRpcService service = this.jobExecuteService.getAlertRpcService(alertConfig.getAlertService());
        return service.getPrincipalList(obj, this.getJsonByObject((Object)alertConfig));
    }

    private JSONObject getJsonByObject(Object param) {
        ObjectMapper mapper = new ObjectMapper();
        String json = "{}";
        try {
            json = mapper.writeValueAsString(param);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return JSONObject.parseObject((String)json);
    }

    private AlertListBuilder getAlertList(ElsAlertConfig alertConfig) {
        AlertRpcService service = this.jobExecuteService.getAlertRpcService(alertConfig.getAlertService());
        AlertListBuilder result = new AlertListBuilder();
        List alertList = service.getAlertList(this.getJsonByObject((Object)alertConfig));
        result.setAlertList(alertList);
        for (int i = 0; i < alertList.size(); ++i) {
            String url = service.buildUrlParamTemplate(alertList.get(i));
            result.getUrlMap().put(i, url);
        }
        return result;
    }

    private static class AlertListBuilder {
        private List<?> alertList;
        private Map<Integer, String> urlMap = new HashMap<Integer, String>();

        @Generated
        public AlertListBuilder() {
        }

        @Generated
        public List<?> getAlertList() {
            return this.alertList;
        }

        @Generated
        public Map<Integer, String> getUrlMap() {
            return this.urlMap;
        }

        @Generated
        public void setAlertList(List<?> alertList) {
            this.alertList = alertList;
        }

        @Generated
        public void setUrlMap(Map<Integer, String> urlMap) {
            this.urlMap = urlMap;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AlertListBuilder)) {
                return false;
            }
            AlertListBuilder other = (AlertListBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<?> this$alertList = this.getAlertList();
            List<?> other$alertList = other.getAlertList();
            if (this$alertList == null ? other$alertList != null : !((Object)this$alertList).equals(other$alertList)) {
                return false;
            }
            Map<Integer, String> this$urlMap = this.getUrlMap();
            Map<Integer, String> other$urlMap = other.getUrlMap();
            return !(this$urlMap == null ? other$urlMap != null : !((Object)this$urlMap).equals(other$urlMap));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AlertListBuilder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<?> $alertList = this.getAlertList();
            result = result * 59 + ($alertList == null ? 43 : ((Object)$alertList).hashCode());
            Map<Integer, String> $urlMap = this.getUrlMap();
            result = result * 59 + ($urlMap == null ? 43 : ((Object)$urlMap).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AlertServiceImpl.AlertListBuilder(alertList=" + this.getAlertList() + ", urlMap=" + this.getUrlMap() + ")";
        }
    }
}

