/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.base.api.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.ElsTaxDTO;
import com.els.modules.base.api.service.ElsTaxRpcService;
import com.els.modules.system.entity.ElsTax;
import com.els.modules.system.service.ElsTaxService;
import com.google.common.collect.Lists;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@RpcService
public class ElsTaxBeanServiceImpl
implements ElsTaxRpcService {
    @Resource
    private ElsTaxService elsTaxService;

    public List<ElsTaxDTO> findList(String elsAccount, String taxCode) {
        return SysUtil.copyProperties(this.elsTaxService.findList(elsAccount, taxCode), ElsTaxDTO.class);
    }

    public Map<String, BigDecimal> getAllTax(String purchaseElsAccount) {
        return this.elsTaxService.getAllTax(purchaseElsAccount);
    }

    public List<ElsTaxDTO> getElsTaxByCode(String elsAccount, List<String> taxCode) {
        if (CollUtil.isEmpty(taxCode)) {
            return Lists.newArrayList();
        }
        List<ElsTax> taxs = this.elsTaxService.getElsTaxByCode(elsAccount, taxCode);
        return Convert.toList(ElsTaxDTO.class, taxs);
    }

    public ElsTaxDTO findByTaxRate(String elsAccount, String taxRate) {
        return (ElsTaxDTO)SysUtil.copyProperties((Object)((Object)this.elsTaxService.findByTaxRate(elsAccount, taxRate)), ElsTaxDTO.class);
    }

    public List<ElsTaxDTO> findListByElsAccount(String elsAccount) {
        return SysUtil.copyProperties(this.elsTaxService.findListByElsAccount(elsAccount), ElsTaxDTO.class);
    }
}

