/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.redisManager.controller;

import com.els.common.api.vo.Result;
import com.els.modules.redisManager.service.RedisManagerService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/base/redisManager"})
@Tag(name="redis\u7ba1\u7406")
public class RedisManagerController {
    @Resource
    private RedisManagerService redisManagerService;

    @Operation(summary="redis\u6811\u7ed3\u6784\u67e5\u8be2", description="redis\u6811\u7ed3\u6784\u67e5\u8be2")
    @GetMapping(value={"/redisTree"})
    @RequiresPermissions(value={"redisManager:redisTree"})
    public Result<?> redisTree(@RequestParam(name="redisKey", required=false) String redisKey) {
        return Result.ok(this.redisManagerService.getRedisTree(redisKey));
    }

    @Operation(summary="\u83b7\u53d6key\u5bf9\u5e94\u503c", description="\u83b7\u53d6key\u5bf9\u5e94\u503c")
    @GetMapping(value={"/getValue"})
    @RequiresPermissions(value={"redisManager:getValue"})
    public Result<?> getValue(@RequestParam(name="redisKey") String redisKey) {
        return Result.ok((Object)this.redisManagerService.getValue(redisKey));
    }

    @Operation(summary="\u5220\u9664redis\u5bf9\u5e94key", description="\u5220\u9664redis\u5bf9\u5e94key")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"redisManager:delete"})
    public Result<?> delete(@RequestParam(name="redisKey") String redisKey) {
        this.redisManagerService.deleteKey(redisKey);
        return Result.ok();
    }
}

