/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.barcode.entity.ElsBarCodeShortCode;
import com.els.modules.barcode.service.ElsBarCodeShortCodeService;
import com.els.modules.barcode.vo.ShortCodeReqVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u7b80\u7801\u5bf9\u7167")
@RestController
@RequestMapping(value={"/base/barcode/elsBarCodeShortCode"})
public class ElsBarCodeShortCodeController
extends BaseController<ElsBarCodeShortCode, ElsBarCodeShortCodeService> {
    @Autowired
    private ElsBarCodeShortCodeService elsBarCodeShortCodeService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"barcode#shortCode:list"})
    @PermissionDataView(businessType="barCodeShortCode")
    public Result<?> queryPageList(ElsBarCodeShortCode elsBarCodeShortCode, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsBarCodeShortCode), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)this.getTenantId());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsBarCodeShortCodeService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u7b80\u7801\u5bf9\u7167-\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @PermissionDataOpt(businessType="barCodeShortCode", beanClass=ElsBarCodeShortCodeService.class)
    @RequiresPermissions(value={"barcode#shortCode:add"})
    public Result<?> add(@RequestBody ElsBarCodeShortCode elsBarCodeShortCode) {
        this.elsBarCodeShortCodeService.saveElsBarCodeShortCode(elsBarCodeShortCode);
        return Result.ok((Object)((Object)elsBarCodeShortCode));
    }

    @SrmValidated
    @AutoLog(value="\u7b80\u7801\u5bf9\u7167-\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @PermissionDataOpt(businessType="barCodeShortCode", beanClass=ElsBarCodeShortCodeService.class)
    @RequiresPermissions(value={"barcode#shortCode:edit"})
    public Result<?> edit(@RequestBody ElsBarCodeShortCode elsBarCodeShortCode) {
        this.elsBarCodeShortCodeService.updateElsBarCodeShortCode(elsBarCodeShortCode);
        String id = elsBarCodeShortCode.getId();
        return this.queryById(id);
    }

    @Operation(summary="\u67e5\u8be2\u7b80\u7801", description="\u67e5\u8be2\u7b80\u7801")
    @GetMapping(value={"/getShortCodeValue"})
    @RequiresPermissions(value={"barcode#shortCode:detail"})
    public Result<?> queryById(@RequestBody List<ShortCodeReqVO> shortCodeReqVOS) {
        return Result.ok(this.elsBarCodeShortCodeService.getShortCodeValue(shortCodeReqVOS));
    }

    @AutoLog(value="\u7b80\u7801\u5bf9\u7167-\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"barcode#shortCode:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.elsBarCodeShortCodeService.delElsBarCodeShortCode(id);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"barcode#shortCode:detail"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ElsBarCodeShortCode elsBarCodeShortCode = (ElsBarCodeShortCode)((Object)this.elsBarCodeShortCodeService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)elsBarCodeShortCode));
    }
}

