/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.base.api.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.SysUtil;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.entity.SaleAttachment;
import com.els.modules.attachment.service.SaleAttachmentService;
import com.els.modules.attachment.vo.AttachmentSendVO;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.service.SaleAttachmentRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;

@RpcService
public class SaleAttachmentBeanServiceImpl
implements SaleAttachmentRpcService {
    @Resource
    private SaleAttachmentService saleAttachmentService;

    public List<SaleAttachmentDTO> selectByMainId(String id) {
        List<SaleAttachment> attachmentList = this.saleAttachmentService.selectByMainId(id);
        return SysUtil.copyProperties(attachmentList, SaleAttachmentDTO.class);
    }

    public List<SaleAttachmentDTO> listSaleFiles(List<String> ids) {
        List saleAttachmentList = ((LambdaQueryChainWrapper)this.saleAttachmentService.lambdaQuery().in(ParentEntity::getId, ids)).list();
        return SysUtil.copyProperties((List)saleAttachmentList, SaleAttachmentDTO.class);
    }

    public void insertBatchSomeColumn(List<SaleAttachmentDTO> attachmentDTOList) {
        ArrayList attachmentList = SysUtil.copyProperties(attachmentDTOList, SaleAttachment.class);
        this.saleAttachmentService.saveBatch(attachmentList, 200);
    }

    public void deleteByMainId(String id) {
        this.saleAttachmentService.deleteByMainId(id);
    }

    public void deleteByBatchId(List<String> ids) {
        this.saleAttachmentService.delBatchAttachmentSale(ids);
    }

    public void sendFile(AttachmentSendDTO sendDTO) {
        AttachmentSendVO sendVO = new AttachmentSendVO();
        BeanUtils.copyProperties((Object)sendDTO, (Object)sendVO);
        this.saleAttachmentService.sendFile(sendVO);
    }

    public List<PurchaseAttachmentDTO> toPurchaseAttachment(String mainId) {
        List<PurchaseAttachment> attachmentList = this.saleAttachmentService.toPurchaseAttachment(mainId);
        return SysUtil.copyProperties(attachmentList, PurchaseAttachmentDTO.class);
    }

    public void updateById(SaleAttachmentDTO attachmentDTO) {
        SaleAttachment attachment = (SaleAttachment)((Object)SysUtil.copyProperties((Object)attachmentDTO, SaleAttachment.class));
        this.saleAttachmentService.updateById((Object)attachment);
    }

    public void insert(SaleAttachmentDTO attachmentDTO) {
        SaleAttachment attachment = (SaleAttachment)((Object)SysUtil.copyProperties((Object)attachmentDTO, SaleAttachment.class));
        this.saleAttachmentService.save((Object)attachment);
    }

    public void updateAttachmentBatchById(List<SaleAttachmentDTO> saleAttachmentList) {
        if (CollectionUtil.isNotEmpty(saleAttachmentList)) {
            this.saleAttachmentService.updateBatchById(SysUtil.copyProperties(saleAttachmentList, SaleAttachment.class));
        }
    }

    public SaleAttachmentDTO selectById(String id) {
        SaleAttachment attachment = (SaleAttachment)((Object)this.saleAttachmentService.getById((Serializable)((Object)id)));
        return (SaleAttachmentDTO)SysUtil.copyProperties((Object)((Object)attachment), SaleAttachmentDTO.class);
    }

    public List<SaleAttachmentDTO> selectSaleAttachmentByIds(List<String> ids) {
        List<SaleAttachment> saleAttachmentList = this.saleAttachmentService.selectSaleAttachmentByIds(ids);
        return SysUtil.copyProperties(saleAttachmentList, SaleAttachmentDTO.class);
    }
}

