/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.justauth.controller;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.constant.SrmConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SrmUtil;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.account.entity.ExternalAccount;
import com.els.modules.account.service.ExternalAccountService;
import com.els.modules.justauth.util.ThirdAuthUtil;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.request.AuthRequest;
import me.zhyd.oauth.utils.AuthStateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u7b2c\u4e09\u65b9\u8d26\u53f7\u7ed1\u5b9a")
@RestController
@RequestMapping(value={"/base/thirdAccountBind"})
public class ThirdAccountBindController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThirdAccountBindController.class);
    @Autowired
    private ExternalAccountService externalAccountService;
    @Autowired
    private RedisUtil redisUtil;

    @AutoLog(busModule="\u7b2c\u4e09\u65b9\u8d26\u53f7\u7ed1\u5b9a", value="\u89e3\u7ed1")
    @GetMapping(value={"/unBind"})
    public Result<?> unBind(@RequestParam(name="thirdType") String thirdType, @RequestParam(name="busAccount") String busAccount) {
        LoginUserDTO loginUser = SrmUtil.getLoginUser();
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ParentEntity::getElsAccount, (Object)loginUser.getElsAccount())).eq(ExternalAccount::getAccountId, (Object)loginUser.getId())).eq(ExternalAccount::getAccountType, (Object)thirdType)).eq(ExternalAccount::getBusAccount, (Object)busAccount);
        this.externalAccountService.remove((Wrapper)wrapper);
        return Result.ok((String)I18nUtil.translate((String)"\u64cd\u4f5c\u6210\u529f!"));
    }

    @AutoLog(busModule="\u7b2c\u4e09\u65b9\u8d26\u53f7\u7ed1\u5b9a", value="\u52a0\u8f7d\u7ed1\u5b9a\u9875\u9762")
    @GetMapping(value={"/loadQrCode/{busAccount}/{source}"})
    public Result<Object> loadQrCode(@PathVariable(value="busAccount") String busAccount, @PathVariable(value="source") String source, HttpServletResponse response) {
        AuthRequest authRequest = ThirdAuthUtil.getAuthRequest(busAccount, source.toUpperCase(), "pc", false);
        String state = AuthStateUtils.createState();
        String authorizeUrl = authRequest.authorize(state);
        this.redisUtil.set("srm:base:third:login:account_state:" + state, (Object)SrmUtil.getLoginUser(), 300L);
        this.redisUtil.set("srm:base:third:login:account:" + state, (Object)busAccount, 300L);
        JSONObject object = new JSONObject();
        authorizeUrl = authorizeUrl.replace("qcLogin", "QcCodeBinding");
        object.put((Object)"url", (Object)authorizeUrl);
        return Result.ok((Object)object);
    }

    @AutoLog(busModule="\u7b2c\u4e09\u65b9\u7ed1\u5b9a", value="\u7ed1\u5b9a\u56de\u8c03")
    @GetMapping(value={"/{source}/callback"})
    public Result<?> loginThird(@PathVariable(value="source") String source, AuthCallback callback) {
        try {
            String busAccount = (String)this.redisUtil.get("srm:base:third:login:account:" + callback.getState());
            if (CharSequenceUtil.isEmpty((CharSequence)busAccount)) {
                throw new ELSBootException("\u8bf7\u91cd\u65b0\u83b7\u53d6\u4e8c\u7ef4\u7801");
            }
            AuthRequest authRequest = ThirdAuthUtil.getAuthRequest(busAccount, source.toLowerCase(), "pc", false);
            AuthResponse response = authRequest.login(callback);
            log.info("loginThird\u7b2c\u4e09\u65b9\u7ed1\u5b9a{}", (Object)JSONObject.toJSONString((Object)response, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
            if (response.getCode() == 2000) {
                JSONObject data = JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData(), (JSONWriter.Feature[])new JSONWriter.Feature[0]));
                log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fd4\u56de\u4fe1\u606f:{}", (Object)data);
                String username = data.getString("username");
                String avatar = data.getString("avatar");
                String uuid = data.getString("uuid");
                if (CharSequenceUtil.isEmpty((CharSequence)username) && source.toUpperCase().contains("WECHAT_ENTERPRISE_DEVELOP")) {
                    JSONObject rawUserInfo = data.getJSONObject("rawUserInfo");
                    JSONObject userInfo = rawUserInfo.getJSONObject("user_info");
                    uuid = userInfo.getString("open_userid");
                }
                String accountType = ThirdAuthUtil.getAuthConfigType(source.toUpperCase());
                ExternalAccount externalAccount = new ExternalAccount();
                externalAccount.setExternalAccountId(uuid);
                externalAccount.setAccountType(accountType);
                externalAccount.setEnabled(SrmConstant.YES_1);
                externalAccount.setBusAccount(busAccount);
                LoginUserDTO loginUser = (LoginUserDTO)this.redisUtil.get("srm:base:third:login:account_state:" + callback.getState());
                if (loginUser != null) {
                    externalAccount.setId(IdWorker.getIdStr());
                    this.externalAccountService.checkAndSave(externalAccount);
                    return Result.ok();
                }
                return Result.error((String)"\u7b2c\u4e09\u65b9\u8d26\u53f7\u7ed1\u5b9a\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            return Result.error((String)("\u7b2c\u4e09\u65b9\u8d26\u53f7\u7ed1\u5b9a\u5f02\u5e38" + response.getMsg() + ",\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage());
        }
    }
}

