/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.news.controller;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.news.entity.ElsTenantPortalNews;
import com.els.modules.news.enums.NewsStatusEnum;
import com.els.modules.news.service.ElsTenantPortalNewsService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u95e8\u6237\u65b0\u95fb\u7ba1\u7406")
@RestController
@RequestMapping(value={"/news/elsTenantPortalNews"})
public class ElsTenantPortalNewsController
extends BaseController<ElsTenantPortalNews, ElsTenantPortalNewsService> {
    @Autowired
    private ElsTenantPortalNewsService elsTenantPortalNewsService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"news#elsTenantPortalNews:list"})
    public Result<?> queryPageList(ElsTenantPortalNews elsTenantPortalNews, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsTenantPortalNews), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.lambda().select(new SFunction[]{ParentEntity::getId, ElsTenantPortalNews::getPortalNewsThumbnail, ElsTenantPortalNews::getPortalNewsType, ElsTenantPortalNews::getPortalNewsTitle, ElsTenantPortalNews::getPortalNewsIntro, ElsTenantPortalNews::getStatus, ElsTenantPortalNews::getVisitorVolume, ElsTenantPortalNews::getSort, ElsTenantPortalNews::getEffectiveTime, ElsTenantPortalNews::getPublishTime, ElsTenantPortalNews::getExpiryTime, ElsTenantPortalNews::getNewsRedirectType, ElsTenantPortalNews::getLinkUrl, ElsTenantPortalNews::getRemark, BaseEntity::getCreateTime, BaseEntity::getCreateBy, BaseEntity::getUpdateTime, BaseEntity::getUpdateBy});
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsTenantPortalNewsService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u95e8\u6237\u65b0\u95fb\u7ba1\u7406-\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"news#elsTenantPortalNews:add"})
    public Result<?> add(@RequestBody ElsTenantPortalNews elsTenantPortalNews) {
        elsTenantPortalNews.setSort(CharSequenceUtil.emptyToDefault((CharSequence)elsTenantPortalNews.getSort(), (String)"0"));
        elsTenantPortalNews.setStatus(NewsStatusEnum.UNPUBLISHED.getCode());
        this.elsTenantPortalNewsService.saveElsTenantPortalNews(elsTenantPortalNews);
        return Result.ok((Object)((Object)elsTenantPortalNews));
    }

    @SrmValidated
    @AutoLog(value="\u95e8\u6237\u65b0\u95fb\u7ba1\u7406-\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"news#elsTenantPortalNews:edit"})
    public Result<?> edit(@RequestBody ElsTenantPortalNews elsTenantPortalNews) {
        elsTenantPortalNews.setStatus(NewsStatusEnum.UNPUBLISHED.getCode());
        this.elsTenantPortalNewsService.updateElsTenantPortalNews(elsTenantPortalNews);
        String id = elsTenantPortalNews.getId();
        return this.queryById(id);
    }

    @AutoLog(value="\u95e8\u6237\u65b0\u95fb\u7ba1\u7406-\u53d1\u5e03")
    @Operation(summary="\u53d1\u5e03", description="\u53d1\u5e03")
    @PostMapping(value={"/publish/{id}"})
    @RequiresPermissions(value={"news#elsTenantPortalNews:publish"})
    public Result<?> publish(@PathVariable(value="id") String id) {
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)updateWrapper.set(ElsTenantPortalNews::getStatus, (Object)NewsStatusEnum.PUBLISHED.getCode())).set(ElsTenantPortalNews::getPublishTime, (Object)new Date());
        ((LambdaUpdateWrapper)updateWrapper.eq(ParentEntity::getId, (Object)id)).eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant());
        this.elsTenantPortalNewsService.update((Object)new ElsTenantPortalNews(), (Wrapper)updateWrapper);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u95e8\u6237\u65b0\u95fb\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u5220\u9664", description="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @RequiresPermissions(value={"news#elsTenantPortalNews:delete"})
    public Result<?> delete(@RequestBody List<String> ids) {
        this.elsTenantPortalNewsService.removeByIds(ids);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"news#elsTenantPortalNews:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ElsTenantPortalNews elsTenantPortalNews = (ElsTenantPortalNews)((Object)this.elsTenantPortalNewsService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)elsTenantPortalNews));
    }

    @GetMapping(value={"/noToken/detail"})
    public Result<?> detail(@RequestParam(name="id") String id) {
        ElsTenantPortalNews elsTenantPortalNews = (ElsTenantPortalNews)((Object)this.elsTenantPortalNewsService.getById((Serializable)((Object)id)));
        if (!NewsStatusEnum.PUBLISHED.getCode().equals(elsTenantPortalNews.getStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APGDVQLhx_3f167448", (String)"\u5f53\u524d\u95e8\u6237\u65b0\u95fb\u672a\u53d1\u5e03"));
        }
        return Result.ok((Object)((Object)elsTenantPortalNews));
    }

    @GetMapping(value={"/noToken/page"})
    public Result<?> detail(@RequestParam(name="type", defaultValue="") String type, @RequestParam(name="elsAccount", defaultValue="") String elsAccount, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ParentEntity::getElsAccount, (Object)CharSequenceUtil.emptyToDefault((CharSequence)elsAccount, (String)SysUtil.getPurchaseAccount()))).eq(ElsTenantPortalNews::getStatus, (Object)NewsStatusEnum.PUBLISHED.getCode())).eq(CharSequenceUtil.isNotEmpty((CharSequence)type), ElsTenantPortalNews::getPortalNewsType, (Object)type);
        queryWrapper.select(new SFunction[]{ParentEntity::getId, ElsTenantPortalNews::getPortalNewsType, ElsTenantPortalNews::getPortalNewsTitle, ElsTenantPortalNews::getPortalNewsIntro, BaseEntity::getCreateTime, BaseEntity::getUpdateTime, ElsTenantPortalNews::getPublishTime, ElsTenantPortalNews::getNewsRedirectType, ElsTenantPortalNews::getLinkUrl, ElsTenantPortalNews::getPortalNewsThumbnail});
        DateTime now = DateUtil.date();
        ((LambdaQueryWrapper)queryWrapper.le(ElsTenantPortalNews::getEffectiveTime, (Object)now)).ge(ElsTenantPortalNews::getExpiryTime, (Object)now);
        queryWrapper.orderByAsc(ElsTenantPortalNews::getSort);
        queryWrapper.orderByDesc(ElsTenantPortalNews::getPublishTime);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        Page portalNewsPage = (Page)this.elsTenantPortalNewsService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)portalNewsPage);
    }
}

