/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.PermissionData;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.PermissionDataService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.vo.PermissionDataVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u8d26\u53f7\u6743\u9650")
@RestController
@RequestMapping(value={"/account/permissionData"})
public class PermissionDataController
extends BaseController<PermissionData, PermissionDataService> {
    @Autowired
    private PermissionDataService permissionDataService;
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private RoleService roleService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"permissionData#PermissionData:list"})
    public Result<?> queryPageList(PermissionData permissionData, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)permissionData), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.permissionDataService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u8d26\u53f7\u6743\u9650-\u6dfb\u52a0", logType=2, operateType=2)
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"permissionData#PermissionData:add"})
    public Result<?> add(@RequestBody PermissionData permissionData) {
        this.permissionDataService.savePermissionData(permissionData);
        return Result.ok((Object)((Object)permissionData));
    }

    @SrmValidated
    @AutoLog(value="\u8d26\u53f7\u6743\u9650-\u7f16\u8f91", logType=2, operateType=3)
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"permissionData#PermissionData:edit"})
    public Result<?> edit(@RequestBody PermissionDataVO permissionDataVO) {
        this.permissionDataService.updatePermissionData(permissionDataVO);
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(value="\u8d26\u53f7\u6743\u9650-\u4e1a\u52a1\u7ef4\u5ea6-\u65b0\u589e", logType=2, operateType=3)
    @Operation(summary="\u4e1a\u52a1\u7ef4\u5ea6-\u65b0\u589e", description="\u4e1a\u52a1\u7ef4\u5ea6-\u65b0\u589e")
    @PostMapping(value={"/addBus"})
    @RequiresPermissions(value={"permissionData#PermissionData:edit"})
    public Result<?> addBus(@RequestBody PermissionDataVO permissionDataVO) {
        this.permissionDataService.savePermissionDataBus(permissionDataVO);
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(value="\u8d26\u53f7\u6743\u9650-\u4e1a\u52a1\u7ef4\u5ea6-\u7f16\u8f91", logType=2, operateType=3)
    @Operation(summary="\u4e1a\u52a1\u7ef4\u5ea6-\u7f16\u8f91", description="\u4e1a\u52a1\u7ef4\u5ea6-\u7f16\u8f91")
    @PostMapping(value={"/editBus"})
    @RequiresPermissions(value={"permissionData#PermissionData:edit"})
    public Result<?> editBus(@RequestBody PermissionDataVO permissionDataVO) {
        this.permissionDataService.updatePermissionDataBus(permissionDataVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8d26\u53f7\u6743\u9650-\u590d\u5236", logType=2, operateType=3)
    @Operation(summary="\u590d\u5236", description="\u590d\u5236")
    @PostMapping(value={"/copy"})
    @RequiresPermissions(value={"permissionData#PermissionData:copy"})
    public Result<?> copy(@RequestBody PermissionDataVO permissionDataVO) {
        this.permissionDataService.copyPermission(permissionDataVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8d26\u53f7\u6743\u9650-\u901a\u8fc7id\u5220\u9664", logType=2, operateType=4)
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"permissionData#PermissionData:delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.permissionDataService.delPermissionData(id);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"permissionData#PermissionData:list"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PermissionDataVO dataVO = new PermissionDataVO();
        ElsSubAccount account = (ElsSubAccount)((Object)this.elsSubAccountService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        BeanUtil.copyProperties((Object)((Object)account), (Object)((Object)dataVO), (String[])new String[0]);
        List list = this.permissionDataService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)account.getElsAccount())).eq((Object)"sub_account", (Object)account.getSubAccount()));
        dataVO.setPermissionDataList(list);
        List userRole = this.userRoleService.list((Wrapper)new QueryWrapper().lambda().eq(UserRole::getUserId, (Object)account.getId()));
        List roleIdList = userRole.stream().map(UserRole::getRoleId).collect(Collectors.toList());
        List roleList = new ArrayList();
        if (!roleIdList.isEmpty()) {
            roleList = this.roleService.list((Wrapper)new QueryWrapper().in((Object)"id", roleIdList));
        }
        StringBuilder str = new StringBuilder();
        for (Role role : roleList) {
            str.append(role.getRoleName()).append(",");
        }
        String selectedroles = str.length() > 0 ? str.substring(0, str.length() - 1) : "";
        dataVO.setSelectedroles(selectedroles);
        return Result.ok((Object)((Object)dataVO));
    }

    @Operation(summary="\u901a\u8fc7\u4e1a\u52a1\u7c7b\u578b\u67e5\u8be2", description="\u901a\u8fc7\u4e1a\u52a1\u7c7b\u578b\u67e5\u8be2")
    @GetMapping(value={"/queryByType"})
    @RequiresPermissions(value={"permissionData#PermissionData:list"})
    public Result<?> queryByType(@RequestParam(name="businessType", required=true) String businessType) {
        PermissionDataVO dataVO = new PermissionDataVO();
        List list = this.permissionDataService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).eq((Object)"business_type", (Object)businessType));
        dataVO.setPermissionDataList(list);
        dataVO.setBusinessType(businessType);
        dataVO.setElsAccount(TenantContext.getTenant());
        dataVO.setId(IdWorker.getIdStr());
        return Result.ok((Object)((Object)dataVO));
    }
}

