/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.BusMessageUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SrmRpcUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.account.api.service.AccountInfoRpcService;
import com.els.modules.im.core.ImSender;
import com.els.modules.im.core.constant.TioConfigConstant;
import com.els.modules.im.core.message.BusinessHelper;
import com.els.modules.im.core.packets.GroupChatPackets;
import com.els.modules.im.core.packets.GroupChatUserPackets;
import com.els.modules.im.core.packets.ImPackets;
import com.els.modules.im.core.packets.ImUserPackets;
import com.els.modules.im.core.packets.MessagePackets;
import com.els.modules.im.core.packets.WsMessageDataPackets;
import com.els.modules.im.core.packets.WsResultPackets;
import com.els.modules.im.dto.ImMessageCallbackDto;
import com.els.modules.im.entity.ImGroupChat;
import com.els.modules.im.entity.ImGroupChatConfig;
import com.els.modules.im.entity.ImGroupChatUser;
import com.els.modules.im.entity.ImMessage;
import com.els.modules.im.entity.ImUserFriend;
import com.els.modules.im.service.IImGroupChatService;
import com.els.modules.im.service.IImGroupChatUserService;
import com.els.modules.im.service.IImMessageService;
import com.els.modules.im.service.IImUserFriendService;
import com.els.modules.im.service.ImAccountLocalService;
import com.els.modules.im.service.ImGroupChatConfigService;
import com.els.modules.im.utils.ImUtils;
import com.els.modules.im.utils.TuLingRobotUtil;
import com.els.modules.system.entity.ElsSubAccount;
import com.google.common.collect.Lists;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.redisson.api.RDeque;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.tio.core.ChannelContext;
import org.tio.core.TioConfig;
import org.tio.server.TioServerConfig;

@Service(value="srmBusinessHelper")
public class SrmBusinessHelper
implements BusinessHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SrmBusinessHelper.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private RedissonClient redissonClient;
    @Resource
    private IImGroupChatUserService imChatGroupUserServiceImpl;
    @Resource
    private IImGroupChatService imGroupChatServiceImpl;
    @Resource
    private IImMessageService imMessageServiceImpl;
    @Resource
    private IImUserFriendService imUserFriendServiceImpl;
    @Resource
    private ImGroupChatConfigService imGroupChatConfigServiceImpl;
    @Resource
    private ImAccountLocalService accountLocalServiceImpl;

    @Override
    public boolean isOnline(String userId) {
        return this.redisUtil.hasKey("srm:im:user:online:" + userId);
    }

    @Override
    public boolean isThisOnline(String userId, String serverId) {
        Object value;
        if (CharSequenceUtil.isEmpty((CharSequence)serverId)) {
            serverId = TioConfigConstant.SERVER_ID;
        }
        if (null == (value = this.redisUtil.get("srm:im:user:online:" + userId))) {
            return false;
        }
        return CharSequenceUtil.equals((CharSequence)((String)value), (CharSequence)serverId);
    }

    @Override
    public boolean setOnLine(String userId, String serverId) {
        if (CharSequenceUtil.isEmpty((CharSequence)serverId)) {
            serverId = TioConfigConstant.SERVER_ID;
        }
        this.redisUtil.set("srm:im:user:online:" + userId, (Object)serverId, 1800L);
        return true;
    }

    @Override
    public void removeOnLine(String userId) {
        this.redisUtil.del(new String[]{"srm:im:user:online:" + userId});
    }

    @Override
    public void removeThisOnline(String userId, String serverId) {
        RedisUtil redisUtil;
        Object value;
        if (CharSequenceUtil.isEmpty((CharSequence)serverId)) {
            serverId = TioConfigConstant.SERVER_ID;
        }
        if (CharSequenceUtil.equals((CharSequence)((String)(value = (redisUtil = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class)).get("srm:im:user:online:" + userId))), (CharSequence)serverId)) {
            redisUtil.del(new String[]{"srm:im:user:online:" + userId});
        }
        if (this.checkIfKefu(userId)) {
            this.removeCustomerOrUser("srm:im:online:ke_fu_list", userId);
        }
    }

    @Override
    public List<GroupChatUserPackets> getGroupUsersByGroupId(String groupId, Integer userStatus) {
        List<ImGroupChatUser> groupUsers = this.imChatGroupUserServiceImpl.getChatGroupUserByGroupId(groupId);
        if (null == userStatus || TioConfigConstant.IM_USER_STATUS_ALL.equals(userStatus)) {
            return Convert.toList(GroupChatUserPackets.class, groupUsers);
        }
        return null;
    }

    @Override
    public List<GroupChatPackets> getAllGroupByGroupIds(List<String> groupIds, boolean fullData) {
        if (CollectionUtil.isEmpty(groupIds)) {
            return Lists.newArrayList();
        }
        List imChatGroups = this.imGroupChatServiceImpl.listByIds(groupIds);
        if (!fullData) {
            return Convert.toList(GroupChatPackets.class, (Object)imChatGroups);
        }
        return null;
    }

    @Override
    public List<GroupChatPackets> getAllGroupByUserId(String userId) {
        List<ImGroupChat> chatGroups = this.imGroupChatServiceImpl.getGroupChatsByUserId(userId);
        return Convert.toList(GroupChatPackets.class, chatGroups);
    }

    @Override
    public List<String> getAllUserIdsByGroupId(String groupId) {
        List<ImGroupChatUser> groupUsers = this.imChatGroupUserServiceImpl.getChatGroupUserByGroupId(groupId);
        return groupUsers.stream().map(ImGroupChatUser::getUserId).collect(Collectors.toList());
    }

    @Override
    public List<String> getAllGroupIdByUserId(String userId) {
        List<ImGroupChat> chatGroups = this.imGroupChatServiceImpl.getGroupChatsByUserId(userId);
        return chatGroups.stream().map(ParentEntity::getId).distinct().collect(Collectors.toList());
    }

    @Override
    public void addGroupUser(String userId, String groupId) {
    }

    @Override
    public void removeGroupUser(String userId, String groupId) {
    }

    @Override
    public MessagePackets storeMessage(MessagePackets messageDto) {
        ImMessage message = (ImMessage)Convert.convert(ImMessage.class, (Object)messageDto);
        this.imMessageServiceImpl.saveMessage(message);
        messageDto.setId(message.getId());
        return messageDto;
    }

    @Override
    public MessagePackets loadMessage(String messageId) {
        ImMessage message = (ImMessage)this.imMessageServiceImpl.getById((Serializable)((Object)messageId));
        return (MessagePackets)Convert.convert(MessagePackets.class, (Object)message);
    }

    @Override
    public List<MessagePackets> getOfflineMessage(String userId, String fromUserId, String type) {
        List<ImMessage> unReadMessage = this.imMessageServiceImpl.getUnReadMessage(userId, fromUserId, type);
        return Convert.toList(MessagePackets.class, unReadMessage);
    }

    @Override
    public List<MessagePackets> getFriendsOfflineMessage(String userId, String fromUserId) {
        List<ImMessage> unReadMessage = this.imMessageServiceImpl.getUnReadMessage(userId, fromUserId, "friend");
        return Convert.toList(MessagePackets.class, unReadMessage);
    }

    @Override
    public List<MessagePackets> getKefuOfflineMessage(String userId, String fromUserId) {
        List<ImMessage> unReadMessage = this.imMessageServiceImpl.getUnReadMessage(userId, fromUserId, "kefu");
        return Convert.toList(MessagePackets.class, unReadMessage);
    }

    @Override
    public List<MessagePackets> getFriendsOfflineMessage(String userId) {
        return this.getFriendsOfflineMessage(userId, null);
    }

    @Override
    public MessagePackets getGroupOfflineMessage(String userId, String groupId) {
        return null;
    }

    @Override
    public List<ImUserPackets> getUserFriendsRequest(String userId) {
        List<ImUserFriend> imUserFriendList = this.imUserFriendServiceImpl.listImUserFriendOfUid(userId);
        Map friendMap = imUserFriendList.stream().collect(Collectors.toMap(ImUserFriend::getUserId, Function.identity()));
        List<String> userIdList = imUserFriendList.stream().map(ImUserFriend::getUserId).collect(Collectors.toList());
        List<ImUserPackets> imFriendUserList = this.getUsersByUserIdList(userIdList);
        int size = imFriendUserList.size();
        for (int i = size - 1; i >= 0; --i) {
            ImUserPackets imUserVO = imFriendUserList.get(i);
            ImUserFriend imUserFriend = (ImUserFriend)((Object)friendMap.get(imUserVO.getId()));
            if (null == imUserFriend) {
                imFriendUserList.remove(i);
                continue;
            }
            imUserVO.setCreateTime(imUserVO.getCreateTime());
        }
        return imFriendUserList;
    }

    @Override
    public ImUserPackets loadLoginUser(String token) {
        JSONObject accountObj = JwtUtil.getAccountObj((String)token);
        if (accountObj == null || !accountObj.containsKey((Object)"elsAccount")) {
            throw new AuthenticationException(I18nUtil.translate((String)"token\u975e\u6cd5\u65e0\u6548!"));
        }
        String elsAccount = accountObj.getString("elsAccount");
        String subAccount = accountObj.getString("subAccount");
        LoginUserDTO loginUser = ((AccountInfoRpcService)SrmRpcUtil.getExecuteServiceImpl(AccountInfoRpcService.class)).getLoginUserByAccount(elsAccount, subAccount);
        if (loginUser == null) {
            throw new AuthenticationException(I18nUtil.translate((String)"\u7528\u6237\u4e0d\u5b58\u5728!"));
        }
        if (loginUser.getStatus() == null || loginUser.getStatus() != 1) {
            throw new AuthenticationException(I18nUtil.translate((String)"\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!"));
        }
        return (ImUserPackets)((Object)Convert.convert(ImUserPackets.class, (Object)loginUser));
    }

    @Override
    public void connectInit(ChannelContext channelContext, ImUserPackets user) {
        String userId = user.getId();
        ImSender.bindUser(channelContext, userId);
        List<ImGroupChat> groups = this.imGroupChatServiceImpl.getGroupChatsByUserId(userId);
        this.setOnLine(userId, null);
        if (CollectionUtils.isEmpty(groups)) {
            return;
        }
        for (ImGroupChat group : groups) {
            this.bindGroup(group.getId(), channelContext);
        }
        if (this.checkIfKefu(userId)) {
            this.addCustomerOrUser("srm:im:online:ke_fu_list", userId);
        }
    }

    @Override
    public void addCustomerOrUser(String key, String id) {
        RDeque queue = this.redissonClient.getDeque("srm:im:online:ke_fu_list");
        try {
            queue.addFirstIfExists((Object[])new String[]{id});
        }
        catch (Exception e) {
            log.error("\u628a\u5ba2\u670d\u6dfb\u52a0\u5230\u961f\u5217\u4e2d\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    @Override
    public String getAndRemoveLastCustomerOrUser(String key) {
        try {
            RDeque queue = this.redissonClient.getDeque("srm:im:online:ke_fu_list");
            return (String)queue.pollLast();
        }
        catch (Exception e) {
            log.error("\u4ece\u5ba2\u670d\u5217\u8868\u4e2d\u83b7\u53d6\u4e00\u4e2a\u5931\u8d25:{}", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public void removeCustomerOrUser(String key, String id) {
        RDeque queue = this.redissonClient.getDeque(key);
        try {
            queue.remove((Object)id);
        }
        catch (Exception e) {
            log.error("\u628a\u5ba2\u670d\u4ece\u961f\u5217\u4e2d\u79fb\u9664\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    @Override
    public int countCustomerOrUserSize(String key) {
        RDeque queue = this.redissonClient.getDeque(key);
        if (null == queue) {
            return 0;
        }
        return queue.size();
    }

    @Override
    public ChannelContext getChannelContextByUserId(String userid) {
        List<ChannelContext> channelContexts = ImSender.getByUserId(userid, (TioConfig)TioConfigConstant.tioServerConfig);
        if (CollUtil.isEmpty(channelContexts)) {
            return null;
        }
        return channelContexts.get(0);
    }

    @Override
    public void asyncUndoMessage(String messageId, String fromId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)wrapper.eq(ImMessage::getId, (Object)messageId)).eq(ImMessage::getMessageFromId, (Object)fromId);
        wrapper.set(ImMessage::getMessageUndoStatus, (Object)1);
        this.imMessageServiceImpl.update(null, (Wrapper)wrapper);
    }

    @Override
    public ImUserPackets loadLoginUserId(String userId) {
        ElsSubAccount accountInfoDTO = this.accountLocalServiceImpl.getAccountInfoById(userId);
        return (ImUserPackets)((Object)Convert.convert(ImUserPackets.class, (Object)((Object)accountInfoDTO)));
    }

    @Override
    public List<MessagePackets> getUnReadMessage(String userid, String type) {
        List<ImMessage> unReadMessage = this.imMessageServiceImpl.getUnReadMessage(userid, type);
        return Convert.toList(MessagePackets.class, unReadMessage);
    }

    @Override
    public List<ImUserPackets> getUsersByUserIdList(List<String> imUserId) {
        List<ElsSubAccountDTO> usersByUserIdList = this.accountLocalServiceImpl.getUsersByUserIdList(imUserId);
        return Convert.toList(ImUserPackets.class, usersByUserIdList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendOutLineMessage(String sendId, String operateType, String groupId, Object msg, List<String> toUserIds) {
        String elsAccount = TenantContext.getTenant();
        try {
            ImGroupChat group;
            ImUserPackets loginUser = this.loadLoginUserId(sendId);
            List<ImGroupChatConfig> elsChatConfigs = this.imGroupChatConfigServiceImpl.loadConfig();
            TenantContext.setTenant((String)loginUser.getElsAccount());
            List<ImUserPackets> subAccountList = this.getUsersByUserIdList(toUserIds);
            Map<String, List<ImUserPackets>> accountMap = subAccountList.stream().collect(Collectors.groupingBy(ImUserPackets::getElsAccount));
            JSONObject msgObj = new JSONObject();
            msgObj.put("msgId", (Object)IdWorker.getIdStr());
            JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)msg));
            msgObj.put("businessObj", (Object)jsonObject);
            msgObj.put("busAccount", (Object)loginUser.getElsAccount());
            msgObj.put("elsAccount", (Object)loginUser.getElsAccount());
            msgObj.put("businessType", (Object)"chatMessageReminder");
            jsonObject.put("msgFromUser", (Object)(loginUser.getElsAccount() + "_" + loginUser.getRealname()));
            if ("imChatGroup".equals(operateType) && null != (group = (ImGroupChat)((Object)this.imGroupChatServiceImpl.getById((Serializable)((Object)groupId))))) {
                String recordI18Value = ImUtils.getRecordI18Value(group.getBusinessType(), elsChatConfigs);
                if (CharSequenceUtil.isNotEmpty((CharSequence)recordI18Value)) {
                    String groupName = group.getGroupChatName().replace(group.getBusinessType(), recordI18Value);
                    jsonObject.put("imGroupName", (Object)groupName);
                } else {
                    jsonObject.put("imGroupName", (Object)group.getGroupChatName());
                }
                if (CharSequenceUtil.isNotEmpty((CharSequence)group.getBusinessType())) {
                    jsonObject.put("imRecordNumber", (Object)group.getBusinessNumber());
                    jsonObject.put("imRecordrecordType", (Object)group.getBusinessType());
                }
            }
            msgObj.put("operateType", (Object)operateType);
            msgObj.put("sendObj", (Object)loginUser);
            JSONArray array = new JSONArray();
            for (String account : accountMap.keySet()) {
                List<ImUserPackets> imUserDTOS = accountMap.get(account);
                JSONObject receiveObj = new JSONObject();
                receiveObj.put("toElsAccount", (Object)account);
                receiveObj.put("urlParam", (Object)"");
                receiveObj.put("toSubAccountList", (Object)JSONArray.parseArray((String)JSON.toJSONString(imUserDTOS)));
                array.add((Object)receiveObj);
            }
            msgObj.put("receiveList", (Object)array);
            BusMessageUtil.sendBusMsg((String)msgObj.toJSONString(), null);
        }
        catch (Exception e) {
            log.info("ImMsgSendUtil \u79bb\u7ebf\u6d88\u606f\u53d1\u9001\u5931\u8d25:{}", (Object)e.getMessage());
        }
        finally {
            TenantContext.clear();
            TenantContext.setTenant((String)elsAccount);
        }
    }

    @Override
    public ImGroupChat getChatGroupById(String groupId) {
        return (ImGroupChat)((Object)this.imGroupChatServiceImpl.getById((Serializable)((Object)groupId)));
    }

    @Override
    public Map<String, List<String>> loadElsAccountIdToMap(List<String> elsAccountList) {
        return this.accountLocalServiceImpl.loadElsAccountIdToMap(elsAccountList);
    }

    public void bindGroup(String groupId, ChannelContext channelContext) {
        if (CharSequenceUtil.isEmpty((CharSequence)groupId)) {
            throw new ELSBootException("\u7fa4\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ImSender.bindGroup(channelContext, groupId);
    }

    public void clusterBindGroup(String userId, String groupId) {
        ImSender.clusterToBindGroup(userId, groupId);
    }

    @Override
    public void messageCallback(ImMessage imMessage, ImMessageCallbackDto dto) {
        String fromId = imMessage.getMessageFromId();
        String toId = imMessage.getMessageToId();
        ElsSubAccount user = this.accountLocalServiceImpl.getAccountInfoById(toId);
        WsMessageDataPackets messageInfo = new WsMessageDataPackets();
        messageInfo.setId(fromId);
        messageInfo.setMessageFromId(toId);
        messageInfo.setHeadPortrait(user.getAvatar());
        messageInfo.setRealname(user.getRealname());
        messageInfo.setHeadPortrait(user.getAvatar());
        String type = switch (dto.getSendNewsType()) {
            case "0" -> TuLingRobotUtil.ResultType.TEXT.getType();
            case "1" -> TuLingRobotUtil.ResultType.IMAGE.getType();
            default -> TuLingRobotUtil.ResultType.TEXT.getType();
        };
        messageInfo.setMessageContent(TuLingRobotUtil.ResultType.buildText(type, dto.getSendNews()));
        messageInfo.setMine(false);
        messageInfo.setMessageType(TuLingRobotUtil.ResultType.buildType(type));
        messageInfo.setMessageSendTime((Date)DateUtil.date());
        messageInfo.setMessageChatType("friend");
        messageInfo.setMine(false);
        WsResultPackets wsResult = new WsResultPackets();
        wsResult.setMsgType("msg_customer");
        wsResult.setData(messageInfo);
        if (this.isOnline(fromId)) {
            messageInfo = this.storeMessage(messageInfo, "1", "kefu");
            ImSender.sendToUser(fromId, (TioConfig)TioConfigConstant.tioServerConfig, this.buildImPacket(wsResult, messageInfo));
        } else {
            messageInfo = this.storeMessage(messageInfo, "0", "friend");
            this.sendOutLineMessage(messageInfo.getMessageFromId(), "imChatFriend", "", messageInfo, Lists.newArrayList((Object[])new String[]{messageInfo.getMessageToId()}));
        }
    }

    @Override
    public void bindGroup(TioServerConfig tioServerConfig, String userId, String chatGroupId) {
        ImSender.bindGroup(tioServerConfig, userId, chatGroupId);
    }

    @Override
    public boolean checkIfKefu(String toUserId) {
        return false;
    }

    protected WsMessageDataPackets storeMessage(WsMessageDataPackets message, String readStatus, String type) {
        MessagePackets imMessage = new MessagePackets();
        imMessage.setMessageToId(message.getMessageToId());
        imMessage.setId(message.getId());
        imMessage.setMessageFromId(message.getMessageFromId());
        imMessage.setMessageSendTime((Date)DateUtil.date());
        imMessage.setMessageContent(message.getMessageContent());
        imMessage.setMessageStatus(readStatus);
        imMessage.setMessageChatType(type);
        imMessage.setMessageType(message.getMessageType());
        imMessage.setMessageReplyByRobot(message.getMessageReplyByRobot());
        imMessage.setMessageUndoStatus(0);
        imMessage = this.storeMessage(imMessage);
        message.setId(imMessage.getId());
        message.setMessageSendTime(imMessage.getMessageSendTime());
        message.setMessageUndoStatus(imMessage.getMessageUndoStatus());
        message.setMessageStatus(imMessage.getMessageStatus());
        return message;
    }

    protected ImPackets buildImPacket(WsResultPackets wsResult, WsMessageDataPackets message) {
        ImPackets imPacket = ImPackets.fromText(wsResult);
        imPacket.setMessageId(message.getId());
        imPacket.setServerId(TioConfigConstant.SERVER_ID);
        return imPacket;
    }
}

