/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.api.dto.ParentEntityDTO;
import com.els.common.enumerate.DeployWayEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.ConfigUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmRpcUtil;
import com.els.common.util.SrmUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.ElsTenantDTO;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.im.service.ImAccountLocalService;
import com.els.modules.supplier.api.service.SupplierRpcService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ElsTenant;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.ElsTenantService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class ImAccountLocalServiceImpl
implements ImAccountLocalService {
    @Resource
    private ElsSubAccountService accountInfoService;
    @Resource
    private ElsTenantService tenantService;

    @Override
    public ElsSubAccount getAccountInfoById(String accountId) {
        ElsSubAccount dbAccountInfo = this.accountInfoService.getSubAccountById(accountId);
        if (null == dbAccountInfo) {
            throw new ELSBootException(I18nUtil.translate((String)"\u8be5\u7528\u6237\u4e0d\u5b58\u5728"));
        }
        return dbAccountInfo;
    }

    @Override
    public List<ElsSubAccountDTO> getUsersByUserIdList(List<String> userIdList) {
        if (CollectionUtil.isEmpty(userIdList)) {
            return Lists.newArrayList();
        }
        List usersByUserIdList = this.accountInfoService.listByIds(userIdList);
        List<String> elsAccountList = usersByUserIdList.stream().map(ParentEntity::getElsAccount).collect(Collectors.toList());
        List<ElsTenantDTO> tenantList = this.tenantService.getTenantList(elsAccountList);
        List imUserDTOS = Convert.toList(ElsSubAccountDTO.class, (Object)usersByUserIdList);
        Map<String, String> map = tenantList.stream().collect(Collectors.toMap(ParentEntityDTO::getElsAccount, ElsTenantDTO::getCompanyName, (v1, v2) -> v2));
        for (ElsSubAccountDTO im : imUserDTOS) {
            String s = map.get(im.getElsAccount());
            if (CharSequenceUtil.isEmpty((CharSequence)s)) {
                s = "-";
            }
            im.setCompanyName(s);
        }
        return imUserDTOS;
    }

    @Override
    public Map<String, List<String>> loadElsAccountIdToMap(List<String> elsAccountList) {
        if (CollectionUtil.isEmpty(elsAccountList)) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(ParentEntity::getElsAccount, elsAccountList);
        wrapper.select(new SFunction[]{ParentEntity::getId, ParentEntity::getElsAccount});
        List list = this.accountInfoService.list((Wrapper)wrapper);
        return list.stream().collect(Collectors.groupingBy(ParentEntity::getElsAccount, Collectors.mapping(ParentEntity::getId, Collectors.toList())));
    }

    @Override
    public boolean checkIfSameElsAccountByUserId(String elsAccount, String groupMasterId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(ParentEntity::getElsAccount, (Object)elsAccount)).eq(ParentEntity::getId, (Object)groupMasterId);
        return this.accountInfoService.count((Wrapper)wrapper) > 0L;
    }

    @Override
    public List<String> loadElsAccountId(List<String> elsAccountList) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(ParentEntity::getElsAccount, elsAccountList);
        wrapper.select(new SFunction[]{ParentEntity::getId});
        List list = this.accountInfoService.list((Wrapper)wrapper);
        return list.stream().map(ParentEntity::getId).collect(Collectors.toList());
    }

    @Override
    public List<ElsSubAccount> listSubAccountList(String elsAccount) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.select(new SFunction[]{ParentEntity::getId, ParentEntity::getElsAccount, ElsSubAccount::getSubAccount, ElsSubAccount::getRealname, ElsSubAccount::getAvatar, ElsSubAccount::getEmail, ElsSubAccount::getStatus, ElsSubAccount::getTelephone, BaseEntity::getCreateBy, BaseEntity::getCreateTime, ElsSubAccount::getPost}).eq(ParentEntity::getElsAccount, (Object)elsAccount)).eq(ElsSubAccount::getStatus, (Object)"1");
        List list = this.accountInfoService.list((Wrapper)wrapper);
        return list;
    }

    @Override
    public List<ElsSubAccount> getUserByKeyWord(String name) {
        boolean sale;
        boolean purchase;
        LoginUserDTO loginUser = SrmUtil.getLoginUser();
        if (ConfigUtil.getPurchaseAccount().equals(loginUser.getElsAccount())) {
            purchase = true;
            sale = true;
        } else if (DeployWayEnum.SAAS.getValue().equals(ConfigUtil.getDeployWay())) {
            ElsTenant tenant = this.tenantService.findTenant(loginUser.getElsAccount());
            String tenantAttribute = CharSequenceUtil.emptyToDefault((CharSequence)tenant.getTenantAttribute(), (String)"");
            purchase = tenantAttribute.contains("purchase");
            sale = tenantAttribute.contains("supplier");
        } else {
            purchase = false;
            sale = true;
        }
        ArrayList<String> elsAccount = new ArrayList<String>();
        if (purchase || ConfigUtil.getPurchaseAccount().equals(loginUser.getElsAccount())) {
            List supplierToElsAccount = ((SupplierRpcService)SrmRpcUtil.getExecuteServiceImpl(SupplierRpcService.class)).getSupplierToElsAccount(name);
            elsAccount.addAll(supplierToElsAccount);
        }
        if (sale || !ConfigUtil.getPurchaseAccount().equals(loginUser.getElsAccount()) && !ConfigUtil.getPurchaseAccount().equals("100000")) {
            List supplierElsAccount = ((SupplierRpcService)SrmRpcUtil.getExecuteServiceImpl(SupplierRpcService.class)).getSupplierElsAccount(name);
            elsAccount.addAll(supplierElsAccount);
        }
        elsAccount.add(TenantContext.getTenant());
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{ParentEntity::getId, ParentEntity::getElsAccount, ElsSubAccount::getSubAccount, ElsSubAccount::getRealname, ElsSubAccount::getAvatar, ElsSubAccount::getEmail, ElsSubAccount::getStatus, ElsSubAccount::getTelephone, BaseEntity::getCreateBy, BaseEntity::getCreateTime, ElsSubAccount::getPost, ElsSubAccount::getDeptId});
        ((LambdaQueryWrapper)wrapper.in(ParentEntity::getElsAccount, elsAccount)).and(i -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.eq(ParentEntity::getElsAccount, (Object)name)).or()).like(ElsSubAccount::getRealname, (Object)name)).or()).like(ElsSubAccount::getSubAccount, (Object)name));
        List userList = this.accountInfoService.list((Wrapper)wrapper);
        List imUserDTOList = Convert.toList(ElsSubAccount.class, (Object)userList);
        return imUserDTOList;
    }

    @Override
    public List<ElsSubAccountDTO> listAccountByAccountAndSubAccount(Set<String> accountStr) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"concat(els_account,'_',sub_account)", accountStr);
        List list = this.accountInfoService.list((Wrapper)queryWrapper);
        List<String> elsAccountList = list.stream().map(ParentEntity::getElsAccount).collect(Collectors.toList());
        List<ElsTenantDTO> tenantList = this.tenantService.getTenantList(elsAccountList);
        List imUserDTOS = Convert.toList(ElsSubAccountDTO.class, (Object)list);
        Map<String, String> map = tenantList.stream().collect(Collectors.toMap(ParentEntityDTO::getElsAccount, ElsTenantDTO::getCompanyName, (v1, v2) -> v2));
        for (ElsSubAccountDTO im : imUserDTOS) {
            String s = map.get(im.getElsAccount());
            if (CharSequenceUtil.isEmpty((CharSequence)s)) {
                s = "-";
            }
            im.setCompanyName(s);
        }
        return imUserDTOS;
    }
}

