/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.account.password.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.ConfigUtil;
import com.els.common.util.PwVerifyUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.account.password.entity.PasswordSecurity;
import com.els.modules.account.password.entity.PasswordUpdateRecord;
import com.els.modules.account.password.mapper.PasswordSecurityMapper;
import com.els.modules.account.password.service.PasswordSecurityService;
import com.els.modules.account.password.service.PasswordUpdateRecordService;
import com.els.modules.account.password.vo.PasswordCheckResultVO;
import jakarta.annotation.Resource;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class PasswordSecurityServiceImpl
extends BaseServiceImpl<PasswordSecurityMapper, PasswordSecurity>
implements PasswordSecurityService {
    private static final String REDIS_KEY = "srm:base:password:security:";
    @Resource
    private PasswordUpdateRecordService passwordUpdateRecordService;
    @Resource
    private RedisUtil redisUtil;

    @Override
    public void saveSecurity(PasswordSecurity passwordSecurity) {
        if (StrUtil.isBlank((CharSequence)passwordSecurity.getId())) {
            ((PasswordSecurityMapper)this.baseMapper).insert((Object)passwordSecurity);
        } else {
            ((PasswordSecurityMapper)this.baseMapper).update((Object)passwordSecurity, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(ParentEntity::getId, (Object)passwordSecurity.getId())).eq(ParentEntity::getElsAccount, (Object)this.getElsAccount()));
        }
        this.redisUtil.del(new String[]{REDIS_KEY + this.getElsAccount()});
    }

    @Override
    public PasswordSecurity getByElsAccount(String elsAccount) {
        PasswordSecurity security = (PasswordSecurity)((Object)this.redisUtil.get(REDIS_KEY + elsAccount));
        if (security != null) {
            return security;
        }
        security = null;
        List list = this.list((Wrapper)new LambdaUpdateWrapper().eq(ParentEntity::getElsAccount, (Object)elsAccount));
        if (!list.isEmpty()) {
            security = (PasswordSecurity)((Object)list.get(0));
        }
        if (security == null && !(list = this.list((Wrapper)new LambdaUpdateWrapper().eq(ParentEntity::getElsAccount, (Object)ConfigUtil.getPurchaseAccount()))).isEmpty()) {
            security = (PasswordSecurity)((Object)list.get(0));
        }
        if (security == null && !"100000".equals(ConfigUtil.getPurchaseAccount()) && !(list = this.list((Wrapper)new LambdaUpdateWrapper().eq(ParentEntity::getElsAccount, (Object)"100000"))).isEmpty()) {
            security = (PasswordSecurity)((Object)list.get(0));
        }
        if (security != null) {
            this.redisUtil.set(REDIS_KEY + elsAccount, (Object)security);
        }
        return security;
    }

    @Override
    public PasswordCheckResultVO checkPassword(String elsAccount, String password) {
        PasswordSecurity security = this.getByElsAccount(elsAccount);
        if (security == null) {
            return new PasswordCheckResultVO(true, "");
        }
        String checkResult = PwVerifyUtil.pwComplexityVerifyStr((String)security.getComplexity(), (int)security.getMinLength(), (String)password);
        PasswordCheckResultVO checkResultVO = null;
        checkResultVO = StrUtil.isBlank((CharSequence)checkResult) ? new PasswordCheckResultVO(true, "") : new PasswordCheckResultVO(false, checkResult);
        checkResultVO.setForcePwdHis(security.getForcePwdHis());
        return checkResultVO;
    }

    @Override
    public PasswordCheckResultVO checkUpdatePassword(String elsAccount, String accountId) {
        PasswordSecurity security = this.getByElsAccount(elsAccount);
        if (security == null || security.getModifyInterval() == null || security.getModifyInterval() == 0) {
            return new PasswordCheckResultVO(true, "");
        }
        PasswordUpdateRecord updateRecord = null;
        List list = this.passwordUpdateRecordService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PasswordUpdateRecord::getAccountId, (Object)accountId)).orderByDesc(PasswordUpdateRecord::getRecordTime));
        if (!list.isEmpty()) {
            updateRecord = (PasswordUpdateRecord)((Object)list.get(0));
        }
        if (updateRecord == null) {
            return new PasswordCheckResultVO(false, "\u5f53\u524d\u8d26\u53f7\u9700\u8981\u4fee\u6539\u5bc6\u7801\uff01");
        }
        Integer modifyInterval = security.getModifyInterval();
        Date currentTime = new Date();
        Date recordTime = updateRecord.getRecordTime();
        DateTime checkTime = DateUtil.offsetDay((Date)recordTime, (int)modifyInterval);
        if (currentTime.compareTo((Date)checkTime) > 0) {
            return new PasswordCheckResultVO(false, "\u5f53\u524d\u8d26\u53f7\u9700\u8981\u4fee\u6539\u5bc6\u7801\uff01");
        }
        return new PasswordCheckResultVO(true, "");
    }
}

