/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.encryption;

import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.barcode.encryption.base.BaseEncryption;
import com.els.modules.barcode.encryption.base.IEncryption;
import com.els.modules.barcode.enumerate.I18nBarCodeEnum;
import com.els.modules.barcode.utils.EncodesUtil;
import java.math.BigInteger;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AES
extends BaseEncryption
implements IEncryption {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AES.class);
    private static final String AES_PRIVATE_KEY = "V5";
    private static final String KEY_ALGORITHM = "AES";

    private SecretKey getSecretKey() throws Exception {
        KeyGenerator secretGenerator = KeyGenerator.getInstance(KEY_ALGORITHM);
        secretGenerator.init(new SecureRandom(AES_PRIVATE_KEY.getBytes("utf-8")));
        return secretGenerator.generateKey();
    }

    private byte[] encrypt(String plainText) throws Exception {
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(1, this.getSecretKey());
        return cipher.doFinal(plainText.getBytes("utf-8"));
    }

    private byte[] decrypt(String cipherText) throws Exception {
        BigInteger bigInteger = new BigInteger(cipherText);
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(2, this.getSecretKey());
        return cipher.doFinal(EncodesUtil.decodeHex(bigInteger.toString(16)));
    }

    @Override
    public String plainTextEncrypt(String plainText) {
        try {
            return new BigInteger(EncodesUtil.encodeHex(this.encrypt(plainText)), 16).toString();
        }
        catch (Exception e) {
            log.error("AES\u52a0\u5bc6\u51fa\u9519", (Throwable)e);
            throw new ELSBootException(I18nUtil.translate((Enum)I18nBarCodeEnum.ENCRYPTION_ERROR), (Throwable)e, new String[0]);
        }
    }

    @Override
    public String cipherTextDecrypt(String cipherText) {
        try {
            return new String(this.decrypt(cipherText), "utf-8");
        }
        catch (Exception e) {
            log.error("AES\u52a0\u5bc6\u51fa\u9519", (Throwable)e);
            throw new ELSBootException(I18nUtil.translate((Enum)I18nBarCodeEnum.ENCRYPTION_ERROR), (Throwable)e, new String[0]);
        }
    }
}

