/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bi.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.RedisKeyUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SrmRpcUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.AccountInfoRpcService;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.bi.service.BiInvokeService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.vo.pojo.BiUser;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="biInvokeService_getCurrentUserByAccount")
public class BiInvokeGetCurrentUserByAccountServiceImpl
implements BiInvokeService {
    @Override
    public Object invoke(JSONObject object) {
        String adminFlag;
        String elsAccount = object.getString("elsAccount");
        String subAccount = object.getString("subAccount");
        if (CharSequenceUtil.isEmpty((CharSequence)elsAccount) || CharSequenceUtil.isEmpty((CharSequence)subAccount)) {
            throw new ELSBootException("elsAccount\u548csubAccount\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ElsSubAccountService elsSubAccountService = (ElsSubAccountService)SpringContextUtils.getBean(ElsSubAccountService.class);
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ParentEntity::getElsAccount, (Object)elsAccount)).eq(ElsSubAccount::getSubAccount, (Object)subAccount)).eq(ElsSubAccount::getStatus, (Object)"1");
        ElsSubAccount account = (ElsSubAccount)((Object)elsSubAccountService.getOne((Wrapper)wrapper));
        if (account == null) {
            throw new ELSBootException("\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        TenantContext.setTenant((String)elsAccount);
        JSONObject tenantParam = ((BaseRpcService)SrmRpcUtil.getExecuteServiceImpl(BaseRpcService.class)).getParamObj(elsAccount);
        boolean isDataPermission = "1".equals(tenantParam.getString("dataPermissionShow"));
        String permissionScope = tenantParam.getString("permissionScope");
        List scopeList = StrUtil.split((CharSequence)permissionScope, (CharSequence)",");
        RedisUtil redisUtil = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class);
        String adminFlagRedisKey = RedisKeyUtil.getAdminFlagRedisKey((String)elsAccount, (String)subAccount);
        if (redisUtil.hasKey(adminFlagRedisKey)) {
            adminFlag = (String)redisUtil.get(adminFlagRedisKey);
        } else {
            adminFlag = ((AccountInfoRpcService)SrmRpcUtil.getExecuteServiceImpl(AccountInfoRpcService.class)).getAdminFlagByAccountId(account.getId());
            redisUtil.set(adminFlagRedisKey, (Object)adminFlag);
        }
        BiUser biUser = new BiUser();
        biUser.setId(account.getId());
        biUser.setElsAccount(account.getElsAccount());
        biUser.setSubAccount(account.getSubAccount());
        biUser.setName(account.getRealname());
        biUser.setDisplayName(elsAccount + "_" + subAccount + "_" + account.getRealname());
        biUser.setIsAdmin(adminFlag);
        biUser.setDataPermission(isDataPermission);
        biUser.setScopeList(scopeList);
        TenantContext.clear();
        return biUser;
    }
}

