/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.email.controller;

import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.email.entity.EmailConfig;
import com.els.modules.email.service.EmailConfigService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u90ae\u7bb1\u914d\u7f6e")
@RestController
@RequestMapping(value={"/base/emailConfig"})
public class EmailConfigController
extends BaseController<EmailConfig, EmailConfigService> {
    @Autowired
    private EmailConfigService emailConfigService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"emailConfig:list"})
    public Result<?> queryPageList(EmailConfig elsEmailConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsEmailConfig), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant());
        IPage pageList = this.emailConfigService.page((IPage)page, (Wrapper)queryWrapper);
        for (EmailConfig config : pageList.getRecords()) {
            config.setEmailPassword(null);
        }
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u6dfb\u52a0\u90ae\u4ef6\u914d\u7f6e", description="\u6dfb\u52a0\u90ae\u4ef6\u914d\u7f6e")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"emailConfig:add"})
    public Result<?> add(@RequestBody EmailConfig elsEmailConfig) {
        String msg = this.emailConfigService.add(elsEmailConfig);
        if (CharSequenceUtil.isNotEmpty((CharSequence)msg)) {
            return Result.error((String)msg);
        }
        return Result.ok((Object)((Object)elsEmailConfig));
    }

    @Operation(summary="\u7f16\u8f91\u90ae\u4ef6\u914d\u7f6e", description="\u7f16\u8f91\u90ae\u4ef6\u914d\u7f6e")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"emailConfig:edit"})
    public Result<?> edit(@RequestBody EmailConfig elsEmailConfig) {
        String msg = this.emailConfigService.edit(elsEmailConfig);
        if (CharSequenceUtil.isNotEmpty((CharSequence)msg)) {
            return Result.error((String)msg);
        }
        return this.queryById(elsEmailConfig.getId());
    }

    @Operation(summary="\u5220\u9664\u90ae\u4ef6\u914d\u7f6e", description="\u5220\u9664\u90ae\u4ef6\u914d\u7f6e")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"emailConfig:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.emailConfigService.delete(id);
        return Result.ok();
    }

    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"emailConfig:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        EmailConfig elsEmailConfig = (EmailConfig)((Object)this.emailConfigService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)elsEmailConfig));
    }
}

