/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.core.server.handler.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.modules.im.core.ImSender;
import com.els.modules.im.core.packets.ImPackets;
import com.els.modules.im.core.packets.WsMessageDataPackets;
import com.els.modules.im.core.packets.WsMessagePackets;
import com.els.modules.im.core.packets.WsMsgTypePackets;
import com.els.modules.im.core.packets.WsResultPackets;
import com.els.modules.im.core.server.handler.AbstractConnHandler;
import com.els.modules.im.core.server.handler.Opt;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Service;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.websocket.common.WsRequest;

@Service
public class VideoConnHandler
extends AbstractConnHandler {
    public static final String FRIEND = "friend";
    public static final String GROUP = "group";
    private static final String VIDEO_REQUEST = "video_request";
    private static final String VIDEO_ACCEPT = "video_accept";
    private static final String VIDEO_REJECT = "video_reject";

    @Override
    protected Object doHandler(WsResultPackets wsResult, WsRequest wsRequest, WsMessagePackets wsMessage, ChannelContext channelContext) {
        String type = wsMessage.getConnOpt();
        WsMessageDataPackets message = wsMessage.getMessage();
        if (type.startsWith(GROUP)) {
            wsResult.setData(wsMessage.getMessage());
            if (type.contains(VIDEO_REQUEST)) {
                wsResult.setMsgType(WsMsgTypePackets.MSG_VIDEO_REQUEST.getMsgType());
            } else if (type.contains(VIDEO_ACCEPT)) {
                wsResult.setMsgType(WsMsgTypePackets.MSG_VIDEO_ACCEPT.getMsgType());
            } else {
                wsResult.setMsgType(WsMsgTypePackets.MSG_VIDEO_REJECT.getMsgType());
            }
            boolean inGroup = Tio.isInGroup((String)message.getMessageToId(), (ChannelContext)channelContext);
            if (!inGroup) {
                ImSender.clusterToBindGroup(channelContext.userid, message.getMessageToId());
            }
            ImPackets imPacket = ImPackets.fromText(wsResult);
            ImSender.sendToGroupChannelContext(message.getMessageToId(), Lists.newArrayList(), channelContext.getTioConfig(), imPacket);
        } else {
            wsResult.setData(wsMessage.getMessage());
            if (type.contains(VIDEO_REQUEST)) {
                wsResult.setMsgType(WsMsgTypePackets.MSG_VIDEO_REQUEST.getMsgType());
            } else if (type.contains(VIDEO_ACCEPT)) {
                wsResult.setMsgType(WsMsgTypePackets.MSG_VIDEO_ACCEPT.getMsgType());
            } else {
                wsResult.setMsgType(WsMsgTypePackets.MSG_VIDEO_REJECT.getMsgType());
            }
            ImPackets imPacket = ImPackets.fromText(wsResult);
            imPacket.setData(wsResult);
            imPacket.setMessageId(CharSequenceUtil.isEmpty((CharSequence)imPacket.getMessageId()) ? IdWorker.getIdStr() : imPacket.getMessageId());
            ImSender.sendToUser(channelContext.userid, channelContext.getTioConfig(), imPacket);
        }
        return null;
    }

    @Override
    public Opt opt() {
        return Opt.MSG_VIDEO_CONN;
    }
}

