/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlInjectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.util.SrmUtil;
import com.els.modules.im.dto.ImMessageDto;
import com.els.modules.im.entity.ImMessage;
import com.els.modules.im.mapper.ImGroupChatMapper;
import com.els.modules.im.mapper.ImGroupMessageUserMapper;
import com.els.modules.im.mapper.ImMessageMapper;
import com.els.modules.im.service.IImMessageService;
import com.els.modules.im.vo.ImGroupChatVO;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImMessageServiceImpl
extends ServiceImpl<ImMessageMapper, ImMessage>
implements IImMessageService {
    @Autowired
    private ImGroupChatMapper imChatGroupMapper;
    @Autowired
    private ImGroupMessageUserMapper imGroupMessageUserMapper;
    @Autowired
    private ImMessageMapper imMessageMapper;

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void saveMessage(ImMessage imMessage) {
        imMessage.setId(IdWorker.getIdStr());
        new SaveChatMessageThread(imMessage).run();
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void batchSaveMessage(List<ImMessage> imMessages) {
        this.saveBatch(imMessages);
    }

    @Override
    public List<ImMessage> getUnReadMessage(String toId, String type) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ImMessage::getMessageToId, (Object)toId)).eq(ImMessage::getMessageUndoStatus, (Object)0)).eq(ImMessage::getMessageStatus, (Object)"0")).eq(ImMessage::getMessageChatType, (Object)type);
        List messageList = ((ImMessageMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        for (ImMessage message : messageList) {
            message.setMessageStatus("1");
            this.updateById(message);
        }
        return messageList;
    }

    @Override
    public List<ImMessage> getUnReadMessage(String toId, String fromId, String type) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ImMessage::getMessageToId, (Object)toId)).eq(ImMessage::getMessageUndoStatus, (Object)0)).eq(ImMessage::getMessageStatus, (Object)"1")).eq(CharSequenceUtil.isNotEmpty((CharSequence)fromId), ImMessage::getMessageFromId, (Object)fromId)).eq(ImMessage::getMessageChatType, (Object)type);
        List messageList = ((ImMessageMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        for (ImMessage message : messageList) {
            message.setMessageStatus("1");
            this.updateById(message);
        }
        return messageList;
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public List<ImMessage> getChatLog(String toId, String type) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ImMessage::getMessageToId, (Object)toId)).eq(ImMessage::getMessageUndoStatus, (Object)0)).eq(ImMessage::getMessageChatType, (Object)type);
        return ((ImMessageMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public Page<ImMessage> pageMessage(Page<ImMessage> page, String type, String userId) {
        return ((ImMessageMapper)this.baseMapper).pageMessage(page, type, userId);
    }

    @Override
    public IPage<ImGroupChatVO> groupPage(ImMessageDto imMessageDto, Integer pageNo, Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        imMessageDto.setUserId(SrmUtil.getLoginUser().getId());
        SqlInjectionUtils.check((String)(imMessageDto.getColumn() + " " + imMessageDto.getOrder()));
        return this.imChatGroupMapper.groupPage((IPage<ImGroupChatVO>)page, imMessageDto);
    }

    @Override
    public void asyncUndoMessage(String messageId, String fromId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)wrapper.eq(ImMessage::getId, (Object)messageId)).eq(ImMessage::getMessageFromId, (Object)fromId);
        wrapper.set(ImMessage::getMessageUndoStatus, (Object)1);
        ((ImMessageMapper)this.baseMapper).update(null, (Wrapper)wrapper);
    }

    @Override
    public List<ImMessage> getGroupUnReadMessage(String userid) {
        return this.imMessageMapper.listUnReadMessage(userid);
    }

    @Override
    public void deleteGroupUnReadMessage(List<Integer> msgIds) {
        this.imGroupMessageUserMapper.deleteBatchIds(msgIds);
    }

    @Override
    public List<ImMessage> listLastMessage(List<String> groupIdList) {
        if (CollectionUtil.isEmpty(groupIdList)) {
            return Lists.newArrayList();
        }
        return this.imMessageMapper.selectLastMessageByToIds(groupIdList);
    }

    class SaveChatMessageThread
    implements Runnable {
        private ImMessage imMessage;

        public SaveChatMessageThread(ImMessage imMessage) {
            this.imMessage = imMessage;
        }

        @Override
        public void run() {
            ImMessageServiceImpl.this.save(this.imMessage);
        }
    }
}

