/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.justauth.controller;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.els.common.constant.SrmConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.ConfigUtil;
import com.els.common.util.SrmUtil;
import com.els.modules.account.entity.ExternalAccount;
import com.els.modules.account.entity.ExternalVoucher;
import com.els.modules.account.service.ExternalAccountService;
import com.els.modules.account.service.ExternalVoucherService;
import com.els.modules.justauth.aes.AesException;
import com.els.modules.justauth.aes.WXBizMsgCrypt;
import com.els.modules.justauth.aes.WechatMessageUtil;
import com.els.modules.justauth.util.WechatEnterpriseApiUtil;
import com.els.modules.justauth.vo.WechatEnterpriseDevelopVO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@Tag(name="\u5fae\u4fe1\u516c\u4f17\u53f7\u548c\u4f01\u4e1a\u5fae\u4fe1\u4ee3\u5f00\u53d1\u56de\u8c03")
@RestController
@RequestMapping(value={"/base/wechat"})
public class WechatController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WechatController.class);
    @Resource
    private ExternalAccountService externalAccountService;
    @Resource
    private ElsSubAccountService accountInfoService;
    @Resource
    private ExternalVoucherService externalVoucherService;
    @Autowired
    private WechatEnterpriseApiUtil wechatEnterpriseApiUtil;

    @GetMapping(value={"/noToken/generationDevelopment/{busAccount}/callback"})
    public void callbackGet(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="msg_signature") String msgSignature, @RequestParam(value="timestamp") String timestamp, @RequestParam(value="nonce") String nonce, @RequestParam(value="echostr") String echostr, @PathVariable(value="busAccount") String busAccount) throws AesException {
        String cropId = request.getParameter("corpId");
        if (CharSequenceUtil.isNotBlank((CharSequence)cropId) && "$CORPID$".contains(cropId.toUpperCase())) {
            cropId = null;
        }
        log.info("#WechatController.callbackGet\u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\u4ee3\u521b\u5efa\u56de\u8c03==>cropId:{},msg_signature:{},timestamp:{},nonce:{},echostr:{},busAccount:{}", new Object[]{cropId, msgSignature, timestamp, nonce, echostr, busAccount});
        ExternalVoucher wechatMp = this.externalVoucherService.getOneBindLoginTemplateConfig(ConfigUtil.getPurchaseAccount(), "wechat_enterprise_develop");
        if (null == wechatMp && null == (wechatMp = this.externalVoucherService.getOneBindLoginTemplateConfig("100000", "wechat_enterprise_develop"))) {
            throw new ELSBootException("\u4e0d\u5b58\u5728\u5fae\u4fe1\u4f01\u4e1a\u4ee3\u5f00\u53d1\u5e94\u7528\u914d\u7f6e");
        }
        String extentParam = CharSequenceUtil.emptyToDefault((CharSequence)wechatMp.getExtendParam(), (String)"{}");
        WechatEnterpriseDevelopVO developVO = (WechatEnterpriseDevelopVO)JSON.parseObject((String)extentParam, WechatEnterpriseDevelopVO.class);
        WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(developVO.getCustomAppToken(), developVO.getCustomAppKey(), CharSequenceUtil.emptyToDefault((CharSequence)cropId, (String)developVO.getSuiteId()));
        try {
            String sEchoStr = wxcpt.VerifyURL(msgSignature, timestamp, nonce, echostr);
            response.getOutputStream().print(sEchoStr);
            response.setStatus(200);
            response.flushBuffer();
        }
        catch (Exception e) {
            log.error("#WechatController.callbackGet\u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\u4ee3\u521b\u5efa\u56de\u8c03\u5931\u8d25:{}", (Object)e.getMessage());
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)cropId) && CharSequenceUtil.isNotBlank((CharSequence)busAccount)) {
            this.externalVoucherService.weDevelopBindAuth(cropId, busAccount);
        }
    }

    @PostMapping(value={"/noToken/generationDevelopment/{busAccount}/callback"})
    public void callbackPost(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="msg_signature") String msgSignature, @RequestParam(value="timestamp") String timestamp, @RequestParam(value="nonce") String nonce, @PathVariable(value="busAccount") String busAccount) throws IOException {
        String authCropId = request.getParameter("corpId");
        if (CharSequenceUtil.isNotBlank((CharSequence)authCropId) && "$CORPID$".contains(authCropId.toUpperCase())) {
            authCropId = null;
        }
        log.info("#WechatController.callbackPost\u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\u4ee3\u521b\u5efa\u6570\u636e\u63a8\u9001==>(\u52a0\u5bc6)cropId:{},msg_signature:{},timestamp:{},nonce:{},busAccount:{}", new Object[]{authCropId, msgSignature, timestamp, nonce, busAccount});
        try {
            ServletInputStream inputStream = request.getInputStream();
            String sPostData = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            ExternalVoucher wechatMp = this.externalVoucherService.getOneBindLoginTemplateConfig(ConfigUtil.getPurchaseAccount(), "wechat_enterprise_develop");
            if (null == wechatMp && null == (wechatMp = this.externalVoucherService.getOneBindLoginTemplateConfig("100000", "wechat_enterprise_develop"))) {
                throw new ELSBootException("\u4e0d\u5b58\u5728\u5fae\u4fe1\u4f01\u4e1a\u4ee3\u5f00\u53d1\u5e94\u7528\u914d\u7f6e");
            }
            String extentParam = CharSequenceUtil.emptyToDefault((CharSequence)wechatMp.getExtendParam(), (String)"{}");
            WechatEnterpriseDevelopVO developVO = (WechatEnterpriseDevelopVO)JSON.parseObject((String)extentParam, WechatEnterpriseDevelopVO.class);
            WXBizMsgCrypt msgCrypt = new WXBizMsgCrypt(developVO.getCustomAppToken(), developVO.getCustomAppKey(), CharSequenceUtil.emptyToDefault((CharSequence)authCropId, (String)developVO.getSuiteId()));
            Map<String, String> allData = WechatMessageUtil.parseXml(sPostData);
            String sMsg = msgCrypt.DecryptMsg(msgSignature, timestamp, nonce, sPostData);
            Map<String, String> dataMap = WechatMessageUtil.parseXml(sMsg);
            String finalAuthCropId = authCropId;
            ExternalVoucher finalWechatMp = wechatMp;
            SrmUtil.getTheadPool().execute(() -> this.doCallbackPost(allData, dataMap, finalAuthCropId, finalWechatMp, developVO, busAccount));
        }
        catch (Exception e) {
            log.error("#WechatController.callbackPost\u4f01\u4e1a\u5fae\u4fe1\u81ea\u5efa\u5e94\u7528\u4ee3\u5f00\u53d1\u6570\u636e\u63a8\u9001\u5931\u8d25:{}", (Object)e.getMessage());
        }
        response.getOutputStream().print("success");
        response.setStatus(200);
        response.flushBuffer();
    }

    private void doCallbackPost(Map<String, String> allData, Map<String, String> dataMap, String authCropId, ExternalVoucher wechatMp, WechatEnterpriseDevelopVO developVO, String busAccount) {
        String infoType = dataMap.get("InfoType");
        String event = dataMap.get("Event");
        log.info(":::busAccount:{},infoType:{},event:{},\u4f01\u4e1a\u5fae\u4fe1\u63a8\u9001\u6570\u636e:{}", new Object[]{busAccount, infoType, event, JSON.toJSONString(dataMap)});
        if (CharSequenceUtil.isNotEmpty((CharSequence)event) && "change_app_admin".equals(event)) {
            return;
        }
        switch (infoType) {
            case "suite_ticket": {
                this.wechatEnterpriseApiUtil.setSuiteTicket(dataMap);
                break;
            }
            case "create_auth": {
                JSONObject jsonObject = this.wechatEnterpriseApiUtil.createAuth(developVO.getSuitesSecret(), dataMap);
                this.externalVoucherService.weDevelopCreateAuth(wechatMp, jsonObject);
                break;
            }
            case "change_auth": {
                this.wechatEnterpriseApiUtil.changeAuth(developVO.getSuitesSecret(), dataMap);
                break;
            }
            case "cancel_auth": {
                this.wechatEnterpriseApiUtil.cancelAuth(dataMap);
                String authCorpId = dataMap.get("AuthCorpId");
                this.externalVoucherService.cancelWeDevelopAuth(authCorpId, busAccount, "wechat_enterprise_develop");
                break;
            }
            case "reset_permanent_code": {
                JSONObject jsonObject = this.wechatEnterpriseApiUtil.resetPermanentCode(developVO.getSuitesSecret(), dataMap);
                this.externalVoucherService.weDevelopResetAuth(wechatMp, jsonObject);
                break;
            }
            case "change_contact": {
                this.wechatEnterpriseApiUtil.changeContact(developVO.getSuitesSecret(), dataMap);
                break;
            }
            case "share_agent_change": {
                this.wechatEnterpriseApiUtil.shareAgentChange(authCropId, developVO.getSuitesSecret(), dataMap);
                break;
            }
            default: {
                log.info(":::\u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\u4ee3\u521b\u5efa\u63a8\u9001\u6570\u636e\u7c7b\u578b:{}", (Object)infoType);
            }
        }
    }

    @GetMapping(value={"/auth/{elsAccount}/{subAccount}"})
    public void weChatMpAuth(@PathVariable String elsAccount, @PathVariable String subAccount, @RequestParam(value="code") String code) {
        String appsecret;
        ExternalVoucher config = this.externalVoucherService.getOneBindLoginTemplateConfig(elsAccount, "wechat_mp");
        if (null == config) {
            throw new ELSBootException("\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        RestTemplate restTemplate = new RestTemplate();
        String appId = config.getVoucherKey();
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + appId + "&secret=" + (appsecret = config.getVoucherSecret()) + "&code=" + code + "&grant_type=authorization_code";
        ResponseEntity respon = restTemplate.getForEntity(url, String.class, new Object[0]);
        if (HttpStatus.OK == respon.getStatusCode()) {
            String body = (String)respon.getBody();
            JSONObject jsonObject = JSONObject.parseObject((String)body);
            if (jsonObject.containsKey("errcode")) {
                log.error("#WechatController.weChatMpAuth\u6388\u6743\u62a5\u9519\uff1a{},{}", (Object)jsonObject.getString("errcode"), (Object)jsonObject.getString("errmsg"));
                return;
            }
            ElsSubAccount byAccount = this.accountInfoService.getByAccount(elsAccount, subAccount);
            if (null == byAccount) {
                log.error("\u8d26\u53f7\u4e0d\u5b58\u5728:{},{}", (Object)elsAccount, (Object)subAccount);
                return;
            }
            ExternalAccount user = new ExternalAccount();
            user.setEnabled(SrmConstant.YES_1);
            user.setAccountType("wechat_mp");
            user.setExternalAccountId(jsonObject.getString("openid"));
            user.setAccountId(byAccount.getId());
            user.setElsAccount(elsAccount);
            user.setCreateTime(new Date());
            this.externalAccountService.checkAndSave(user);
        }
    }

    @Operation(summary="\u4f01\u4e1a\u5fae\u4fe1\u63a5\u6536\u6d88\u606f-\u901a\u77e5\u56de\u8c03", description="\u4f01\u4e1a\u5fae\u4fe1\u63a5\u6536\u6d88\u606f-\u901a\u77e5\u56de\u8c03")
    @GetMapping(value={"/noToken/thirdAuthorizeCallBack/{busAccount}"})
    public void thirdAuthorizeCallBack(HttpServletResponse response, HttpServletRequest request, @RequestParam(value="msg_signature") String msgSignature, @RequestParam(value="timestamp") String timestamp, @RequestParam(value="nonce") String nonce, @RequestParam(value="echostr") String echostr, @PathVariable(value="busAccount") String busAccount) throws Exception {
        String authCropId = request.getParameter("corpId");
        if (CharSequenceUtil.isNotBlank((CharSequence)authCropId) && "$CORPID$".contains(authCropId.toUpperCase())) {
            authCropId = null;
        }
        log.info("#WechatController.thirdAuthorizeCallBack authCropId:{}", (Object)authCropId);
        ExternalVoucher wechatMp = this.externalVoucherService.getOneBindLoginTemplateConfig(ConfigUtil.getPurchaseAccount(), "wechat_enterprise_develop");
        if (null == wechatMp && null == (wechatMp = this.externalVoucherService.getOneBindLoginTemplateConfig("100000", "wechat_enterprise_develop"))) {
            throw new ELSBootException("\u4e0d\u5b58\u5728\u5fae\u4fe1\u4f01\u4e1a\u4ee3\u5f00\u53d1\u5e94\u7528\u914d\u7f6e");
        }
        String extentParam = CharSequenceUtil.emptyToDefault((CharSequence)wechatMp.getExtendParam(), (String)"{}");
        WechatEnterpriseDevelopVO developVO = (WechatEnterpriseDevelopVO)JSON.parseObject((String)extentParam, WechatEnterpriseDevelopVO.class);
        WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(developVO.getCustomAppToken(), developVO.getCustomAppKey(), CharSequenceUtil.emptyToDefault((CharSequence)authCropId, (String)wechatMp.getVoucherKey()));
        try {
            String sEchoStr = wxcpt.VerifyURL(msgSignature, timestamp, nonce, echostr);
            response.getOutputStream().print(sEchoStr);
            response.setStatus(200);
            response.flushBuffer();
        }
        catch (Exception e) {
            log.error("#WechatController.thirdAuthorizeCallBack\u4f01\u4e1a\u5fae\u4fe1\u56de\u8c03\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    @Operation(summary="\u4f01\u4e1a\u5fae\u4fe1\u63a5\u6536\u6d88\u606f-\u901a\u77e5\u63a8\u9001", description="\u4f01\u4e1a\u5fae\u4fe1\u63a5\u6536\u6d88\u606f-\u901a\u77e5\u63a8\u9001")
    @PostMapping(value={"/noToken/thirdAuthorizeCallBack/{busAccount}"})
    public void thirdAuthorize(HttpServletResponse response, HttpServletRequest request, @RequestParam(value="msg_signature") String msgSignature, @RequestParam(value="timestamp") String timestamp, @RequestParam(value="nonce") String nonce, @PathVariable(value="busAccount") String busAccount) throws Exception {
        String authCropId = request.getParameter("corpId");
        if (CharSequenceUtil.isNotBlank((CharSequence)authCropId) && "$CORPID$".contains(authCropId.toUpperCase())) {
            authCropId = null;
        }
        log.info("#WechatController.thirdAuthorize authCropId:{}", (Object)authCropId);
        Enumeration parameterNames = request.getParameterNames();
        StringBuilder param = new StringBuilder();
        while (parameterNames.hasMoreElements()) {
            String element = (String)parameterNames.nextElement();
            String value = request.getParameter(element);
            if (!CharSequenceUtil.isNotBlank((CharSequence)value)) continue;
            param.append(element).append("=").append(value).append("&");
        }
        try {
            ServletInputStream inputStream = request.getInputStream();
            String sPostData = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            ExternalVoucher wechatMp = this.externalVoucherService.getOneBindLoginTemplateConfig(ConfigUtil.getPurchaseAccount(), "wechat_enterprise_develop");
            if (null == wechatMp && null == (wechatMp = this.externalVoucherService.getOneBindLoginTemplateConfig("100000", "wechat_enterprise_develop"))) {
                throw new ELSBootException("\u4e0d\u5b58\u5728\u5fae\u4fe1\u4f01\u4e1a\u4ee3\u5f00\u53d1\u5e94\u7528\u914d\u7f6e");
            }
            String extentParam = CharSequenceUtil.emptyToDefault((CharSequence)wechatMp.getExtendParam(), (String)"{}");
            WechatEnterpriseDevelopVO developVO = (WechatEnterpriseDevelopVO)JSON.parseObject((String)extentParam, WechatEnterpriseDevelopVO.class);
            WXBizMsgCrypt msgCrypt = new WXBizMsgCrypt(developVO.getCustomAppToken(), developVO.getCustomAppKey(), wechatMp.getVoucherKey());
            Map<String, String> allData = WechatMessageUtil.parseXml(sPostData);
            String sMsg = msgCrypt.DecryptMsg(msgSignature, timestamp, nonce, sPostData);
            Map<String, String> map = WechatMessageUtil.parseXml(sMsg);
        }
        catch (Exception e) {
            log.error("#WechatController.thirdAuthorize\u4f01\u4e1a\u5fae\u4fe1\u63a5\u6536\u6d88\u606f-\u901a\u77e5\u63a8\u9001:{}", (Object)e.getMessage());
        }
        response.getOutputStream().print("success");
        response.setStatus(200);
        response.flushBuffer();
    }
}

