/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.log.excel;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.excel.service.BaseExportService;
import com.els.common.util.ConvertUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.ExportDataLoaderService;
import com.els.modules.log.entity.Log;
import com.els.modules.log.service.LogService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="logExportExcelDataBatchQueryLoader")
public class LogExportServiceImpl
extends BaseExportService<Log, Log, Log>
implements ExportDataLoaderService {
    @Autowired
    private LogService logService;

    public List<Log> queryExportData(QueryWrapper<Log> queryWrapper, Log param, Map<String, String[]> paramMap) {
        String[] keyWord = paramMap.get("keyWord");
        String startTime = paramMap.get("startTime")[0];
        String endTime = paramMap.get("endTime")[0];
        if (null != keyWord && keyWord.length != 0 && ConvertUtils.isNotEmpty((Object)keyWord[0])) {
            queryWrapper.like((Object)"business_number", (Object)keyWord[0]);
        }
        queryWrapper.lambda().eq(Log::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.lambda().eq(Log::getBusModule, (Object)"userSystemSecurity");
        queryWrapper.lambda().between(Log::getCreateTime, (Object)DateUtil.parse((CharSequence)startTime, (String)"yyyy-MM-dd"), (Object)DateUtil.parse((CharSequence)endTime, (String)"yyyy-MM-dd"));
        return this.logService.list((Wrapper)queryWrapper);
    }

    public long queryExportDataCount(QueryWrapper<Log> queryWrapper, Log map, Map<String, String[]> paramMap) {
        String[] keyWord = paramMap.get("keyWord");
        String startTime = paramMap.get("startTime")[0];
        String endTime = paramMap.get("endTime")[0];
        if (null != keyWord && keyWord.length != 0 && ConvertUtils.isNotEmpty((Object)keyWord[0])) {
            queryWrapper.like((Object)"business_number", (Object)keyWord[0]);
        }
        queryWrapper.lambda().eq(Log::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.lambda().eq(Log::getBusModule, (Object)"userSystemSecurity");
        queryWrapper.lambda().between(Log::getCreateTime, (Object)DateUtil.parse((CharSequence)startTime, (String)"yyyy-MM-dd"), (Object)DateUtil.parse((CharSequence)endTime, (String)"yyyy-MM-dd"));
        return this.logService.count((Wrapper)queryWrapper);
    }

    public String getBusinessType() {
        return "ElsLog";
    }

    public String getBeanName() {
        return "logExportExcelDataBatchQueryLoader";
    }

    public String loadData(Integer pageNumber, Integer pageSize, Map<String, Object> entityMap, Map<String, String[]> paramMap) {
        Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = this.builderWrapper(entityMap, paramMap);
        String[] keyWord = paramMap.get("keyWord");
        String startTime = paramMap.get("startTime")[0];
        String endTime = paramMap.get("endTime")[0];
        if (null != keyWord && keyWord.length != 0 && ConvertUtils.isNotEmpty((Object)keyWord[0])) {
            queryWrapper.like((Object)"business_number", (Object)keyWord[0]);
        }
        queryWrapper.lambda().eq(Log::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.lambda().between(Log::getCreateTime, (Object)DateUtil.parse((CharSequence)startTime, (String)"yyyy-MM-dd"), (Object)DateUtil.parse((CharSequence)endTime, (String)"yyyy-MM-dd"));
        return JSON.toJSONString((Object)((Page)this.logService.page((IPage)page, (Wrapper)queryWrapper)).getRecords());
    }
}

