/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.excel;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.constant.CommonConstant;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.PermissionData;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.PermissionDataService;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="permissionDataExcelRpcImportImpl")
public class PermissionDataImportImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private PermissionDataService permissionDataService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        String elsAccount = TenantContext.getTenant();
        HashMap<String, String> accountMap = new HashMap<String, String>();
        ArrayList<PermissionData> list = new ArrayList<PermissionData>();
        String errorTitle = this.getErrorTitle();
        ArrayList<CallSite> permissonList = new ArrayList<CallSite>();
        ArrayList<CallSite> p = new ArrayList<CallSite>();
        for (Map data : dataList) {
            String subAccount = (String)data.get("subAccount");
            String businessType = (String)data.get("businessType");
            String permissionField = (String)data.get("permissionField");
            String permissionValue = (String)data.get("permissionValue");
            p.add((CallSite)((Object)(subAccount + "_" + businessType + "_" + permissionField + "_" + permissionValue)));
        }
        QueryWrapper wrapper = Wrappers.query();
        wrapper.in((Object)"sub_account,'_',business_type,'_',permission_field,'_',permission_value)", p);
        wrapper.lambda().eq(ParentEntity::getElsAccount, (Object)SysUtil.getLoginUser().getElsAccount());
        List dbDataList = this.permissionDataService.list((Wrapper)wrapper);
        Map<String, String> map = dbDataList.stream().collect(Collectors.toMap(x -> x.getSubAccount() + x.getBusinessType() + x.getPermissionField() + x.getPermissionValue(), ParentEntity::getId, (v1, v2) -> v2));
        for (Map data : dataList) {
            String msg;
            PermissionData permissionData = (PermissionData)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), PermissionData.class));
            permissionData.setElsAccount(elsAccount);
            permissionData.setDeleted(CommonConstant.DEL_FLAG_0);
            permissionData.setCreateTime(new Date());
            String subAccount = permissionData.getSubAccount();
            if (accountMap.containsKey(subAccount)) {
                permissionData.setUserId((String)accountMap.get(subAccount));
            } else {
                ElsSubAccount account = this.elsSubAccountService.getByAccount(elsAccount, subAccount);
                if (account == null) {
                    msg = I18nUtil.translate((String)"i18n_alert_JeyWWWWWWxMKWVnIWFW_1bb4cb5d", (String)"\u5b50\u8d26\u53f7\uff1a${0} \u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u6570\u636e\uff01", (String[])new String[]{subAccount});
                    excelImportDTO.getErrorTitleList().add(errorTitle + "subAccount");
                    data.put(errorTitle + "subAccount", msg);
                    excelImportDTO.getErrorDataList().add(data);
                    continue;
                }
                accountMap.put(subAccount, account.getId());
                permissionData.setUserId(account.getId());
            }
            String s = permissionData.getSubAccount() + permissionData.getBusinessType() + permissionData.getPermissionField() + permissionData.getPermissionValue();
            if (permissonList.contains(s)) {
                msg = I18nUtil.translate((String)"i18n_alert_bWWFERVB_d5ebb0c", (String)"\u6743\u9650\u6570\u636e\u914d\u7f6e\u91cd\u590d\uff01");
                excelImportDTO.getErrorTitleList().add(errorTitle + "duplication");
                data.put(errorTitle + "duplication", msg);
                excelImportDTO.getErrorDataList().add(data);
                continue;
            }
            if (CharSequenceUtil.isEmpty((CharSequence)permissionData.getId()) && map.containsKey(s)) {
                msg = I18nUtil.translate((String)"i18n_alert_bWWFERVB_d5ebb0c", (String)"\u6743\u9650\u6570\u636e\u914d\u7f6e\u91cd\u590d\uff01");
                excelImportDTO.getErrorTitleList().add(errorTitle + "duplication");
                data.put(errorTitle + "duplication", msg);
                excelImportDTO.getErrorDataList().add(data);
                continue;
            }
            if (CharSequenceUtil.isNotEmpty((CharSequence)permissionData.getId()) && map.containsKey(s) && !permissionData.getId().equals(map.get(s))) {
                msg = I18nUtil.translate((String)"i18n_alert_bWWFERVB_d5ebb0c", (String)"\u6743\u9650\u6570\u636e\u914d\u7f6e\u91cd\u590d\uff01");
                excelImportDTO.getErrorTitleList().add(errorTitle + "duplication");
                data.put(errorTitle + "duplication", msg);
                excelImportDTO.getErrorDataList().add(data);
                continue;
            }
            permissonList.add((CallSite)((Object)s));
            list.add(permissionData);
        }
        if (list.isEmpty()) {
            this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
            return dataList;
        }
        this.permissionDataService.batchSave(list);
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

