/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.core.server.handler.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.util.I18nUtil;
import com.els.modules.im.core.ImSender;
import com.els.modules.im.core.message.BusinessHelper;
import com.els.modules.im.core.packets.GroupChatUserPackets;
import com.els.modules.im.core.packets.ImPackets;
import com.els.modules.im.core.packets.ImUserPackets;
import com.els.modules.im.core.packets.MessagePackets;
import com.els.modules.im.core.packets.WsMessageDataPackets;
import com.els.modules.im.core.packets.WsMessagePackets;
import com.els.modules.im.core.packets.WsResultPackets;
import com.els.modules.im.core.server.handler.AbstractConnHandler;
import com.els.modules.im.core.server.handler.Opt;
import jakarta.annotation.Resource;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.websocket.common.WsRequest;

@Service
public class UndoMessageHandler
extends AbstractConnHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UndoMessageHandler.class);
    private static final String UNDO_MESSAGE_REQUEST = "undo_message_request";
    private static final String UNDO_MESSAGE_REPLY_ACCEPT = "undo_message_reply_accept";
    private static final String UNDO_MESSAGE_REPLY_REJECT = "undo_message_reply_reject";
    private static final int UNDO_TIME_OUT = 120000;
    @Resource(name="srmBusinessHelper")
    private BusinessHelper srmBusinessHelper;

    @Override
    protected Object doHandler(WsResultPackets wsResult, WsRequest wsRequest, WsMessagePackets wsMessage, ChannelContext channelContext) {
        WsMessageDataPackets message = wsMessage.getMessage();
        String type = wsMessage.getConnOpt();
        if (CharSequenceUtil.isEmpty((CharSequence)message.getUndoMessageId())) {
            log.warn("# UndoMessageHandler \u6d88\u606f\u64a4\u56de\u5904\u7406\u5668\u63a5\u6536\u5230\u64a4\u56de\u8bf7\u6c42\u6570\u636e\u4e0d\u89c4\u8303\uff0c\u7f3a\u5c11\u8981\u64a4\u56de\u7684\u6d88\u606fundoMessageId");
            return null;
        }
        if (UNDO_MESSAGE_REQUEST.equals(type)) {
            MessagePackets dbMessage = this.srmBusinessHelper.loadMessage(message.getUndoMessageId());
            if (null == dbMessage) {
                log.error("# UndoMessageHandler \u5f53\u524d\u6d88\u606f\u4e0d\u5b58\u5728undoMessageId:{}", (Object)message.getUndoMessageId());
                return null;
            }
            if (!dbMessage.getMessageFromId().equals(channelContext.userid)) {
                return null;
            }
            ImUserPackets imUserPackets = this.srmBusinessHelper.loadLoginUserDtoId(dbMessage.getMessageFromId());
            DateTime date = DateUtil.date();
            long diff = date.getTime() - dbMessage.getMessageSendTime();
            if (diff - 120000L < 0L) {
                if ("group".equals(dbMessage.getMessageChatType())) {
                    String groupId = dbMessage.getMessageToId();
                    wsResult.setMsgType(UNDO_MESSAGE_REPLY_ACCEPT);
                    WsMessageDataPackets mime = new WsMessageDataPackets();
                    mime.setMessageFromId(dbMessage.getMessageFromId());
                    mime.setMessageToId(dbMessage.getMessageToId());
                    mime.setId(dbMessage.getId());
                    mime.setMessageSendTime(date.getTime());
                    mime.setUndoMessageId(message.getUndoMessageId());
                    mime.setCompanyName(imUserPackets.getCompanyName());
                    mime.setHeadPortrait(imUserPackets.getAvatar());
                    mime.setAvatar(imUserPackets.getAvatar());
                    mime.setMessageSendTime(System.currentTimeMillis());
                    mime.setMessageContent(I18nUtil.translate((String)"\u60a8\u64a4\u56de\u4e86\u4e00\u6761\u6d88\u606f"));
                    mime.setAvatar(imUserPackets.getAvatar());
                    mime.setRealname(imUserPackets.getRealname());
                    mime.setElsAccount(imUserPackets.getElsAccount());
                    mime.setSubAccount(imUserPackets.getSubAccount());
                    wsResult.setData(mime);
                    ImPackets imPacket = ImPackets.fromText(wsResult);
                    ImSender.sendToUserChannelContext(dbMessage.getMessageFromId(), channelContext.getTioConfig(), imPacket);
                    List<GroupChatUserPackets> chatUserList = this.srmBusinessHelper.getGroupUsersByGroupId(groupId, null);
                    if (CollectionUtil.isEmpty(chatUserList)) {
                        this.srmBusinessHelper.asyncUndoMessage(dbMessage.getId(), channelContext.userid);
                        return null;
                    }
                    mime.setMessageContent(I18nUtil.translate((String)"\u64a4\u56de\u4e86\u4e00\u6761\u6d88\u606f"));
                    wsResult.setData(mime);
                    boolean inGroup = Tio.isInGroup((String)dbMessage.getMessageToId(), (ChannelContext)channelContext);
                    if (!inGroup) {
                        Tio.bindGroup((ChannelContext)channelContext, (String)dbMessage.getMessageToId());
                    }
                    imPacket = ImPackets.fromText(wsResult);
                    ImSender.sendToGroupChannelContext(groupId, null, channelContext.getTioConfig(), imPacket);
                    this.srmBusinessHelper.asyncUndoMessage(dbMessage.getId(), channelContext.userid);
                } else {
                    wsResult.setMsgType(UNDO_MESSAGE_REPLY_ACCEPT);
                    WsMessageDataPackets mime = new WsMessageDataPackets();
                    mime.setMessageFromId(dbMessage.getMessageFromId());
                    mime.setMessageToId(dbMessage.getMessageToId());
                    mime.setId(dbMessage.getId());
                    mime.setMessageSendTime(date.getTime());
                    mime.setUndoMessageId(message.getUndoMessageId());
                    mime.setMessageContent(I18nUtil.translate((String)"\u60a8\u64a4\u56de\u4e86\u4e00\u6761\u6d88\u606f"));
                    mime.setCompanyName(imUserPackets.getCompanyName());
                    mime.setHeadPortrait(imUserPackets.getAvatar());
                    mime.setAvatar(imUserPackets.getAvatar());
                    mime.setRealname(imUserPackets.getRealname());
                    mime.setElsAccount(imUserPackets.getElsAccount());
                    mime.setSubAccount(imUserPackets.getSubAccount());
                    wsResult.setData(mime);
                    ImPackets imPacket = ImPackets.fromText(wsResult);
                    imPacket.setData(wsResult);
                    ImSender.sendToUserChannelContext(dbMessage.getMessageFromId(), channelContext.getTioConfig(), imPacket);
                    ImUserPackets userDTO = this.srmBusinessHelper.loadLoginUserDtoId(channelContext.userid);
                    mime.setMessageContent("\u64a4\u56de\u4e86\u4e00\u6761\u6d88\u606f");
                    wsResult.setData(mime);
                    imPacket = ImPackets.fromText(wsResult);
                    ImSender.sendToUserChannelContext(dbMessage.getMessageToId(), channelContext.getTioConfig(), imPacket);
                    this.srmBusinessHelper.asyncUndoMessage(dbMessage.getId(), channelContext.userid);
                }
            } else {
                log.warn("UndoMessageHandler \u6d88\u606f\u64a4\u56de\u8d85\u8fc7\u5141\u8bb8\u64a4\u56de\u7684\u65f6\u95f4\uff0c\u5f53\u524d\u6d88\u606f\u5df2\u53d1\u9001:{}\u5206", (Object)(diff / 60000L));
                this.reject(wsResult, dbMessage, message, (Date)date, channelContext);
            }
        }
        return null;
    }

    private void reject(WsResultPackets wsResult, MessagePackets messageDto, WsMessageDataPackets message, Date date, ChannelContext channelContext) {
        wsResult.setMsgType(UNDO_MESSAGE_REPLY_REJECT);
        WsMessageDataPackets mime = new WsMessageDataPackets();
        mime.setMessageFromId(messageDto.getMessageFromId());
        mime.setId(messageDto.getId());
        mime.setMessageToId(messageDto.getMessageToId());
        mime.setMessageSendTime(date.getTime());
        mime.setUndoMessageId(message.getUndoMessageId());
        mime.setMessageContent("\u5f53\u524d\u6d88\u606f\u53d1\u51fa\u5df2\u8d85\u8fc72\u5206\u949f\uff0c\u65e0\u6cd5\u64a4\u56de");
        wsResult.setData(mime);
        ImPackets imPacket = ImPackets.fromText(wsResult);
        ImSender.sendToUserChannelContext(messageDto.getMessageFromId(), channelContext.getTioConfig(), imPacket);
    }

    @Override
    public Opt opt() {
        return Opt.UNDO_MESSAGE_CONN;
    }
}

