/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.survey.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.survey.entity.PurchaseSurveyAnswer;
import com.els.modules.survey.entity.PurchaseSurveyHead;
import com.els.modules.survey.entity.PurchaseSurveyItem;
import com.els.modules.survey.entity.PurchaseSurveyLibrary;
import com.els.modules.survey.enumerate.ServeyScopeEnum;
import com.els.modules.survey.excel.PurchaseSurveyHeadExportServiceImpl;
import com.els.modules.survey.service.PurchaseSurveyAnswerLibraryService;
import com.els.modules.survey.service.PurchaseSurveyAnswerService;
import com.els.modules.survey.service.PurchaseSurveyHeadService;
import com.els.modules.survey.service.PurchaseSurveyItemService;
import com.els.modules.survey.service.PurchaseSurveyLibraryService;
import com.els.modules.survey.vo.PurchaseSurveyHeadVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/survey/purchaseSurveyHead"})
@Tag(name="\u95ee\u5377\u8c03\u67e5\u5934")
public class PurchaseSurveyHeadController
extends BaseController<PurchaseSurveyHead, PurchaseSurveyHeadService> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PurchaseSurveyHeadController.class);
    @Autowired
    private PurchaseSurveyHeadService purchaseSurveyHeadService;
    @Autowired
    private PurchaseSurveyLibraryService purchaseSurveyLibraryService;
    @Autowired
    private PurchaseSurveyItemService purchaseSurveyItemService;
    @Autowired
    private PurchaseSurveyAnswerService purchaseSurveyAnswerService;
    @Autowired
    private PurchaseSurveyAnswerLibraryService purchaseSurveyAnswerLibraryService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="survey")
    @RequiresPermissions(value={"survey#purchaseSurveyHead:list"})
    public Result<?> queryPageList(PurchaseSurveyHead purchaseSurveyHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseSurveyHead), (Map)req.getParameterMap());
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        queryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)loginUser.getElsAccount());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseSurveyHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(busModule="\u95ee\u5377\u8c03\u67e5\u5934", value="\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"survey#purchaseSurveyHead:add"})
    @PermissionDataOpt(businessType="survey", beanClass=PurchaseSurveyHeadService.class)
    public Result<?> add(@RequestBody PurchaseSurveyHeadVO purchaseSurveyHeadPage) {
        PurchaseSurveyHead purchaseSurveyHead = new PurchaseSurveyHead();
        BeanUtils.copyProperties((Object)((Object)purchaseSurveyHeadPage), (Object)((Object)purchaseSurveyHead));
        this.purchaseSurveyHeadService.saveMain(purchaseSurveyHead, purchaseSurveyHeadPage.getPurchaseSurveyLibraryList(), purchaseSurveyHeadPage.getPurchaseSurveyItemList(), purchaseSurveyHeadPage.getPurchaseSurveyAnswerList());
        return Result.ok((Object)((Object)purchaseSurveyHead));
    }

    @SrmValidated
    @AutoLog(busModule="\u95ee\u5377\u8c03\u67e5\u5934", value="\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"survey#purchaseSurveyHead:edit"})
    @PermissionDataOpt(businessType="survey", beanClass=PurchaseSurveyHeadService.class)
    public Result<?> edit(@RequestBody PurchaseSurveyHeadVO purchaseSurveyHeadPage) {
        PurchaseSurveyHead purchaseSurveyHead = new PurchaseSurveyHead();
        BeanUtils.copyProperties((Object)((Object)purchaseSurveyHeadPage), (Object)((Object)purchaseSurveyHead));
        this.purchaseSurveyHeadService.updateMain(purchaseSurveyHead, purchaseSurveyHeadPage.getPurchaseSurveyLibraryList(), purchaseSurveyHeadPage.getPurchaseSurveyItemList(), purchaseSurveyHeadPage.getPurchaseSurveyAnswerList());
        String id = purchaseSurveyHead.getId();
        return this.queryById(id);
    }

    @SrmValidated
    @AutoLog(busModule="\u95ee\u5377\u8c03\u67e5\u5934", value="\u53d1\u5e03")
    @Operation(summary="\u53d1\u5e03", description="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"survey#purchaseSurveyHead:publish"})
    @PermissionDataOpt(businessType="survey", beanClass=PurchaseSurveyHeadService.class)
    public Result<?> publish(@RequestBody PurchaseSurveyHeadVO purchaseSurveyHeadPage) {
        String id = purchaseSurveyHeadPage.getId();
        PurchaseSurveyHead purchaseSurveyHead = (PurchaseSurveyHead)((Object)this.purchaseSurveyHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        List<PurchaseSurveyLibrary> purchaseSurveyLibraryList = this.purchaseSurveyLibraryService.selectByMainId(id);
        List<PurchaseSurveyItem> purchaseSurveyItemList = this.purchaseSurveyItemService.selectByMainId(id);
        List<PurchaseSurveyAnswer> purchaseSurveyAnswerList = this.purchaseSurveyAnswerService.selectByMainId(id);
        if (!ServeyScopeEnum.PUBLIC.getValue().equals(purchaseSurveyHead.getSurveyScope()) && CollectionUtils.isEmpty(purchaseSurveyAnswerList)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_uRvQUDmvLjQUDmIdxOLV_cb1c4d19", (String)"\u975e\u516c\u5f00\u95ee\u5377\u8c03\u67e5\u8303\u56f4\u7684\u95ee\u5377\u8c03\u67e5\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (CollectionUtils.isEmpty(purchaseSurveyLibraryList)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QUCcLV_96d2781d", (String)"\u95ee\u5377\u5185\u5bb9\u4e3a\u7a7a"));
        }
        this.purchaseSurveyHeadService.publish(purchaseSurveyHead, purchaseSurveyLibraryList, purchaseSurveyAnswerList);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u95ee\u5377\u8c03\u67e5\u5934", value="\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"survey#purchaseSurveyHead:delete"})
    @PermissionDataOpt(businessType="survey", beanClass=PurchaseSurveyHeadService.class)
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.purchaseSurveyHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u95ee\u5377\u8c03\u67e5\u5934", value="\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"survey#purchaseSurveyHead:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.purchaseSurveyHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u95ee\u5377\u8c03\u67e5\u5934", value="\u901a\u8fc7id\u67e5\u8be2")
    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/noToken/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchaseSurveyHead purchaseSurveyHead = (PurchaseSurveyHead)((Object)this.purchaseSurveyHeadService.getById((Serializable)((Object)id)));
        PurchaseSurveyHeadVO purchaseSurveyHeadVO = new PurchaseSurveyHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseSurveyHead), (Object)((Object)purchaseSurveyHeadVO));
        TenantContext.setTenant((String)purchaseSurveyHead.getElsAccount());
        List<PurchaseSurveyLibrary> purchaseSurveyLibraryList = this.purchaseSurveyLibraryService.selectByMainId(id);
        purchaseSurveyHeadVO.setPurchaseSurveyLibraryList(purchaseSurveyLibraryList);
        List<PurchaseSurveyItem> purchaseSurveyItemList = this.purchaseSurveyItemService.selectByMainId(id);
        purchaseSurveyHeadVO.setPurchaseSurveyItemList(purchaseSurveyItemList);
        List<PurchaseSurveyAnswer> purchaseSurveyAnswerList = this.purchaseSurveyAnswerService.selectByMainId(id);
        purchaseSurveyHeadVO.setPurchaseSurveyAnswerList(purchaseSurveyAnswerList);
        return Result.ok((Object)((Object)purchaseSurveyHeadVO));
    }

    @Operation(summary="\u901a\u8fc7\u95ee\u5377\u8c03\u67e5\u5934id\u67e5\u8be2\u8c03\u67e5\u95ee\u5377\u9898", description="\u901a\u8fc7\u95ee\u5377\u8c03\u67e5\u5934id\u67e5\u8be2\u8c03\u67e5\u95ee\u5377\u9898")
    @GetMapping(value={"/queryPurchaseSurveyLibraryByMainId"})
    @RequiresPermissions(value={"survey#purchaseSurveyHead:list"})
    public Result<?> queryPurchaseSurveyLibraryListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseSurveyLibrary> purchaseSurveyLibraryList = this.purchaseSurveyLibraryService.selectByMainId(id);
        return Result.ok(purchaseSurveyLibraryList);
    }

    @Operation(summary="\u901a\u8fc7\u95ee\u5377\u8c03\u67e5\u5934id\u67e5\u8be2\u95ee\u5377\u8c03\u67e5\u884c", description="\u901a\u8fc7\u95ee\u5377\u8c03\u67e5\u5934id\u67e5\u8be2\u95ee\u5377\u8c03\u67e5\u884c")
    @GetMapping(value={"/queryPurchaseSurveyItemByMainId"})
    @RequiresPermissions(value={"survey#purchaseSurveyHead:list"})
    public Result<?> queryPurchaseSurveyItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseSurveyItem> purchaseSurveyItemList = this.purchaseSurveyItemService.selectByMainId(id);
        return Result.ok(purchaseSurveyItemList);
    }

    @Operation(summary="\u901a\u8fc7\u95ee\u5377\u8c03\u67e5\u5934id\u67e5\u8be2\u95ee\u5377\u8c03\u67e5\u4eba", description="\u901a\u8fc7\u95ee\u5377\u8c03\u67e5\u5934id\u67e5\u8be2\u95ee\u5377\u8c03\u67e5\u4eba")
    @GetMapping(value={"/queryPurchaseSurveyAnswerByMainId"})
    @RequiresPermissions(value={"survey#purchaseSurveyHead:list"})
    public Result<?> queryPurchaseSurveyAnswerListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseSurveyAnswer> purchaseSurveyAnswerList = this.purchaseSurveyAnswerService.selectByMainId(id);
        return Result.ok(purchaseSurveyAnswerList);
    }

    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"survey#purchaseSurveyHead:export"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseSurveyHeadExportServiceImpl.class);
    }
}

