/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.custom.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.account.api.dto.PermissionDTO;
import com.els.modules.custom.entity.BusinessCustomConfig;
import com.els.modules.custom.mapper.BusinessCustomConfigMapper;
import com.els.modules.custom.rpc.service.CustomInvokeRpcService;
import com.els.modules.custom.service.BusinessCustomConfigService;
import com.els.modules.custom.utils.CustomCodeGeneJsUtil;
import com.els.modules.custom.vo.BusinessCustomConfigVO;
import com.els.modules.system.entity.ColumnDefine;
import com.els.modules.system.entity.Dict;
import com.els.modules.system.entity.DictItem;
import com.els.modules.system.service.ColumnDefineService;
import com.els.modules.system.service.DictItemService;
import com.els.modules.system.service.DictService;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BusinessCustomConfigServiceImpl
extends BaseServiceImpl<BusinessCustomConfigMapper, BusinessCustomConfig>
implements BusinessCustomConfigService {
    @Resource
    private CustomInvokeRpcService customInvokeRpcService;
    @Resource
    private DictService dictService;
    @Resource
    private DictItemService dictItemService;
    @Resource
    private ColumnDefineService columnDefineService;
    @Value(value="${els.path.upload}")
    private String uploadpath;

    @Override
    public void add(BusinessCustomConfig businessCustomConfig) {
        ((BusinessCustomConfigMapper)this.baseMapper).insert((Object)businessCustomConfig);
    }

    @Override
    public void edit(BusinessCustomConfig businessCustomConfig) {
        int count = ((BusinessCustomConfigMapper)this.baseMapper).updateById((Object)businessCustomConfig);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((BusinessCustomConfigMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void saveConfig(BusinessCustomConfig businessCustomConfig) {
        if (StrUtil.isBlank((CharSequence)businessCustomConfig.getId())) {
            ((BusinessCustomConfigMapper)this.baseMapper).insert((Object)businessCustomConfig);
        } else {
            ((BusinessCustomConfigMapper)this.baseMapper).updateById((Object)businessCustomConfig);
        }
    }

    @Override
    @Transactional
    public void publish(BusinessCustomConfigVO configVO) {
        String savePathDir = this.uploadpath + File.separator + "custom_js";
        if (StrUtil.isNotBlank((CharSequence)configVO.getConfigJson())) {
            List<PermissionDTO> permissionList = this.builderPermissin(configVO);
            this.customInvokeRpcService.createOrUpdate(configVO.getId(), permissionList);
            this.createStatusDict(configVO);
            this.createColumn(configVO);
            CustomCodeGeneJsUtil.generatorJs(savePathDir, configVO);
        }
        if (StrUtil.isNotBlank((CharSequence)configVO.getListConfigJson())) {
            CustomCodeGeneJsUtil.generatorListJs(savePathDir, configVO);
        }
        BusinessCustomConfig config = new BusinessCustomConfig();
        BeanUtils.copyProperties((Object)((Object)configVO), (Object)((Object)config));
        config.setConfigStatus("1");
        this.updateById((Object)config);
    }

    private void createColumn(BusinessCustomConfigVO configVO) {
        String purchaseColumnTableCode = "purchaseCustom_" + configVO.getId();
        String saleColumnTableCode = "saleCustom_" + configVO.getId();
        ArrayList<ColumnDefine> purcahseColumnDefineList = new ArrayList<ColumnDefine>();
        ArrayList<ColumnDefine> saleColumnDefineList = new ArrayList<ColumnDefine>();
        this.columnDefineService.deleteByMainId(purchaseColumnTableCode);
        this.columnDefineService.deleteByMainId(saleColumnTableCode);
        JSONObject configObj = JSONObject.parseObject((String)configVO.getConfigJson());
        JSONArray headArray = configObj.getJSONObject("pageConfigTemplate").getJSONArray("templateConfigHeadList");
        int index = 1;
        ArrayList<String> checkFieldNameList = new ArrayList<String>();
        for (Object obj : headArray) {
            JSONObject headObj = (JSONObject)obj;
            if (!"1".equals(headObj.getString("listDisplay")) || checkFieldNameList.contains(headObj.getString("fieldName"))) continue;
            checkFieldNameList.add(headObj.getString("fieldName"));
            ColumnDefine columnDefine = new ColumnDefine();
            columnDefine.setColumnCode(headObj.getString("fieldName"));
            columnDefine.setColumnName(headObj.getString("fieldLabel"));
            columnDefine.setDataFormat(headObj.getString("dataFormat"));
            columnDefine.setDictCode(headObj.getString("dictCode"));
            columnDefine.setColumnFilter(headObj.getString("dictCode"));
            columnDefine.setFieldType(headObj.getString("fieldType"));
            columnDefine.setOptions(headObj.getString("options"));
            columnDefine.setAlignType("center");
            columnDefine.setColumnWidth("120");
            columnDefine.setSortOrder(BigDecimal.valueOf(index));
            if ("1".equals(headObj.getString("purchaseShow"))) {
                ColumnDefine purcahseColumnDefine = new ColumnDefine();
                BeanUtils.copyProperties((Object)columnDefine, (Object)purcahseColumnDefine);
                purcahseColumnDefine.setTableCode(purchaseColumnTableCode);
                purcahseColumnDefineList.add(purcahseColumnDefine);
            }
            if ("1".equals(headObj.getString("saleShow"))) {
                ColumnDefine saleColumnDefine = new ColumnDefine();
                BeanUtils.copyProperties((Object)columnDefine, (Object)saleColumnDefine);
                saleColumnDefine.setTableCode(saleColumnTableCode);
                saleColumnDefineList.add(saleColumnDefine);
            }
            ++index;
        }
        this.autoSystemField(purchaseColumnTableCode, purcahseColumnDefineList);
        this.autoSystemField(saleColumnTableCode, saleColumnDefineList);
        purcahseColumnDefineList.addAll(saleColumnDefineList);
        this.columnDefineService.saveBatch(purcahseColumnDefineList);
    }

    private void autoSystemField(String tableCode, List<ColumnDefine> purcahseColumnDefineList) {
        ColumnDefine createByColumn = new ColumnDefine();
        createByColumn.setTableCode(tableCode);
        createByColumn.setColumnCode("createBy");
        createByColumn.setColumnName("\u521b\u5efa\u4eba");
        createByColumn.setColumnNameI18nKey("i18n_baseForm55ee_createBy");
        createByColumn.setAlignType("center");
        createByColumn.setColumnWidth("120");
        createByColumn.setSortOrder(BigDecimal.valueOf(purcahseColumnDefineList.size() + 1));
        purcahseColumnDefineList.add(createByColumn);
        ColumnDefine createTimeColumn = new ColumnDefine();
        createTimeColumn.setTableCode(tableCode);
        createTimeColumn.setColumnCode("createTime");
        createTimeColumn.setColumnName("\u521b\u5efa\u65f6\u95f4");
        createTimeColumn.setColumnNameI18nKey("i18n_baseForm9f12_createTime");
        createTimeColumn.setAlignType("center");
        createTimeColumn.setColumnWidth("140");
        createTimeColumn.setSortOrder(BigDecimal.valueOf(purcahseColumnDefineList.size() + 1));
        purcahseColumnDefineList.add(createTimeColumn);
        ColumnDefine updateByColumn = new ColumnDefine();
        updateByColumn.setTableCode(tableCode);
        updateByColumn.setColumnCode("updateBy");
        updateByColumn.setColumnName("\u66f4\u65b0\u4eba");
        updateByColumn.setColumnNameI18nKey("i18n_field_updateName");
        updateByColumn.setAlignType("center");
        updateByColumn.setColumnWidth("120");
        updateByColumn.setSortOrder(BigDecimal.valueOf(purcahseColumnDefineList.size() + 1));
        purcahseColumnDefineList.add(updateByColumn);
        ColumnDefine updateTimeColumn = new ColumnDefine();
        updateTimeColumn.setTableCode(tableCode);
        updateTimeColumn.setColumnCode("updateTime");
        updateTimeColumn.setColumnName("\u66f4\u65b0\u65f6\u95f4");
        updateTimeColumn.setColumnNameI18nKey("i18n_field_updateTimes");
        updateTimeColumn.setAlignType("center");
        updateTimeColumn.setColumnWidth("140");
        updateTimeColumn.setSortOrder(BigDecimal.valueOf(purcahseColumnDefineList.size() + 1));
        purcahseColumnDefineList.add(updateTimeColumn);
    }

    private void createStatusDict(BusinessCustomConfigVO configVO) {
        String dictCode = "customStatus_" + configVO.getId();
        Dict dictDb = (Dict)this.dictService.getOne((Wrapper)new QueryWrapper().eq((Object)"dict_code", (Object)dictCode));
        if (dictDb == null) {
            dictDb = new Dict();
            dictDb.setDictName("\u5355\u636e\u72b6\u6001");
            dictDb.setId(IdWorker.getIdStr());
            dictDb.setDictCode(dictCode);
            this.dictService.save(dictDb);
        } else {
            this.dictItemService.deleteByMainId(dictDb.getId());
        }
        JSONObject configObj = JSONObject.parseObject((String)configVO.getConfigJson());
        JSONArray itemArray = configObj.getJSONArray("businessStatusList");
        ArrayList<DictItem> dictItemList = new ArrayList<DictItem>();
        if (itemArray != null) {
            int index = 1;
            for (Object obj : itemArray) {
                JSONObject itemObj = (JSONObject)obj;
                DictItem dictItem = new DictItem();
                dictItem.setDictId(dictDb.getId());
                dictItem.setItemText(itemObj.getString("text"));
                dictItem.setItemValue(itemObj.getString("value"));
                dictItem.setSortOrder(index);
                ++index;
                dictItemList.add(dictItem);
            }
            this.dictItemService.saveBatch(dictItemList);
        }
    }

    private List<PermissionDTO> builderPermissin(BusinessCustomConfigVO configVO) {
        PermissionDTO listPermission;
        JSONObject listButton;
        double index;
        PermissionDTO permissionDetail;
        PermissionDTO permissionEdit;
        PermissionDTO permission;
        JSONObject detailJsonObj;
        JSONObject listJsonObj;
        JSONArray listButtonArray = null;
        JSONArray detailButtonArray = null;
        String configJsonStr = configVO.getListConfigJson();
        if (StrUtil.isNotBlank((CharSequence)configJsonStr) && (listJsonObj = JSONObject.parseObject((String)configJsonStr)).containsKey((Object)"listPageConfigTemplate")) {
            listButtonArray = listJsonObj.getJSONObject("listPageConfigTemplate").getJSONArray("buttonsConfig");
        }
        if ((detailJsonObj = JSONObject.parseObject((String)configVO.getConfigJson())).containsKey((Object)"pageConfigTemplate")) {
            detailButtonArray = detailJsonObj.getJSONObject("pageConfigTemplate").getJSONArray("templatePageButtons");
        }
        ArrayList<PermissionDTO> permissionList = new ArrayList<PermissionDTO>();
        if (StrUtil.isNotBlank((CharSequence)configVO.getPurchaseMenuName())) {
            permission = new PermissionDTO();
            permission.setId(configVO.getId() + "_purchase_list");
            permission.setParentId(configVO.getPurchaseMenuParentId());
            permission.setName(configVO.getPurchaseMenuName());
            permission.setUrl("/customApp/purchase/" + configVO.getId() + "/list?id=" + configVO.getId() + "&menuType=purchase&version=" + configVO.getTemplateVersion());
            permission.setComponent("designer/preview/purchase/list");
            permission.setMenuType(Integer.valueOf(1));
            permission.setPerms("custom#purchaseCustomFormHead:list");
            permission.setPermsType("1");
            permission.setSortNo(Double.valueOf(1.0));
            permission.setMenuAttribute("1");
            permission.setCustomBusinessId(configVO.getId());
            permissionList.add(permission);
            permissionEdit = new PermissionDTO();
            permissionEdit.setId(configVO.getId() + "_purchase_edit");
            permissionEdit.setParentId(permission.getId());
            permissionEdit.setName(configVO.getBusinessName() + "\u7f16\u8f91");
            permissionEdit.setUrl("/customApp/purchase/" + configVO.getId() + "/edit");
            permissionEdit.setComponent("designer/preview/purchase/business/edit");
            permissionEdit.setMenuType(Integer.valueOf(1));
            permissionEdit.setPerms("custom#purchaseCustomFormHead:view");
            permissionEdit.setPermsType("1");
            permissionEdit.setHidden(true);
            permissionEdit.setSortNo(Double.valueOf(2.0));
            permissionEdit.setMenuAttribute("1");
            permissionEdit.setCustomBusinessId(configVO.getId());
            permissionList.add(permissionEdit);
            permissionDetail = new PermissionDTO();
            permissionDetail.setId(configVO.getId() + "_purchase_detail");
            permissionDetail.setParentId(permission.getId());
            permissionDetail.setName(configVO.getBusinessName() + "\u660e\u7ec6");
            permissionDetail.setUrl("/customApp/purchase/" + configVO.getId() + "/detail");
            permissionDetail.setComponent("designer/preview/purchase/business/detail");
            permissionDetail.setMenuType(Integer.valueOf(1));
            permissionDetail.setPerms("custom#purchaseCustomFormHead:view");
            permissionDetail.setPermsType("1");
            permissionDetail.setHidden(true);
            permissionDetail.setSortNo(Double.valueOf(3.0));
            permissionDetail.setMenuAttribute("1");
            permissionDetail.setCustomBusinessId(configVO.getId());
            permissionList.add(permissionDetail);
            index = 4.0;
            if (listButtonArray != null) {
                for (Object obj : listButtonArray) {
                    listButton = (JSONObject)obj;
                    if (!"1".equals(listButton.getString("purchaseShow"))) continue;
                    listPermission = new PermissionDTO();
                    listPermission.setId(configVO.getId() + "_1_" + listButton.getString("purchaseAuthorityCode"));
                    listPermission.setParentId(permission.getId());
                    listPermission.setName(listButton.getString("label"));
                    listPermission.setMenuType(Integer.valueOf(2));
                    listPermission.setPerms(listButton.getString("purchaseAuthorityCode"));
                    listPermission.setPermsType("1");
                    listPermission.setHidden(false);
                    listPermission.setSortNo(Double.valueOf(index));
                    listPermission.setMenuAttribute("1");
                    listPermission.setCustomBusinessId(configVO.getId());
                    permissionList.add(listPermission);
                    index += 1.0;
                }
            }
            if (detailButtonArray != null) {
                for (Object obj : detailButtonArray) {
                    listButton = (JSONObject)obj;
                    if (!"1".equals(listButton.getString("purchaseShow"))) continue;
                    listPermission = new PermissionDTO();
                    listPermission.setId(configVO.getId() + "_1_" + listButton.getString("purchaseAuthorityCode"));
                    listPermission.setParentId(permission.getId());
                    listPermission.setName(listButton.getString("label"));
                    listPermission.setMenuType(Integer.valueOf(2));
                    listPermission.setPerms(listButton.getString("purchaseAuthorityCode"));
                    listPermission.setPermsType("1");
                    listPermission.setHidden(false);
                    listPermission.setSortNo(Double.valueOf(index));
                    listPermission.setMenuAttribute("1");
                    listPermission.setCustomBusinessId(configVO.getId());
                    permissionList.add(listPermission);
                    index += 1.0;
                }
            }
        }
        if (StrUtil.isNotBlank((CharSequence)configVO.getSaleMenuName())) {
            permission = new PermissionDTO();
            permission.setId(configVO.getId() + "_sale_list");
            permission.setParentId(configVO.getSaleMenuParentId());
            permission.setName(configVO.getSaleMenuName());
            permission.setUrl("/customApp/sale/" + configVO.getId() + "/list?id=" + configVO.getId() + "&menuType=sale&version=" + configVO.getTemplateVersion());
            permission.setComponent("designer/preview/sale/list");
            permission.setMenuType(Integer.valueOf(1));
            permission.setPerms("custom#saleCustomFormHead:list");
            permission.setPermsType("1");
            permission.setSortNo(Double.valueOf(1.0));
            permission.setMenuAttribute("2");
            permission.setCustomBusinessId(configVO.getId());
            permissionList.add(permission);
            permissionEdit = new PermissionDTO();
            permissionEdit.setId(configVO.getId() + "_sale_edit");
            permissionEdit.setParentId(permission.getId());
            permissionEdit.setName(configVO.getBusinessName() + "\u7f16\u8f91");
            permissionEdit.setUrl("/customApp/sale/" + configVO.getId() + "/edit");
            permissionEdit.setComponent("designer/preview/sale/business/edit");
            permissionEdit.setMenuType(Integer.valueOf(1));
            permissionEdit.setPerms("custom#saleCustomFormHead:view");
            permissionEdit.setPermsType("1");
            permissionEdit.setHidden(true);
            permissionEdit.setSortNo(Double.valueOf(2.0));
            permissionEdit.setMenuAttribute("2");
            permissionEdit.setCustomBusinessId(configVO.getId());
            permissionList.add(permissionEdit);
            permissionDetail = new PermissionDTO();
            permissionDetail.setId(configVO.getId() + "_sale_detail");
            permissionDetail.setParentId(permission.getId());
            permissionDetail.setName(configVO.getBusinessName() + "\u660e\u7ec6");
            permissionDetail.setUrl("/customApp/sale/" + configVO.getId() + "/detail");
            permissionDetail.setComponent("designer/preview/sale/business/detail");
            permissionDetail.setMenuType(Integer.valueOf(1));
            permissionDetail.setPerms("custom#saleCustomFormHead:view");
            permissionDetail.setPermsType("1");
            permissionDetail.setHidden(true);
            permissionDetail.setSortNo(Double.valueOf(3.0));
            permissionDetail.setMenuAttribute("2");
            permissionDetail.setCustomBusinessId(configVO.getId());
            permissionList.add(permissionDetail);
            index = 4.0;
            if (listButtonArray != null) {
                for (Object obj : listButtonArray) {
                    listButton = (JSONObject)obj;
                    if (!"1".equals(listButton.getString("saleShow"))) continue;
                    listPermission = new PermissionDTO();
                    listPermission.setId(configVO.getId() + "_2_" + listButton.getString("saleAuthorityCode"));
                    listPermission.setParentId(permission.getId());
                    listPermission.setName(listButton.getString("label"));
                    listPermission.setMenuType(Integer.valueOf(2));
                    listPermission.setPerms(listButton.getString("saleAuthorityCode"));
                    listPermission.setPermsType("1");
                    listPermission.setHidden(false);
                    listPermission.setSortNo(Double.valueOf(index));
                    listPermission.setMenuAttribute("2");
                    listPermission.setCustomBusinessId(configVO.getId());
                    permissionList.add(listPermission);
                    index += 1.0;
                }
            }
            if (detailButtonArray != null) {
                for (Object obj : detailButtonArray) {
                    listButton = (JSONObject)obj;
                    if (!"1".equals(listButton.getString("saleShow"))) continue;
                    listPermission = new PermissionDTO();
                    listPermission.setId(configVO.getId() + "_2_" + listButton.getString("saleAuthorityCode"));
                    listPermission.setParentId(permission.getId());
                    listPermission.setName(listButton.getString("label"));
                    listPermission.setMenuType(Integer.valueOf(2));
                    listPermission.setPerms(listButton.getString("saleAuthorityCode"));
                    listPermission.setPermsType("1");
                    listPermission.setHidden(false);
                    listPermission.setSortNo(Double.valueOf(index));
                    listPermission.setMenuAttribute("2");
                    listPermission.setCustomBusinessId(configVO.getId());
                    permissionList.add(listPermission);
                    index += 1.0;
                }
            }
        }
        return permissionList;
    }
}

