function getPageConfig ( Vue ) {
return {
tempRole: 'sale',
belong: 'business',
pageButtons:[
<#list data.templatePageButtons as group>
    <#if (group.saleShow)! =='1'>   
        {
        label: '${group.label!}',
        bindKey: '${group.bindKey!}',
        <#if (group.formStatus)! !=''>
            formStatus: '${group.formStatus!}',
        </#if>
        <#if (group.submitType)! !=''>
            submitType: '${group.submitType!}',
        </#if>
        <#if (group.saleAuthorityCode)! !=''>
            authorityCode: '${group.saleAuthorityCode!}',
        </#if>
        <#if group.saleActiveStatus??>
            saleActiveStatus: [
                <#list group.saleActiveStatus as key>
                     '${key}'<#if key_has_next>,</#if>
                </#list>
            ],
        </#if>
        <#if (group.position)! !=''>
            position: '${group.position!}',
        </#if>
        <#if (group.groupCode)! !=''>
            groupCode: '${group.groupCode!}',
        </#if>
        <#if group.attrs?? >
            attrs: {
            <#list group.attrs?keys as key>
                ${key}: '${group.attrs[key]}'<#if key_has_next>,</#if>
            </#list>
        }
        </#if>
        <#if (group.extend)! !=''>
            extend: ${group.extend!}
        </#if>
        }<#if group_has_next>,</#if>
     </#if>
</#list>
],
groups: [
<#list data.templateGroupList as group>
    {
    groupName: '${group.groupName!}',
    groupNameI18nKey: '${group.groupNameI18nKey!}',
    groupCode: '${group.groupCode!}',
    groupType: '${group.groupType!}',
    sortOrder: '${group.sortOrder!}',
    <#if (group.extend)! !=''>
        extend: ${group.extend!},
    </#if>
    <#if group.buttons?? && (group.buttons?size > 0) >
        buttons: [
            <#list group.buttons as button>
                    <#if (button.saleShow)! =='1'>
                    {
                            label: '${button.label!}',
                            bindKey: '${button.bindKey!}',
                            <#if (button.formStatus)! !=''>
                                formStatus: '${button.formStatus!}',
                            </#if>
                            <#if (button.submitType)! !=''>
                                submitType: '${button.submitType!}',
                            </#if>
                            <#if (button.saleAuthorityCode)! !=''>
                                authorityCode: '${button.saleAuthorityCode!}',
                            </#if>
                            <#if button.saleActiveStatus??>
                                saleActiveStatus: [
                                    <#list button.saleActiveStatus as key>
                                        '${key}'<#if key_has_next>,</#if>
                                    </#list>
                                ],
                            </#if>
                            <#if (button.position)! !=''>
                                position: '${button.position!}',
                            </#if>
                            <#if (button.groupCode)! !=''>
                                groupCode: '${button.groupCode!}',
                            </#if>
                            <#if button.attrs?? >
                                attrs: {
                                <#list button.attrs?keys as key>
                                    ${key}: '${button.attrs[key]}'<#if key_has_next>,</#if>
                                </#list>
                            }
                            </#if>
                            <#if (button.extend)! !=''>
                                extend: ${button.extend!}
                            </#if>
                    }<#if button_has_next>,</#if>
                </#if>
            </#list>
         ]
    </#if>
    }<#if group_has_next>,</#if>
</#list>
],
formFields: [
<#list data.templateConfigHeadList as head>
    <#if (head.saleShow)! =='1'>
        {
        groupCode: '${head.groupCode!}',
        sortOrder: '${head.sortOrder!}',
        fieldType: '${head.fieldType!}',
        fieldLabel: '${head.fieldLabel!}',
        fieldLabelI18nKey: '${head.fieldLabelI18nKey!}',
        fieldName: '${head.fieldName!}',
        dictCode: '${head.dictCode!}',
        defaultValue: '${head.defaultValue!}',
        dataFormat: '${head.dataFormat!}',
        helpText: '${head.helpText!}',
        <#if (head.regex)! != ''>
            regex: ${head.regex!},
        </#if>
        alertMsg: '${head.alertMsg!}',
        <#if (head.saleEdit)! !='1'>
            disabled: true,
        <#else>
            disabled: false,
        </#if>
        <#if (head.showed)! =='0'>
            show: false,
        <#else>
            show: true,
        </#if>
        required:'${head.required!}',
        <#if (head.fieldValidator)! !=''>
            fieldValidator: ${head.fieldValidator!},
        </#if>
        <#if (head.mobile)! != ''>
            mobile: ${head.mobile!},
        </#if>
        <#if (head.initFunction)! !=''>
            initFunction: ${head.initFunction},
        </#if>
        <#if (head.callback)! !=''>
            callback: ${head.callback},
        </#if>
        <#if (head.bindFunction)! !=''>
            bindFunction: ${head.bindFunction},
        </#if>
        <#if (head.extend)! !=''>
            extend: ${head.extend!},
        </#if>
        <#if head.options?? >
            options: [
                <#list head.options as option>
                	{
                      label: '${option.label}',
                      value: '${option.value}',
                     }<#if option_has_next>,</#if>
                </#list>
            ],
        </#if>
        placeholder: '${head.placeholder!}'
        }<#if head_has_next>,</#if>
    </#if>
</#list>
],
itemColumns: [
<#list data.templateConfigItemList as item>
    <#if (item.saleShow)! =='1'>
        {
        groupCode: '${item.groupCode!}',
        title: '${item.title!}',
        fieldLabelI18nKey: '${item.fieldLabelI18nKey!}',
        fieldType: '${item.fieldType!}',
        field: '${item.field!}',
        align: '${item.align!'center'}',
        headerAlign: 'center',
        dataFormat: '${item.dataFormat!}',
        defaultValue: '${item.defaultValue!}',
        <#if (item.columnWidth)! == ''>
            width: 150,
        <#else>
            width: '${item.columnWidth!'150'}',
        </#if>
        dictCode: '${item.dictCode!}',
        <#if (item.fixType)! != ''>
            fixType: '${item.fixType}',
        </#if>
        <#if (item.fold)! != ''>
            fold: '${item.fold}',
        </#if>
        <#if (item.formula)! != ''>
            formula: '${item.formula}',
        </#if>
        <#if (item.sum)! != ''>
            sum: '${item.sum}',
        </#if>
        <#if (item.compute)! != ''>
            computed: '${item.compute}',
        </#if>
        <#if (item.fieldValidator)! !=''>
            fieldValidator: ${item.fieldValidator!},
        </#if>
        <#if (item.saleEdit)! !='1'>
            disabled: true,
        <#else>
            disabled: false,
        </#if>
        <#if (item.showed)! =='0'>
            show: false,
        <#else>
            show: true,
        </#if>
        <#if (item.regex)! != ''>
            regex: ${item.regex!},
        </#if>
        alertMsg: '${item.alertMsg!}',
        <#if (item.initFunction)! !=''>
            initFunction:${item.initFunction},
        </#if>
        <#if (item.callback)! !=''>
            callback: ${item.callback},
        </#if>
        <#if (item.bindFunction)! !=''>
            bindFunction:${item.bindFunction},
        </#if>
        <#if (item.extend)! !=''>
            extend: ${item.extend!},
        </#if>
        <#if (item.saleEdit)! !='1' && (item.fieldType)! =='currency'>
            slots: {default: 'renderCurrency'},
        </#if>
        required:'${item.required!}',
        <#if (item.mobile)! != ''>
            mobile: ${item.mobile!},
        </#if>
        <#if item.options?? >
            options: [
                <#list item.options as option>
                	{
                      label: '${option.label}',
                      value: '${option.value}',
                     }<#if option_has_next>,</#if>
                </#list>
            ],
        </#if>
        helpText: '${item.helpText!}'
        }<#if item_has_next>,</#if>
    </#if>
</#list>
]
}
}