/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.enumerate;

import com.els.common.util.AssertI18nUtil;
import com.els.modules.barcode.encryption.AES;
import com.els.modules.barcode.encryption.DES;
import com.els.modules.barcode.encryption.NoEncryption;
import com.els.modules.barcode.encryption.ThreeDES;
import com.els.modules.barcode.encryption.base.IEncryption;
import com.els.modules.barcode.enumerate.EncryptionTypeEnum;
import com.els.modules.barcode.enumerate.I18nBarCodeEnum;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EncryptionEnum {
    NO_ENCRYPTION(EncryptionTypeEnum.NO, new NoEncryption()),
    DES(EncryptionTypeEnum.DES, new DES()),
    THREE_DES(EncryptionTypeEnum.THREE_DES, new ThreeDES()),
    AES(EncryptionTypeEnum.AES, new AES());

    private final EncryptionTypeEnum typeEnum;
    private final IEncryption encryption;
    private static final Map<EncryptionTypeEnum, IEncryption> enumMap;

    public EncryptionTypeEnum typeEnum() {
        return this.typeEnum;
    }

    public IEncryption encryption() {
        return this.encryption;
    }

    private EncryptionEnum(EncryptionTypeEnum typeEnum, IEncryption encryption) {
        this.typeEnum = typeEnum;
        this.encryption = encryption;
    }

    public static IEncryption of(String encryptionType) {
        return EncryptionEnum.of(EncryptionTypeEnum.of(encryptionType));
    }

    public static IEncryption of(EncryptionTypeEnum typeEnum) {
        IEncryption encryption = enumMap.get((Object)typeEnum);
        AssertI18nUtil.isTrue((encryption == null ? 1 : 0) != 0, (Enum)I18nBarCodeEnum.ENCRYPTION_TYPE_NOT_FOUND);
        return encryption;
    }

    static {
        enumMap = Stream.of(EncryptionEnum.values()).collect(Collectors.toMap(EncryptionEnum::typeEnum, EncryptionEnum::encryption));
    }
}

