/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.CodeGenerator;
import com.els.modules.system.entity.CodeGeneratorDetail;
import com.els.modules.system.entity.CodeGeneratorSerial;
import com.els.modules.system.enums.ValueTypeEnum;
import com.els.modules.system.mapper.CodeGeneratorDetailMapper;
import com.els.modules.system.mapper.CodeGeneratorMapper;
import com.els.modules.system.mapper.CodeGeneratorSerialMapper;
import com.els.modules.system.service.CodeGeneratorService;
import com.els.modules.system.service.DictService;
import com.els.modules.system.vo.CodeGeneratorVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class CodeGeneratorServiceImpl
extends ServiceImpl<CodeGeneratorMapper, CodeGenerator>
implements CodeGeneratorService {
    private static final String CODE_GENERATOR_VO_KEY = "srm:base:codeGenerator:vo:";
    private static final String CODE_GENERATOR_SERIAL_KEY = "srm:base:codeGenerator:serialKey:";
    private static final String CODE_GENERATOR_SERIAL_LOCK_KEY = "srm:base:codeGenerator:serialKey:lock:";
    @Resource
    private CodeGeneratorMapper codeGeneratorMapper;
    @Resource
    private CodeGeneratorDetailMapper codeGeneratorDetailMapper;
    @Resource
    private CodeGeneratorSerialMapper codeGeneratorSerialMapper;
    @Autowired
    private DictService dictService;
    @Autowired
    private RedisUtil redisUtil;
    @Resource(name="srmPoolExecutor")
    public ThreadPoolExecutor srmPoolExecutor;
    private final Long LOCK_TIME_OUT = 3000L;
    private final Long LOCK_WAIT_TIME = 3000L;
    private final String SERIAL_PLACE_HOLDER = "{serialNo}";

    private String getSerialKeyRedisKeyByCode(String elsAccount, String generatorCode, String serialKey) {
        StringBuilder builder = new StringBuilder(CODE_GENERATOR_SERIAL_KEY);
        builder.append(elsAccount).append(":").append(generatorCode).append(":").append(serialKey);
        return builder.toString();
    }

    private String getSerialKeyLockRedisKeyByCode(String elsAccount, String generatorCode, String serialKey) {
        StringBuilder builder = new StringBuilder(CODE_GENERATOR_SERIAL_LOCK_KEY);
        builder.append(elsAccount).append(":").append(generatorCode).append(":").append(serialKey);
        return builder.toString();
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(CodeGenerator codeGenerator, List<CodeGeneratorDetail> codeGeneratorDetailList) {
        this.insertOrUpdateData(codeGenerator, codeGeneratorDetailList, true);
    }

    private void insertOrUpdateData(CodeGenerator codeGenerator, List<CodeGeneratorDetail> codeGeneratorDetailList, boolean isInsert) {
        String elsAccount = TenantContext.getTenant();
        int codeLength = 0;
        int serialLength = 0;
        boolean serialKey = false;
        for (CodeGeneratorDetail detail : codeGeneratorDetailList) {
            codeLength += detail.getValueLength().intValue();
            this.validate(detail);
            if (ValueTypeEnum.SERIAL.getCode().equals(detail.getValueType())) {
                if (serialLength == 0) {
                    serialLength = detail.getValueLength();
                } else {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_AosROsxeOIVQfyW_a0111cd6", (String)"\u7f16\u7801\u4e2d\u53ea\u80fd\u5305\u542b\u6700\u591a\u4e00\u7ec4\u6d41\u6c34\u53f7\uff01"));
                }
            }
            if (CommonConstant.YES_1 != detail.getSerialKey()) continue;
            serialKey = true;
        }
        if (serialLength > 0 && !serialKey) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5b58\u5728\u6d41\u6c34\u53f7\u65f6\uff0c\u5e94\u8be5\u81f3\u5c11\u6709\u4e00\u884c\u662f\u6d41\u6c34\u53f7Key"));
        }
        codeGenerator.setElsAccount(elsAccount);
        codeGenerator.setCodeLength(codeLength);
        codeGenerator.setSerialLength(serialLength);
        if (CommonConstant.STATUS_YES.equals(codeGenerator.getDefaultGenerator())) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(CodeGenerator::getCodeType, (Object)codeGenerator.getCodeType())).eq(BaseEntity::getElsAccount, (Object)elsAccount)).set(CodeGenerator::getDefaultGenerator, (Object)CommonConstant.STATUS_NO);
            this.update((Wrapper)wrapper);
        }
        if (isInsert) {
            this.codeGeneratorMapper.insert((Object)codeGenerator);
        } else {
            this.codeGeneratorMapper.updateById((Object)codeGenerator);
        }
        for (int i = 0; i < codeGeneratorDetailList.size(); ++i) {
            CodeGeneratorDetail entity = codeGeneratorDetailList.get(i);
            entity.setGeneratorId(codeGenerator.getId());
            entity.setSeq(i + 1);
            entity.setElsAccount(elsAccount);
            this.codeGeneratorDetailMapper.insert((Object)entity);
        }
    }

    private void validate(CodeGeneratorDetail detail) {
        if (ValueTypeEnum.FIXED.getCode().equals(detail.getValueType())) {
            Assert.hasText((String)detail.getValue(), (String)I18nUtil.translate((String)"i18n_alert_AcLCIRKRCcxOLV_96b879bc", (String)"\u7c7b\u578b\u4e3a\u56fa\u5b9a\u503c\u65f6\u503c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a"));
        } else if (ValueTypeEnum.VAR.getCode().equals(detail.getValueType())) {
            Assert.hasText((String)detail.getVariableName(), (String)I18nUtil.translate((String)"i18n_alert_AcLARRKARRxOLV_6aa1596b", (String)"\u7c7b\u578b\u4e3a\u53d8\u91cf\u503c\u65f6\u53d8\u91cf\u540d\u4e0d\u80fd\u4e3a\u7a7a"));
        } else if (ValueTypeEnum.EL.getCode().equals(detail.getValueType())) {
            Assert.hasText((String)detail.getValue(), (String)I18nUtil.translate((String)"i18n_alert_AcLBfKKRCcxOLV_8efbf9d9", (String)"\u7c7b\u578b\u4e3a\u8868\u8fbe\u5f0f\u65f6\u503c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a"));
            try {
                DateUtil.format((Date)DateUtil.date(), (String)detail.getValue());
            }
            catch (Exception e) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_BfKxRu_da8aae66", (String)"\u8868\u8fbe\u5f0f\u4e0d\u652f\u6301"));
            }
        } else if (ValueTypeEnum.ENUM.getCode().equals(detail.getValueType())) {
            Assert.hasText((String)detail.getValue(), (String)I18nUtil.translate((String)"i18n_alert_AcLBFRKRCcxOLV_6bb10838", (String)"\u7c7b\u578b\u4e3a\u679a\u4e3e\u503c\u65f6\u503c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (detail.getSubstringBegin() != null && detail.getSubstringBegin() >= detail.getValueLength()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_yMvKLRxOBRRHz_7b830bd9", (String)"\u622a\u53d6\u5f00\u59cb\u4f4d\u7f6e\u4e0d\u80fd\u8d85\u8fc7\u503c\u957f\u5ea6"));
        }
        if (detail.getSubstringEnd() != null && detail.getSubstringEnd() >= detail.getValueLength()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_yMyWLRxOBRRHz_dadbb8d8", (String)"\u622a\u53d6\u7ed3\u675f\u4f4d\u7f6e\u4e0d\u80fd\u8d85\u8fc7\u503c\u957f\u5ea6"));
        }
        if (detail.getSubstringBegin() != null && detail.getSubstringEnd() != null && detail.getSubstringEnd() - detail.getSubstringBegin() != detail.getValueLength() && !ObjectUtil.equals((Object)detail.getSubstringBegin(), (Object)detail.getSubstringEnd())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_yMHzURHzxzE_c7abae19", (String)"\u622a\u53d6\u957f\u5ea6\u4e0e\u503c\u957f\u5ea6\u4e0d\u5339\u914d"));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(CodeGenerator codeGenerator, List<CodeGeneratorDetail> codeGeneratorDetailList) {
        this.codeGeneratorDetailMapper.deleteByMainId(codeGenerator.getId());
        this.insertOrUpdateData(codeGenerator, codeGeneratorDetailList, false);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.codeGeneratorDetailMapper.deleteByMainId(id);
        this.codeGeneratorSerialMapper.deleteByMainId(id);
        this.codeGeneratorMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(Collection<? extends Serializable> idList) {
        for (Serializable serializable : idList) {
            this.codeGeneratorDetailMapper.deleteByMainId(serializable.toString());
            this.codeGeneratorSerialMapper.deleteByMainId(serializable.toString());
            this.codeGeneratorMapper.deleteById(serializable);
        }
    }

    @Override
    public List<String> getNextCodes(String codeType, Object businessObj, int size) {
        CodeGeneratorVO codeGenerator = this.getCodeGenerator(TenantContext.getTenant(), codeType);
        List<CodeGeneratorDetail> detailList = codeGenerator.getCodeGeneratorDetailList();
        StringBuilder serialKey = new StringBuilder();
        ArrayList<String> codeList = new ArrayList<String>(16);
        int serialLength = 0;
        for (CodeGeneratorDetail detail : detailList) {
            if (!ValueTypeEnum.SERIAL.getCode().equals(detail.getValueType())) {
                String val = this.getValue(detail, businessObj);
                codeList.add(val);
                if (!CommonConstant.STATUS_YES.equals(detail.getSerialKey())) continue;
                serialKey.append(val);
                continue;
            }
            serialLength = detail.getValueLength();
            codeList.add("{serialNo}");
        }
        List<String> serialNo = null;
        if (serialLength > 0) {
            serialNo = this.getSerialBatchNo(codeGenerator, serialKey.toString(), size);
        }
        ArrayList<String> codes = new ArrayList<String>();
        StringBuilder code = new StringBuilder();
        while (size > 0) {
            for (String str : codeList) {
                if ("{serialNo}".equals(str)) {
                    code.append(null == serialNo ? "" : serialNo.get(size - 1));
                    continue;
                }
                code.append(str);
            }
            codes.add(code.toString());
            code.delete(0, code.length());
            --size;
        }
        return codes;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void addToEnterprise(String id) {
        CodeGenerator codeGenerator = (CodeGenerator)((Object)this.getById((Serializable)((Object)id)));
        List<CodeGeneratorDetail> codeGeneratorDetailList = this.codeGeneratorDetailMapper.selectByMainId(id);
        List<CodeGeneratorSerial> codeGeneratorSerialList = this.codeGeneratorSerialMapper.selectByMainId(id);
        String subAccount = SysUtil.getLoginUser().getSubAccount();
        String elsAccount = TenantContext.getTenant();
        String codeType = codeGenerator.getCodeType();
        String codeSample = codeGenerator.getCodeSample();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"code_type", (Object)codeType);
        queryWrapper.eq((Object)"code_sample", (Object)codeSample);
        List elsCodeGenerator = this.codeGeneratorMapper.selectList((Wrapper)queryWrapper);
        if (elsCodeGenerator != null && elsCodeGenerator.size() > 0) {
            this.delMain(((CodeGenerator)((Object)elsCodeGenerator.get(0))).getId());
        }
        codeGenerator.setId(null);
        codeGenerator.setElsAccount(elsAccount);
        codeGenerator.setCreateBy(subAccount);
        codeGenerator.setUpdateBy(subAccount);
        codeGenerator.setCreateTime(new Date());
        codeGenerator.setUpdateTime(new Date());
        this.codeGeneratorMapper.insert((Object)codeGenerator);
        for (CodeGeneratorDetail detail : codeGeneratorDetailList) {
            detail.setId(null);
            detail.setGeneratorId(codeGenerator.getId());
            detail.setElsAccount(elsAccount);
            detail.setCreateBy(subAccount);
            detail.setCreateBy(subAccount);
            detail.setUpdateBy(subAccount);
            detail.setCreateTime(new Date());
            detail.setUpdateTime(new Date());
        }
        for (CodeGeneratorSerial serial : codeGeneratorSerialList) {
            serial.setId(null);
            serial.setGeneratorId(codeGenerator.getId());
            serial.setElsAccount(elsAccount);
            serial.setCreateBy(subAccount);
            serial.setCreateBy(subAccount);
            serial.setUpdateBy(subAccount);
            serial.setCreateTime(new Date());
            serial.setUpdateTime(new Date());
        }
        if (!codeGeneratorDetailList.isEmpty()) {
            this.codeGeneratorDetailMapper.insertBatchSomeColumn(codeGeneratorDetailList);
        }
        if (!codeGeneratorSerialList.isEmpty()) {
            this.codeGeneratorSerialMapper.insertBatchSomeColumn(codeGeneratorSerialList);
        }
    }

    private String getRedisKeyByCode(String elsAccount, String generatorCode) {
        StringBuilder builder = new StringBuilder(CODE_GENERATOR_VO_KEY);
        builder.append(elsAccount).append(":").append(generatorCode);
        return builder.toString();
    }

    private CodeGeneratorVO getCodeGenerator(String elsAccount, String generatorCode) {
        String redisKey = this.getRedisKeyByCode(elsAccount, generatorCode);
        CodeGeneratorVO generatorVO = (CodeGeneratorVO)((Object)this.redisUtil.get(redisKey));
        if (generatorVO != null) {
            return generatorVO;
        }
        CodeGenerator codeGenerator = (CodeGenerator)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(CodeGenerator::getGeneratorCode, (Object)generatorCode)).last(" limit 1")));
        if (codeGenerator == null) {
            codeGenerator = (CodeGenerator)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getElsAccount, (Object)SysUtil.getPurchaseAccount())).eq(CodeGenerator::getGeneratorCode, (Object)generatorCode)).last(" limit 1")));
        }
        if (codeGenerator == null && !SysUtil.getPurchaseAccount().equals("100000")) {
            codeGenerator = (CodeGenerator)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getElsAccount, (Object)"100000")).eq(CodeGenerator::getGeneratorCode, (Object)generatorCode)).last(" limit 1")));
        }
        if (codeGenerator != null) {
            CodeGeneratorVO vo = new CodeGeneratorVO();
            BeanUtils.copyProperties((Object)((Object)codeGenerator), (Object)((Object)vo));
            vo.setCodeGeneratorDetailList(this.codeGeneratorDetailMapper.selectByMainId(vo.getId()));
            this.redisUtil.set(redisKey, (Object)vo);
            return vo;
        }
        throw new ELSBootException("\u7f16\u7801\u751f\u6210\u5668\u4e0d\u5b58\u5728\uff01");
    }

    @Override
    public String getNextCode(String codeType, Object businessObj) {
        CodeGeneratorVO codeGeneratorVO = this.getCodeGenerator(TenantContext.getTenant(), codeType);
        List<CodeGeneratorDetail> detailList = codeGeneratorVO.getCodeGeneratorDetailList();
        StringBuilder serialKey = new StringBuilder();
        StringBuilder code = new StringBuilder();
        ArrayList<String> codeList = new ArrayList<String>(16);
        int serialLength = 0;
        String serialNo = "";
        for (CodeGeneratorDetail detail : detailList) {
            if (!ValueTypeEnum.SERIAL.getCode().equals(detail.getValueType())) {
                String val = this.getValue(detail, businessObj);
                codeList.add(val);
                if (detail.getSerialKey() == null || 1 != detail.getSerialKey()) continue;
                serialKey.append(val);
                continue;
            }
            serialLength = detail.getValueLength();
            codeList.add("{serialNo}");
        }
        if (serialLength > 0) {
            serialNo = this.getSerialNo(codeGeneratorVO, serialKey.toString(), null);
        }
        for (String str : codeList) {
            if ("{serialNo}".equals(str)) {
                code.append(serialNo);
                continue;
            }
            code.append(str);
        }
        return code.toString();
    }

    @Override
    @Transactional(propagation=Propagation.NOT_SUPPORTED, readOnly=true)
    public String getNextCode(String codeType, Object businessObj, String elsAccount) {
        CodeGeneratorVO codeGeneratorVO = this.getCodeGenerator(elsAccount, codeType);
        List<CodeGeneratorDetail> detailList = codeGeneratorVO.getCodeGeneratorDetailList();
        StringBuilder serialKey = new StringBuilder();
        StringBuilder code = new StringBuilder();
        ArrayList<String> codeList = new ArrayList<String>(16);
        int serialLength = 0;
        String serialNo = "";
        for (CodeGeneratorDetail detail : detailList) {
            if (!ValueTypeEnum.SERIAL.getCode().equals(detail.getValueType())) {
                String val = this.getValue(detail, businessObj);
                codeList.add(val);
                if (detail.getSerialKey() == null || detail.getSerialKey() != 1) continue;
                serialKey.append(val);
                continue;
            }
            serialLength = detail.getValueLength();
            codeList.add("{serialNo}");
        }
        if (serialLength > 0) {
            serialNo = this.getSerialNo(codeGeneratorVO, serialKey.toString(), elsAccount);
        }
        for (String str : codeList) {
            if ("{serialNo}".equals(str)) {
                code.append(serialNo);
                continue;
            }
            code.append(str);
        }
        return code.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> getSerialBatchNo(CodeGenerator codeGenerator, String serialKey, int size) {
        if (size < 1) {
            size = 1;
        }
        String redisKey = this.getSerialKeyRedisKeyByCode(codeGenerator.getElsAccount(), codeGenerator.getGeneratorCode(), serialKey);
        Long serialNumber = (long)size + 0L;
        int incrementalValue = size;
        if (!this.redisUtil.hasKey(redisKey)) {
            String lockKey = this.getSerialKeyLockRedisKeyByCode(codeGenerator.getElsAccount(), codeGenerator.getGeneratorCode(), serialKey);
            boolean lock = false;
            if (this.redisUtil.tryLockWithTimeout(lockKey, codeGenerator.getElsAccount(), this.LOCK_TIME_OUT.longValue(), this.LOCK_WAIT_TIME.longValue())) {
                lock = true;
            }
            if (!lock) throw new ELSBootException("\u7cfb\u7edf\u7e41\u5fd9\uff0c\u751f\u6210\u6d41\u6c34\u53f7\u5931\u8d25\uff01");
            try {
                if (this.redisUtil.hasKey(redisKey)) {
                    serialNumber = this.redisUtil.incr(redisKey, (long)size);
                    this.srmPoolExecutor.execute(() -> this.codeGeneratorSerialMapper.incr(codeGenerator.getId(), serialKey, incrementalValue));
                }
                CodeGeneratorSerial generatorSerial = (CodeGeneratorSerial)((Object)this.codeGeneratorSerialMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CodeGeneratorSerial::getGeneratorId, (Object)codeGenerator.getId())).eq(CodeGeneratorSerial::getSerialKey, (Object)serialKey)));
                if (generatorSerial != null) {
                    serialNumber = (long)(generatorSerial.getSerialValue() + size) + 0L;
                    this.redisUtil.set2(redisKey, (Object)serialNumber, 86400L);
                    this.srmPoolExecutor.execute(() -> this.codeGeneratorSerialMapper.incr(codeGenerator.getId(), serialKey, incrementalValue));
                }
                this.redisUtil.set2(redisKey, (Object)serialNumber, 86400L);
                CodeGeneratorSerial serial = new CodeGeneratorSerial();
                serial.setElsAccount(codeGenerator.getElsAccount());
                serial.setGeneratorId(codeGenerator.getId());
                serial.setSerialKey(serialKey);
                serial.setSerialValue(serialNumber.intValue());
                this.srmPoolExecutor.execute(() -> this.codeGeneratorSerialMapper.insert((Object)serial));
            }
            catch (Exception e) {
                throw new ELSBootException("\u751f\u6210\u6d41\u6c34\u53f7\u5931\u8d25\uff01\u539f\u56e0\uff1a" + e.getMessage());
            }
            finally {
                this.redisUtil.releaseDistributedLock(lockKey, codeGenerator.getElsAccount());
            }
        } else {
            serialNumber = this.redisUtil.incr(redisKey, (long)size);
            this.srmPoolExecutor.execute(() -> this.codeGeneratorSerialMapper.incr(codeGenerator.getId(), serialKey, incrementalValue));
        }
        ArrayList<String> serialNos = new ArrayList<String>();
        StringBuilder addZero = new StringBuilder();
        while (size > 0) {
            String serialNo = serialNumber.toString();
            for (int i = 0; i < codeGenerator.getSerialLength() - serialNo.length(); ++i) {
                addZero.append("0");
            }
            addZero.append(serialNo);
            serialNos.add(addZero.toString());
            addZero.delete(0, addZero.length());
            Long l = serialNumber;
            Long l2 = serialNumber = Long.valueOf(serialNumber - 1L);
            --size;
        }
        return serialNos;
    }

    public void insertSerialNoAsync(CodeGeneratorSerial codeGeneratorSerial, Long serialNoLongVal, String key, String generatorId, String elsAccount) {
        if (codeGeneratorSerial != null) {
            codeGeneratorSerial.setSerialValue(serialNoLongVal.intValue());
            this.codeGeneratorSerialMapper.updateById((Object)codeGeneratorSerial);
        } else {
            codeGeneratorSerial = new CodeGeneratorSerial();
            codeGeneratorSerial.setGeneratorId(generatorId);
            codeGeneratorSerial.setSerialKey(key);
            codeGeneratorSerial.setSerialValue(serialNoLongVal.intValue());
            codeGeneratorSerial.setElsAccount(elsAccount);
            this.codeGeneratorSerialMapper.insert((Object)codeGeneratorSerial);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getSerialNo(CodeGenerator codeGenerator, String serialKey, String elsAccount) {
        if (StrUtil.isEmpty((CharSequence)elsAccount)) {
            elsAccount = TenantContext.getTenant();
        }
        String redisKey = this.getSerialKeyRedisKeyByCode(codeGenerator.getElsAccount(), codeGenerator.getGeneratorCode(), serialKey);
        Long serialNumber = 1L;
        if (!this.redisUtil.hasKey(redisKey)) {
            String lockKey = this.getSerialKeyLockRedisKeyByCode(codeGenerator.getElsAccount(), codeGenerator.getGeneratorCode(), serialKey);
            boolean lock = false;
            if (this.redisUtil.tryLockWithTimeout(lockKey, codeGenerator.getElsAccount(), this.LOCK_TIME_OUT.longValue(), this.LOCK_WAIT_TIME.longValue())) {
                lock = true;
            }
            if (!lock) throw new ELSBootException("\u7cfb\u7edf\u7e41\u5fd9\uff0c\u751f\u6210\u6d41\u6c34\u53f7\u5931\u8d25\uff01");
            try {
                if (this.redisUtil.hasKey(redisKey)) {
                    serialNumber = this.redisUtil.incr(redisKey, 1L);
                    this.srmPoolExecutor.execute(() -> this.codeGeneratorSerialMapper.incr(codeGenerator.getId(), serialKey, 1));
                }
                CodeGeneratorSerial generatorSerial = (CodeGeneratorSerial)((Object)this.codeGeneratorSerialMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CodeGeneratorSerial::getGeneratorId, (Object)codeGenerator.getId())).eq(CodeGeneratorSerial::getSerialKey, (Object)serialKey)));
                if (generatorSerial != null) {
                    serialNumber = (long)generatorSerial.getSerialValue().intValue() + 1L;
                    this.redisUtil.set2(redisKey, (Object)serialNumber, 86400L);
                    this.srmPoolExecutor.execute(() -> this.codeGeneratorSerialMapper.incr(codeGenerator.getId(), serialKey, 1));
                }
                this.redisUtil.set2(redisKey, (Object)serialNumber, 86400L);
                CodeGeneratorSerial serial = new CodeGeneratorSerial();
                serial.setElsAccount(codeGenerator.getElsAccount());
                serial.setGeneratorId(codeGenerator.getId());
                serial.setSerialKey(serialKey);
                serial.setSerialValue(serialNumber.intValue());
                this.srmPoolExecutor.execute(() -> this.codeGeneratorSerialMapper.insert((Object)serial));
            }
            catch (Exception e) {
                throw new ELSBootException("\u751f\u6210\u6d41\u6c34\u53f7\u5931\u8d25\uff01\u539f\u56e0\uff1a" + e.getMessage());
            }
            finally {
                this.redisUtil.releaseDistributedLock(lockKey, codeGenerator.getElsAccount());
            }
        } else {
            serialNumber = this.redisUtil.incr(redisKey, 1L);
            this.srmPoolExecutor.execute(() -> this.codeGeneratorSerialMapper.incr(codeGenerator.getId(), serialKey, 1));
        }
        String serialNo = serialNumber.toString();
        if (serialNo.length() >= codeGenerator.getSerialLength()) return serialNo;
        return StrUtil.fillBefore((String)serialNo, (char)'0', (int)codeGenerator.getSerialLength());
    }

    private String getValue(CodeGeneratorDetail detail, Object businessObj) {
        String value = "";
        if (ValueTypeEnum.FIXED.getCode().equals(detail.getValueType())) {
            value = detail.getValue();
        } else if (ValueTypeEnum.VAR.getCode().equals(detail.getValueType())) {
            value = (String)ReflectUtil.getFieldValue((Object)businessObj, (String)detail.getVariableName());
        } else if (ValueTypeEnum.EL.getCode().equals(detail.getValueType())) {
            value = DateUtil.format((Date)DateUtil.date(), (String)detail.getValue());
        } else if (ValueTypeEnum.ENUM.getCode().equals(detail.getValueType())) {
            String key = (String)ReflectUtil.getFieldValue((Object)businessObj, (String)detail.getVariableName());
            value = this.dictService.queryDictTextByKey(detail.getValue(), key, TenantContext.getTenant());
        }
        if (detail.getSubstringBegin() != null) {
            value = value.substring(detail.getSubstringBegin());
        }
        if (detail.getSubstringEnd() != null) {
            value = value.substring(0, value.length() - detail.getSubstringEnd());
        }
        return value;
    }
}

