/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.redisManager.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.redisManager.entity.RedisTree;
import com.els.modules.redisManager.entity.RedisValue;
import com.els.modules.redisManager.service.RedisManagerService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RedisManagerServiceImpl
implements RedisManagerService {
    @Resource
    private RedisUtil redisUtil;

    @Override
    public List<RedisTree> getRedisTree(String redisKey) {
        String pattern = StrUtil.isBlank((CharSequence)redisKey) ? "*" : redisKey + "*";
        Set keySet = this.redisUtil.scan(pattern);
        HashMap<String, Boolean> containsMap = new HashMap<String, Boolean>();
        ArrayList<RedisTree> parentList = new ArrayList<RedisTree>();
        for (String key : keySet) {
            String parentKey = key.contains(":") ? key.substring(0, key.indexOf(":") + 1) : key;
            if (containsMap.containsKey(parentKey)) continue;
            parentList.add(new RedisTree(parentKey.endsWith(":"), parentKey, parentKey));
            containsMap.put(parentKey, true);
        }
        this.assembleTree(keySet, parentList);
        return parentList;
    }

    private void assembleTree(Set<String> keySet, List<RedisTree> parentList) {
        for (RedisTree parenTree : parentList) {
            if (!parenTree.isFolder()) continue;
            HashMap<String, Boolean> containsMap = new HashMap<String, Boolean>();
            ArrayList<RedisTree> sonList = new ArrayList<RedisTree>();
            for (String key : keySet) {
                String sonText;
                String parentKey;
                if (!key.startsWith(parentKey = parenTree.getKey())) continue;
                String sonKeySuffix = key.substring(parentKey.length());
                String string = sonText = sonKeySuffix.contains(":") ? sonKeySuffix.substring(0, sonKeySuffix.indexOf(":") + 1) : sonKeySuffix;
                String sonKey = parentKey + sonText;
                if (containsMap.containsKey(sonKey)) continue;
                sonList.add(new RedisTree(sonKey.endsWith(":"), sonKey, sonText));
                containsMap.put(sonKey, true);
            }
            if (!CollectionUtil.isNotEmpty(sonList)) continue;
            parenTree.setChildren(sonList);
            this.assembleTree(keySet, sonList);
        }
    }

    @Override
    public RedisValue getValue(String redisKey) {
        RedisValue result = new RedisValue();
        if (redisKey.endsWith(":")) {
            result.setValue(null);
            result.setExpirationTime(null);
        } else {
            Long expirationTime = this.redisUtil.getExpire(redisKey);
            Object value = this.redisUtil.get(redisKey);
            result.setExpirationTime(expirationTime);
            result.setValue(value);
        }
        return result;
    }

    @Override
    public void deleteKey(RedisTree redisTree) {
        if (redisTree.isFolder()) {
            this.redisUtil.dels(redisTree.getKey());
        } else {
            this.redisUtil.del(new String[]{redisTree.getKey()});
        }
    }
}

