/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.agent;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.tencent.supersonic.chat.server.agent.AgentToolType;
import com.tencent.supersonic.chat.server.agent.MultiTurnConfig;
import com.tencent.supersonic.chat.server.agent.NL2SQLTool;
import com.tencent.supersonic.common.config.LLMConfig;
import com.tencent.supersonic.common.config.VisualConfig;
import com.tencent.supersonic.common.pojo.RecordInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class Agent
extends RecordInfo {
    private Integer id;
    private Integer enableSearch;
    private String name;
    private String description;
    private String businessType;
    private Integer status;
    private List<String> examples;
    private String agentConfig;
    private LLMConfig llmConfig;
    private MultiTurnConfig multiTurnConfig;
    private VisualConfig visualConfig;

    public List<String> getTools(AgentToolType type) {
        Map map = (Map)JSONObject.parseObject((String)this.agentConfig, Map.class);
        if (CollectionUtils.isEmpty((Map)map) || map.get("tools") == null) {
            return Lists.newArrayList();
        }
        List toolList = (List)map.get("tools");
        return toolList.stream().filter(tool -> {
            if (Objects.isNull((Object)type)) {
                return true;
            }
            return type.name().equals(tool.get("type"));
        }).map(JSON::toJSONString).collect(Collectors.toList());
    }

    public boolean enableSearch() {
        return this.enableSearch != null && this.enableSearch == 1;
    }

    public static boolean containsAllModel(Set<Long> detectViewIds) {
        return !CollectionUtils.isEmpty(detectViewIds) && detectViewIds.contains(-1L);
    }

    public List<NL2SQLTool> getParserTools(AgentToolType agentToolType) {
        List<String> tools = this.getTools(agentToolType);
        if (CollectionUtils.isEmpty(tools)) {
            return Lists.newArrayList();
        }
        return tools.stream().map(tool -> (NL2SQLTool)JSONObject.parseObject((String)tool, NL2SQLTool.class)).collect(Collectors.toList());
    }

    public boolean containsPluginTool() {
        return !CollectionUtils.isEmpty(this.getParserTools(AgentToolType.PLUGIN));
    }

    public boolean containsLLMParserTool() {
        return !CollectionUtils.isEmpty(this.getParserTools(AgentToolType.NL2SQL_LLM));
    }

    public boolean containsRuleTool() {
        return !CollectionUtils.isEmpty(this.getParserTools(AgentToolType.NL2SQL_RULE));
    }

    public boolean containsNL2SQLTool() {
        return !CollectionUtils.isEmpty(this.getParserTools(AgentToolType.NL2SQL_LLM)) || !CollectionUtils.isEmpty(this.getParserTools(AgentToolType.NL2SQL_RULE));
    }

    public boolean containsAnyTool() {
        Map map = (Map)JSONObject.parseObject((String)this.agentConfig, Map.class);
        if (CollectionUtils.isEmpty((Map)map)) {
            return false;
        }
        List toolList = (List)map.get("tools");
        return !CollectionUtils.isEmpty((Collection)toolList);
    }

    public Set<Long> getDataSetIds() {
        Set<Long> dataSetIds = this.getDataSetIds(null);
        if (Agent.containsAllModel(dataSetIds)) {
            return Sets.newHashSet();
        }
        return dataSetIds;
    }

    public Set<Long> getDataSetIds(AgentToolType agentToolType) {
        List<NL2SQLTool> commonAgentTools = this.getParserTools(agentToolType);
        if (CollectionUtils.isEmpty(commonAgentTools)) {
            return new HashSet<Long>();
        }
        return commonAgentTools.stream().map(NL2SQLTool::getDataSetIds).filter(modelIds -> !CollectionUtils.isEmpty((Collection)modelIds)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Integer getId() {
        return this.id;
    }

    public Integer getEnableSearch() {
        return this.enableSearch;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getBusinessType() {
        return this.businessType;
    }

    public Integer getStatus() {
        return this.status;
    }

    public List<String> getExamples() {
        return this.examples;
    }

    public String getAgentConfig() {
        return this.agentConfig;
    }

    public LLMConfig getLlmConfig() {
        return this.llmConfig;
    }

    public MultiTurnConfig getMultiTurnConfig() {
        return this.multiTurnConfig;
    }

    public VisualConfig getVisualConfig() {
        return this.visualConfig;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setEnableSearch(Integer enableSearch) {
        this.enableSearch = enableSearch;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setExamples(List<String> examples) {
        this.examples = examples;
    }

    public void setAgentConfig(String agentConfig) {
        this.agentConfig = agentConfig;
    }

    public void setLlmConfig(LLMConfig llmConfig) {
        this.llmConfig = llmConfig;
    }

    public void setMultiTurnConfig(MultiTurnConfig multiTurnConfig) {
        this.multiTurnConfig = multiTurnConfig;
    }

    public void setVisualConfig(VisualConfig visualConfig) {
        this.visualConfig = visualConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Agent)) {
            return false;
        }
        Agent other = (Agent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$enableSearch = this.getEnableSearch();
        Integer other$enableSearch = other.getEnableSearch();
        if (this$enableSearch == null ? other$enableSearch != null : !((Object)this$enableSearch).equals(other$enableSearch)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$businessType = this.getBusinessType();
        String other$businessType = other.getBusinessType();
        if (this$businessType == null ? other$businessType != null : !this$businessType.equals(other$businessType)) {
            return false;
        }
        List<String> this$examples = this.getExamples();
        List<String> other$examples = other.getExamples();
        if (this$examples == null ? other$examples != null : !((Object)this$examples).equals(other$examples)) {
            return false;
        }
        String this$agentConfig = this.getAgentConfig();
        String other$agentConfig = other.getAgentConfig();
        if (this$agentConfig == null ? other$agentConfig != null : !this$agentConfig.equals(other$agentConfig)) {
            return false;
        }
        LLMConfig this$llmConfig = this.getLlmConfig();
        LLMConfig other$llmConfig = other.getLlmConfig();
        if (this$llmConfig == null ? other$llmConfig != null : !this$llmConfig.equals(other$llmConfig)) {
            return false;
        }
        MultiTurnConfig this$multiTurnConfig = this.getMultiTurnConfig();
        MultiTurnConfig other$multiTurnConfig = other.getMultiTurnConfig();
        if (this$multiTurnConfig == null ? other$multiTurnConfig != null : !((Object)this$multiTurnConfig).equals(other$multiTurnConfig)) {
            return false;
        }
        VisualConfig this$visualConfig = this.getVisualConfig();
        VisualConfig other$visualConfig = other.getVisualConfig();
        return !(this$visualConfig == null ? other$visualConfig != null : !this$visualConfig.equals(other$visualConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Agent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $enableSearch = this.getEnableSearch();
        result = result * 59 + ($enableSearch == null ? 43 : ((Object)$enableSearch).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $businessType = this.getBusinessType();
        result = result * 59 + ($businessType == null ? 43 : $businessType.hashCode());
        List<String> $examples = this.getExamples();
        result = result * 59 + ($examples == null ? 43 : ((Object)$examples).hashCode());
        String $agentConfig = this.getAgentConfig();
        result = result * 59 + ($agentConfig == null ? 43 : $agentConfig.hashCode());
        LLMConfig $llmConfig = this.getLlmConfig();
        result = result * 59 + ($llmConfig == null ? 43 : $llmConfig.hashCode());
        MultiTurnConfig $multiTurnConfig = this.getMultiTurnConfig();
        result = result * 59 + ($multiTurnConfig == null ? 43 : ((Object)$multiTurnConfig).hashCode());
        VisualConfig $visualConfig = this.getVisualConfig();
        result = result * 59 + ($visualConfig == null ? 43 : $visualConfig.hashCode());
        return result;
    }

    public String toString() {
        return "Agent(id=" + this.getId() + ", enableSearch=" + this.getEnableSearch() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", businessType=" + this.getBusinessType() + ", status=" + this.getStatus() + ", examples=" + this.getExamples() + ", agentConfig=" + this.getAgentConfig() + ", llmConfig=" + this.getLlmConfig() + ", multiTurnConfig=" + this.getMultiTurnConfig() + ", visualConfig=" + this.getVisualConfig() + ")";
    }
}

