/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.plugin.build;

import com.google.common.collect.Lists;
import com.tencent.supersonic.chat.server.plugin.PluginParseResult;
import com.tencent.supersonic.chat.server.plugin.build.ParamOption;
import com.tencent.supersonic.chat.server.plugin.build.WebBase;
import com.tencent.supersonic.headless.api.pojo.SchemaElementMatch;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.api.pojo.request.QueryFilter;
import com.tencent.supersonic.headless.api.pojo.request.QueryFilters;
import com.tencent.supersonic.headless.api.pojo.response.QueryResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class PluginSemanticQuery {
    private static final Logger log = LoggerFactory.getLogger(PluginSemanticQuery.class);
    protected SemanticParseInfo parseInfo;

    public abstract QueryResult build();

    private Map<Long, Object> getFilterMap(PluginParseResult pluginParseResult) {
        HashMap<Long, Object> map = new HashMap<Long, Object>();
        QueryFilters queryFilters = pluginParseResult.getQueryFilters();
        if (queryFilters == null) {
            return map;
        }
        List queryFilterList = queryFilters.getFilters();
        if (CollectionUtils.isEmpty((Collection)queryFilterList)) {
            return map;
        }
        for (QueryFilter queryFilter : queryFilterList) {
            map.put(queryFilter.getElementID(), queryFilter.getValue());
        }
        return map;
    }

    protected Map<String, Object> getElementMap(PluginParseResult pluginParseResult) {
        HashMap<String, Object> elementValueMap = new HashMap<String, Object>();
        Map<Long, Object> filterValueMap = this.getFilterMap(pluginParseResult);
        List schemaElementMatchList = this.parseInfo.getElementMatches().stream().filter(schemaElementMatch -> schemaElementMatch.getFrequency() != null).sorted(Comparator.comparingLong(SchemaElementMatch::getFrequency).reversed()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(schemaElementMatchList)) {
            schemaElementMatchList.stream().filter(schemaElementMatch -> SchemaElementType.VALUE.equals((Object)schemaElementMatch.getElement().getType()) || SchemaElementType.ID.equals((Object)schemaElementMatch.getElement().getType())).filter(schemaElementMatch -> schemaElementMatch.getSimilarity() == 1.0).forEach(schemaElementMatch -> {
                Object queryFilterValue = filterValueMap.get(schemaElementMatch.getElement().getId());
                if (queryFilterValue != null) {
                    if (String.valueOf(queryFilterValue).equals(String.valueOf(schemaElementMatch.getWord()))) {
                        elementValueMap.put(String.valueOf(schemaElementMatch.getElement().getId()), schemaElementMatch.getWord());
                    }
                } else {
                    elementValueMap.computeIfAbsent(String.valueOf(schemaElementMatch.getElement().getId()), k -> schemaElementMatch.getWord());
                }
            });
        }
        return elementValueMap;
    }

    protected WebBase fillWebBaseResult(WebBase webPage, PluginParseResult pluginParseResult) {
        WebBase webBaseResult = new WebBase();
        webBaseResult.setUrl(webPage.getUrl());
        Map<String, Object> elementValueMap = this.getElementMap(pluginParseResult);
        ArrayList paramOptions = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(webPage.getParamOptions()) && !CollectionUtils.isEmpty(elementValueMap)) {
            for (ParamOption paramOption : webPage.getParamOptions()) {
                if (paramOption.getDataSetId() != null && !this.parseInfo.getDataSetId().equals(paramOption.getDataSetId())) continue;
                paramOptions.add(paramOption);
                if (!ParamOption.ParamType.SEMANTIC.equals((Object)paramOption.getParamType())) continue;
                String elementId = String.valueOf(paramOption.getElementId());
                Object elementValue = elementValueMap.get(elementId);
                paramOption.setValue(elementValue);
            }
        }
        webBaseResult.setParamOptions(paramOptions);
        return webBaseResult;
    }

    public void setParseInfo(SemanticParseInfo parseInfo) {
        this.parseInfo = parseInfo;
    }
}

