/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.plugin.build.webpage;

import com.tencent.supersonic.chat.server.plugin.ChatPlugin;
import com.tencent.supersonic.chat.server.plugin.PluginParseResult;
import com.tencent.supersonic.chat.server.plugin.PluginQueryManager;
import com.tencent.supersonic.chat.server.plugin.build.PluginSemanticQuery;
import com.tencent.supersonic.chat.server.plugin.build.WebBase;
import com.tencent.supersonic.chat.server.plugin.build.webpage.WebPageResp;
import com.tencent.supersonic.common.util.JsonUtil;
import com.tencent.supersonic.headless.api.pojo.response.QueryResult;
import com.tencent.supersonic.headless.api.pojo.response.QueryState;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WebPageQuery
extends PluginSemanticQuery {
    private static final Logger log = LoggerFactory.getLogger(WebPageQuery.class);
    public static String QUERY_MODE = "WEB_PAGE";

    public WebPageQuery() {
        PluginQueryManager.register(QUERY_MODE, this);
    }

    protected WebPageResp buildResponse(PluginParseResult pluginParseResult) {
        ChatPlugin plugin = pluginParseResult.getPlugin();
        WebPageResp webPageResponse = new WebPageResp();
        webPageResponse.setName(plugin.getName());
        webPageResponse.setPluginId(plugin.getId());
        webPageResponse.setPluginType(plugin.getType());
        WebBase webPage = (WebBase)JsonUtil.toObject((String)plugin.getConfig(), WebBase.class);
        WebBase webBase = this.fillWebBaseResult(webPage, pluginParseResult);
        webPageResponse.setWebPage(webBase);
        return webPageResponse;
    }

    @Override
    public QueryResult build() {
        QueryResult queryResult = new QueryResult();
        queryResult.setQueryMode(QUERY_MODE);
        Map properties = this.parseInfo.getProperties();
        PluginParseResult pluginParseResult = (PluginParseResult)JsonUtil.toObject((String)JsonUtil.toString(properties.get("CONTEXT")), PluginParseResult.class);
        WebPageResp webPageResponse = this.buildResponse(pluginParseResult);
        queryResult.setResponse((Object)webPageResponse);
        queryResult.setQueryState(QueryState.SUCCESS);
        return queryResult;
    }
}

