/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.plugin.build.webservice;

import com.alibaba.fastjson.JSON;
import com.tencent.supersonic.chat.server.plugin.ChatPlugin;
import com.tencent.supersonic.chat.server.plugin.PluginParseResult;
import com.tencent.supersonic.chat.server.plugin.PluginQueryManager;
import com.tencent.supersonic.chat.server.plugin.build.ParamOption;
import com.tencent.supersonic.chat.server.plugin.build.PluginSemanticQuery;
import com.tencent.supersonic.chat.server.plugin.build.WebBase;
import com.tencent.supersonic.chat.server.plugin.build.webservice.WebServiceResp;
import com.tencent.supersonic.common.util.ContextUtils;
import com.tencent.supersonic.common.util.JsonUtil;
import com.tencent.supersonic.headless.api.pojo.response.QueryResult;
import com.tencent.supersonic.headless.api.pojo.response.QueryState;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class WebServiceQuery
extends PluginSemanticQuery {
    private static final Logger log = LoggerFactory.getLogger(WebServiceQuery.class);
    public static String QUERY_MODE = "WEB_SERVICE";
    private RestTemplate restTemplate;

    public WebServiceQuery() {
        PluginQueryManager.register(QUERY_MODE, this);
    }

    @Override
    public QueryResult build() {
        QueryResult queryResult = new QueryResult();
        queryResult.setQueryMode(QUERY_MODE);
        Map properties = this.parseInfo.getProperties();
        PluginParseResult pluginParseResult = (PluginParseResult)JsonUtil.toObject((String)JsonUtil.toString(properties.get("CONTEXT")), PluginParseResult.class);
        WebServiceResp webServiceResponse = this.buildResponse(pluginParseResult);
        Object object = webServiceResponse.getResult();
        log.info("webServiceResponse result:{}", (Object)JsonUtil.toString((Object)object));
        try {
            Map data = JsonUtil.toMap((String)JsonUtil.toString((Object)object), String.class, Object.class);
            if (data.get("resultList") != null) {
                queryResult.setQueryResults((List)data.get("resultList"));
            }
            if (data.get("columns") != null) {
                queryResult.setQueryColumns((List)data.get("columns"));
            }
            queryResult.setTextResult(String.valueOf(data.get("data")));
            queryResult.setQueryState(QueryState.SUCCESS);
        }
        catch (Exception e) {
            log.info("webServiceResponse result has an exception:{}", (Object)e.getMessage());
        }
        return queryResult;
    }

    protected WebServiceResp buildResponse(PluginParseResult pluginParseResult) {
        WebServiceResp webServiceResponse = new WebServiceResp();
        ChatPlugin plugin = pluginParseResult.getPlugin();
        WebBase webBase = this.fillWebBaseResult((WebBase)JsonUtil.toObject((String)plugin.getConfig(), WebBase.class), pluginParseResult);
        webServiceResponse.setWebBase(webBase);
        List<ParamOption> paramOptions = webBase.getParamOptions();
        HashMap params = new HashMap();
        paramOptions.forEach(o -> params.put(o.getKey(), o.getValue()));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity((Object)JSON.toJSONString(params), (MultiValueMap)headers);
        String url = webBase.getUrl() + "?queryText=" + pluginParseResult.getQueryText();
        URI requestUrl = UriComponentsBuilder.fromHttpUrl((String)url).build().encode().toUri();
        ResponseEntity responseEntity = null;
        Object objectResponse = null;
        this.restTemplate = (RestTemplate)ContextUtils.getBean(RestTemplate.class);
        try {
            responseEntity = this.restTemplate.exchange(requestUrl, HttpMethod.POST, entity, Object.class);
            objectResponse = responseEntity.getBody();
            log.info("objectResponse:{}", objectResponse);
            Map response = JsonUtil.objectToMap((Object)objectResponse);
            webServiceResponse.setResult(response);
        }
        catch (Exception e) {
            log.info("Exception:{}", (Object)e.getMessage());
        }
        return webServiceResponse;
    }
}

