/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.plugin.recognize;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.tencent.supersonic.chat.server.plugin.ChatPlugin;
import com.tencent.supersonic.chat.server.plugin.PluginManager;
import com.tencent.supersonic.chat.server.plugin.PluginParseResult;
import com.tencent.supersonic.chat.server.plugin.PluginRecallResult;
import com.tencent.supersonic.chat.server.pojo.ChatParseContext;
import com.tencent.supersonic.common.pojo.enums.FilterOperatorEnum;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.api.pojo.request.QueryFilter;
import com.tencent.supersonic.headless.api.pojo.request.QueryFilters;
import com.tencent.supersonic.headless.api.pojo.response.ParseResp;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.springframework.util.CollectionUtils;

public abstract class PluginRecognizer {
    public void recognize(ChatParseContext chatParseContext, ParseResp parseResp) {
        if (!this.checkPreCondition(chatParseContext)) {
            return;
        }
        PluginRecallResult pluginRecallResult = this.recallPlugin(chatParseContext);
        if (pluginRecallResult == null) {
            return;
        }
        this.buildQuery(chatParseContext, parseResp, pluginRecallResult);
    }

    public abstract boolean checkPreCondition(ChatParseContext var1);

    public abstract PluginRecallResult recallPlugin(ChatParseContext var1);

    public void buildQuery(ChatParseContext chatParseContext, ParseResp parseResp, PluginRecallResult pluginRecallResult) {
        ChatPlugin plugin = pluginRecallResult.getPlugin();
        HashSet dataSetIds = pluginRecallResult.getDataSetIds();
        if (plugin.isContainsAllDataSet()) {
            dataSetIds = Sets.newHashSet((Object[])new Long[]{-1L});
        }
        for (Long dataSetId : dataSetIds) {
            SemanticParseInfo semanticParseInfo = this.buildSemanticParseInfo(dataSetId, plugin, chatParseContext, pluginRecallResult.getDistance());
            semanticParseInfo.setQueryMode(plugin.getType());
            semanticParseInfo.setScore(pluginRecallResult.getScore());
            parseResp.getSelectedParses().add(semanticParseInfo);
        }
    }

    protected List<ChatPlugin> getPluginList(ChatParseContext chatParseContext) {
        return PluginManager.getPluginAgentCanSupport(chatParseContext);
    }

    protected SemanticParseInfo buildSemanticParseInfo(Long dataSetId, ChatPlugin plugin, ChatParseContext chatParseContext, double distance) {
        List schemaElementMatches = chatParseContext.getMapInfo().getMatchedElements(dataSetId);
        QueryFilters queryFilters = chatParseContext.getQueryFilters();
        if (schemaElementMatches == null) {
            schemaElementMatches = Lists.newArrayList();
        }
        SemanticParseInfo semanticParseInfo = new SemanticParseInfo();
        semanticParseInfo.setElementMatches(schemaElementMatches);
        SchemaElement schemaElement = new SchemaElement();
        schemaElement.setDataSet(dataSetId);
        semanticParseInfo.setDataSet(schemaElement);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        PluginParseResult pluginParseResult = new PluginParseResult();
        pluginParseResult.setPlugin(plugin);
        pluginParseResult.setQueryFilters(queryFilters);
        pluginParseResult.setDistance(distance);
        pluginParseResult.setQueryText(chatParseContext.getQueryText());
        properties.put("CONTEXT", pluginParseResult);
        properties.put("type", "plugin");
        properties.put("name", plugin.getName());
        semanticParseInfo.setProperties(properties);
        semanticParseInfo.setScore(distance);
        semanticParseInfo.setTextInfo(String.format("\u5c06\u7531\u63d2\u4ef6\u5de5\u5177**%s**\u6765\u89e3\u7b54", plugin.getName()));
        this.fillSemanticParseInfo(semanticParseInfo);
        return semanticParseInfo;
    }

    private void fillSemanticParseInfo(SemanticParseInfo semanticParseInfo) {
        List schemaElementMatches = semanticParseInfo.getElementMatches();
        if (CollectionUtils.isEmpty((Collection)schemaElementMatches)) {
            return;
        }
        schemaElementMatches.stream().filter(schemaElementMatch -> SchemaElementType.VALUE.equals((Object)schemaElementMatch.getElement().getType()) || SchemaElementType.ID.equals((Object)schemaElementMatch.getElement().getType())).forEach(schemaElementMatch -> {
            QueryFilter queryFilter = new QueryFilter();
            queryFilter.setValue((Object)schemaElementMatch.getWord());
            queryFilter.setElementID(schemaElementMatch.getElement().getId());
            queryFilter.setName(schemaElementMatch.getElement().getName());
            queryFilter.setOperator(FilterOperatorEnum.EQUALS);
            queryFilter.setBizName(schemaElementMatch.getElement().getBizName());
            semanticParseInfo.getDimensionFilters().add(queryFilter);
        });
    }
}

