/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.processor.execute;

import com.alibaba.fastjson.JSONObject;
import com.tencent.supersonic.chat.server.pojo.ChatExecuteContext;
import com.tencent.supersonic.chat.server.processor.execute.ExecuteResultProcessor;
import com.tencent.supersonic.common.pojo.enums.QueryType;
import com.tencent.supersonic.common.util.ContextUtils;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.api.pojo.response.QueryResult;
import com.tencent.supersonic.headless.chat.knowledge.MetaEmbeddingService;
import dev.langchain4j.store.embedding.Retrieval;
import dev.langchain4j.store.embedding.RetrieveQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class MetricRecommendProcessor
implements ExecuteResultProcessor {
    private static final int METRIC_RECOMMEND_SIZE = 5;

    @Override
    public void process(ChatExecuteContext chatExecuteContext, QueryResult queryResult) {
        this.fillSimilarMetric(chatExecuteContext.getParseInfo());
    }

    private void fillSimilarMetric(SemanticParseInfo parseInfo) {
        if (!parseInfo.getQueryType().equals((Object)QueryType.METRIC) || parseInfo.getMetrics().size() > 5 || CollectionUtils.isEmpty((Collection)parseInfo.getMetrics())) {
            return;
        }
        List<String> metricNames = Collections.singletonList(((SchemaElement)parseInfo.getMetrics().iterator().next()).getName());
        HashMap<String, String> filterCondition = new HashMap<String, String>();
        filterCondition.put("modelId", ((SchemaElement)parseInfo.getMetrics().iterator().next()).getDataSet().toString());
        filterCondition.put("type", SchemaElementType.METRIC.name());
        RetrieveQuery retrieveQuery = RetrieveQuery.builder().queryTextsList(metricNames).filterCondition(filterCondition).queryEmbeddings(null).build();
        MetaEmbeddingService metaEmbeddingService = (MetaEmbeddingService)ContextUtils.getBean(MetaEmbeddingService.class);
        List retrieveQueryResults = metaEmbeddingService.retrieveQuery(retrieveQuery, 6, new HashMap(), new HashSet());
        if (CollectionUtils.isEmpty((Collection)retrieveQueryResults)) {
            return;
        }
        List retrievals = retrieveQueryResults.stream().flatMap(retrieveQueryResult -> retrieveQueryResult.getRetrieval().stream()).sorted(Comparator.comparingDouble(Retrieval::getDistance)).distinct().collect(Collectors.toList());
        Set metricIds = parseInfo.getMetrics().stream().map(SchemaElement::getId).collect(Collectors.toSet());
        int metricOrder = 0;
        for (SchemaElement metric : parseInfo.getMetrics()) {
            metric.setOrder((double)metricOrder++);
        }
        for (Retrieval retrieval : retrievals) {
            if (metricIds.contains(Retrieval.getLongId((Object)retrieval.getId()))) continue;
            if (Objects.nonNull(retrieval.getMetadata().get("id"))) {
                String idStr = retrieval.getMetadata().get("id").toString().replaceAll("_", "");
                retrieval.getMetadata().put("id", idStr);
            }
            String metaStr = JSONObject.toJSONString((Object)retrieval.getMetadata());
            SchemaElement schemaElement = (SchemaElement)JSONObject.parseObject((String)metaStr, SchemaElement.class);
            if (retrieval.getMetadata().containsKey("dataSetId")) {
                String dataSetId = retrieval.getMetadata().get("dataSetId").toString().replace("_", "");
                schemaElement.setDataSet(Long.valueOf(Long.parseLong(dataSetId)));
            }
            schemaElement.setOrder((double)(++metricOrder));
            parseInfo.getMetrics().add(schemaElement);
        }
    }
}

