/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.rest;

import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.utils.UserHolder;
import com.tencent.supersonic.chat.api.pojo.request.ChatConfigBaseReq;
import com.tencent.supersonic.chat.api.pojo.request.ChatConfigEditReqReq;
import com.tencent.supersonic.chat.api.pojo.request.ChatConfigFilter;
import com.tencent.supersonic.chat.api.pojo.response.ChatConfigResp;
import com.tencent.supersonic.chat.api.pojo.response.ChatConfigRichResp;
import com.tencent.supersonic.chat.server.service.ConfigService;
import com.tencent.supersonic.headless.api.pojo.DataSetSchema;
import com.tencent.supersonic.headless.api.pojo.response.ItemResp;
import com.tencent.supersonic.headless.server.facade.service.SemanticLayerService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/chat/conf", "/openapi/chat/conf"})
public class ChatConfigController {
    @Autowired
    private ConfigService configService;
    @Autowired
    private SemanticLayerService semanticLayerService;

    @PostMapping
    public Long addChatConfig(@RequestBody ChatConfigBaseReq extendBaseCmd, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.configService.addConfig(extendBaseCmd, user);
    }

    @PutMapping
    public Long editModelExtend(@RequestBody ChatConfigEditReqReq extendEditCmd, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.configService.editConfig(extendEditCmd, user);
    }

    @PostMapping(value={"/search"})
    public List<ChatConfigResp> search(@RequestBody ChatConfigFilter filter, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.configService.search(filter, user);
    }

    @GetMapping(value={"/richDesc/{modelId}"})
    public ChatConfigRichResp getModelExtendRichInfo(@PathVariable(value="modelId") Long modelId) {
        return this.configService.getConfigRichInfo(modelId);
    }

    @GetMapping(value={"/richDesc/all"})
    public List<ChatConfigRichResp> getAllChatRichConfig() {
        return this.configService.getAllChatRichConfig();
    }

    @GetMapping(value={"/getDomainDataSetTree"})
    public List<ItemResp> getDomainDataSetTree() {
        return this.semanticLayerService.getDomainDataSetTree();
    }

    @GetMapping(value={"/getDataSetSchema/{id}"})
    public DataSetSchema getDataSetSchema(@PathVariable(value="id") Long id) {
        return this.semanticLayerService.getDataSetSchema(id);
    }
}

