/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.rest;

import com.tencent.supersonic.auth.api.authentication.annotation.AuthenticationIgnore;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.utils.UserHolder;
import com.tencent.supersonic.chat.api.pojo.request.PluginQueryReq;
import com.tencent.supersonic.chat.server.plugin.ChatPlugin;
import com.tencent.supersonic.chat.server.service.PluginService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/chat/plugin"})
public class PluginController {
    @Autowired
    protected PluginService pluginService;

    @PostMapping
    public boolean createPlugin(@RequestBody ChatPlugin plugin, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        User user = UserHolder.findUser((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        this.pluginService.createPlugin(plugin, user);
        return true;
    }

    @PutMapping
    public boolean updatePlugin(@RequestBody ChatPlugin plugin, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        User user = UserHolder.findUser((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        this.pluginService.updatePlugin(plugin, user);
        return true;
    }

    @DeleteMapping(value={"/{id}"})
    public boolean deletePlugin(@PathVariable(value="id") Long id) {
        this.pluginService.deletePlugin(id);
        return true;
    }

    @RequestMapping(value={"/getPluginList"})
    public List<ChatPlugin> getPluginList() {
        return this.pluginService.getPluginList();
    }

    @PostMapping(value={"/query"})
    List<ChatPlugin> query(@RequestBody PluginQueryReq pluginQueryReq, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        User user = UserHolder.findUser((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        return this.pluginService.queryWithAuthCheck(pluginQueryReq, user);
    }

    @AuthenticationIgnore
    @PostMapping(value={"/pluginDemo"})
    public String pluginDemo(@RequestParam(value="queryText") String queryText, @RequestBody Object object) {
        return String.format("\u5df2\u6536\u5230\u60a8\u7684\u95ee\u9898:%s, \u4f46\u8fd9\u53ea\u662f\u4e00\u4e2ademo~", queryText);
    }
}

