/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.util.SpringContextUtils;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.chat.api.pojo.request.ChatMemoryFilter;
import com.tencent.supersonic.chat.server.agent.Agent;
import com.tencent.supersonic.chat.server.agent.MultiTurnConfig;
import com.tencent.supersonic.chat.server.persistence.dataobject.AgentDO;
import com.tencent.supersonic.chat.server.persistence.dataobject.ChatMemoryDO;
import com.tencent.supersonic.chat.server.persistence.mapper.AgentDOMapper;
import com.tencent.supersonic.chat.server.service.AgentService;
import com.tencent.supersonic.chat.server.service.ChatService;
import com.tencent.supersonic.chat.server.service.MemoryService;
import com.tencent.supersonic.chat.server.util.LLMConnHelper;
import com.tencent.supersonic.common.config.ModelConfig;
import com.tencent.supersonic.common.config.PromptConfig;
import com.tencent.supersonic.common.config.VisualConfig;
import com.tencent.supersonic.common.util.JsonUtil;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgentServiceImpl
extends ServiceImpl<AgentDOMapper, AgentDO>
implements AgentService {
    private static final Logger log = LoggerFactory.getLogger(AgentServiceImpl.class);
    @Autowired
    private MemoryService memoryService;
    private ExecutorService executorService = Executors.newFixedThreadPool(1);

    @Override
    public List<Agent> getAgents() {
        return this.getAgentDOList().stream().map(this::convert).collect(Collectors.toList());
    }

    @Override
    public Agent createAgent(Agent agent, User user) {
        agent.createdBy(user.getName());
        AgentDO agentDO = this.convert(agent);
        this.save(agentDO);
        agent.setId(agentDO.getId());
        this.executeAgentExamplesAsync(agent);
        return agent;
    }

    @Override
    public Agent updateAgent(Agent agent, User user) {
        agent.updatedBy(user.getName());
        this.updateById(this.convert(agent));
        this.executeAgentExamplesAsync(agent);
        return agent;
    }

    @Override
    public Agent getAgent(Integer id) {
        if (id == null) {
            return null;
        }
        return this.convert((AgentDO)this.getById(id));
    }

    @Override
    public void deleteAgent(Integer id) {
        this.removeById(id);
    }

    private void executeAgentExamplesAsync(Agent agent) {
        this.executorService.execute(() -> this.doExecuteAgentExamples(agent));
    }

    private synchronized void doExecuteAgentExamples(Agent agent) {
        if (!agent.containsLLMParserTool() || !LLMConnHelper.testConnection(agent.getModelConfig()) || CollectionUtils.isEmpty(agent.getExamples())) {
            return;
        }
        List<String> examples = agent.getExamples();
        ChatMemoryFilter chatMemoryFilter = ChatMemoryFilter.builder().agentId(agent.getId()).questions(examples).build();
        List memoriesExisted = this.memoryService.getMemories(chatMemoryFilter).stream().map(ChatMemoryDO::getQuestion).collect(Collectors.toList());
        for (String example : examples) {
            if (memoriesExisted.contains(example)) continue;
            try {
                ((ChatService)SpringContextUtils.getBean(ChatService.class)).parseAndExecute(-1, agent.getId(), example);
            }
            catch (Exception e) {
                log.warn("agent:{} example execute failed:{}", (Object)agent.getName(), (Object)example);
            }
        }
    }

    private List<AgentDO> getAgentDOList() {
        return this.list();
    }

    private Agent convert(AgentDO agentDO) {
        if (agentDO == null) {
            return null;
        }
        Agent agent = new Agent();
        BeanUtils.copyProperties((Object)agentDO, (Object)((Object)agent));
        agent.setAgentConfig(agentDO.getConfig());
        agent.setExamples(JsonUtil.toList((String)agentDO.getExamples(), String.class));
        agent.setModelConfig((ModelConfig)JsonUtil.toObject((String)agentDO.getModelConfig(), ModelConfig.class));
        agent.setPromptConfig((PromptConfig)JsonUtil.toObject((String)agentDO.getPromptConfig(), PromptConfig.class));
        agent.setMultiTurnConfig((MultiTurnConfig)JsonUtil.toObject((String)agentDO.getMultiTurnConfig(), MultiTurnConfig.class));
        agent.setVisualConfig((VisualConfig)JsonUtil.toObject((String)agentDO.getVisualConfig(), VisualConfig.class));
        return agent;
    }

    private AgentDO convert(Agent agent) {
        AgentDO agentDO = new AgentDO();
        BeanUtils.copyProperties((Object)((Object)agent), (Object)agentDO);
        agentDO.setConfig(agent.getAgentConfig());
        agentDO.setExamples(JsonUtil.toString(agent.getExamples()));
        agentDO.setModelConfig(JsonUtil.toString((Object)agent.getModelConfig()));
        agentDO.setMultiTurnConfig(JsonUtil.toString((Object)agent.getMultiTurnConfig()));
        agentDO.setVisualConfig(JsonUtil.toString((Object)agent.getVisualConfig()));
        agentDO.setPromptConfig(JsonUtil.toString((Object)agent.getPromptConfig()));
        if (agentDO.getStatus() == null) {
            agentDO.setStatus(1);
        }
        return agentDO;
    }
}

