/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.service.impl;

import com.google.common.collect.Lists;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.chat.api.pojo.request.ChatExecuteReq;
import com.tencent.supersonic.chat.api.pojo.request.ChatParseReq;
import com.tencent.supersonic.chat.api.pojo.request.ChatQueryDataReq;
import com.tencent.supersonic.chat.server.agent.Agent;
import com.tencent.supersonic.chat.server.executor.ChatExecutor;
import com.tencent.supersonic.chat.server.parser.ChatParser;
import com.tencent.supersonic.chat.server.pojo.ChatExecuteContext;
import com.tencent.supersonic.chat.server.pojo.ChatParseContext;
import com.tencent.supersonic.chat.server.processor.execute.ExecuteResultProcessor;
import com.tencent.supersonic.chat.server.processor.parse.ParseResultProcessor;
import com.tencent.supersonic.chat.server.service.AgentService;
import com.tencent.supersonic.chat.server.service.ChatManageService;
import com.tencent.supersonic.chat.server.service.ChatService;
import com.tencent.supersonic.chat.server.srmExtend.SqlDataPermissionUtil;
import com.tencent.supersonic.chat.server.util.ComponentFactory;
import com.tencent.supersonic.chat.server.util.QueryReqConverter;
import com.tencent.supersonic.common.util.BeanMapper;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.api.pojo.request.DimensionValueReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryDataReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryNLReq;
import com.tencent.supersonic.headless.api.pojo.response.MapResp;
import com.tencent.supersonic.headless.api.pojo.response.ParseResp;
import com.tencent.supersonic.headless.api.pojo.response.QueryResult;
import com.tencent.supersonic.headless.api.pojo.response.SearchResult;
import com.tencent.supersonic.headless.server.facade.service.ChatQueryService;
import com.tencent.supersonic.headless.server.facade.service.RetrieveService;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ChatServiceImpl
implements ChatService {
    private static final Logger log = LoggerFactory.getLogger(ChatServiceImpl.class);
    @Autowired
    private ChatManageService chatManageService;
    @Autowired
    private ChatQueryService chatQueryService;
    @Autowired
    private RetrieveService retrieveService;
    @Autowired
    private AgentService agentService;
    private List<ChatParser> chatParsers = ComponentFactory.getChatParsers();
    private List<ChatExecutor> chatExecutors = ComponentFactory.getChatExecutors();
    private List<ParseResultProcessor> parseResultProcessors = ComponentFactory.getParseProcessors();
    private List<ExecuteResultProcessor> executeResultProcessors = ComponentFactory.getExecuteProcessors();

    @Override
    public List<SearchResult> search(ChatParseReq chatParseReq) {
        ChatParseContext chatParseContext = this.buildParseContext(chatParseReq);
        Agent agent = chatParseContext.getAgent();
        if (!agent.enableSearch()) {
            return Lists.newArrayList();
        }
        QueryNLReq queryNLReq = QueryReqConverter.buildText2SqlQueryReq(chatParseContext);
        return this.retrieveService.retrieve(queryNLReq);
    }

    @Override
    public ParseResp performParsing(ChatParseReq chatParseReq) {
        ParseResp parseResp = new ParseResp(chatParseReq.getChatId(), chatParseReq.getQueryText());
        this.chatManageService.createChatQuery(chatParseReq, parseResp);
        ChatParseContext chatParseContext = this.buildParseContext(chatParseReq);
        SqlDataPermissionUtil.buildPermissionFilterBeforeParse(chatParseContext);
        this.supplyMapInfo(chatParseContext);
        for (ChatParser chatParser : this.chatParsers) {
            chatParser.parse(chatParseContext, parseResp);
        }
        for (ParseResultProcessor processor : this.parseResultProcessors) {
            processor.process(chatParseContext, parseResp);
        }
        chatParseReq.setQueryText(chatParseContext.getQueryText());
        parseResp.setQueryText(chatParseContext.getQueryText());
        this.chatManageService.batchAddParse(chatParseReq, parseResp);
        this.chatManageService.updateParseCostTime(parseResp);
        return parseResp;
    }

    @Override
    public QueryResult performExecution(ChatExecuteReq chatExecuteReq) {
        ChatExecutor chatExecutor;
        QueryResult queryResult = new QueryResult();
        ChatExecuteContext chatExecuteContext = this.buildExecuteContext(chatExecuteReq);
        Iterator<Object> iterator = this.chatExecutors.iterator();
        while (iterator.hasNext() && (queryResult = (chatExecutor = iterator.next()).execute(chatExecuteContext)) == null) {
        }
        if (queryResult != null) {
            for (ExecuteResultProcessor processor : this.executeResultProcessors) {
                processor.process(chatExecuteContext, queryResult);
            }
            this.saveQueryResult(chatExecuteReq, queryResult);
        }
        return queryResult;
    }

    @Override
    public QueryResult parseAndExecute(int chatId, int agentId, String queryText) {
        ChatParseReq chatParseReq = new ChatParseReq();
        chatParseReq.setQueryText(queryText);
        chatParseReq.setChatId(Integer.valueOf(chatId));
        chatParseReq.setAgentId(Integer.valueOf(agentId));
        chatParseReq.setUser(User.getFakeUser());
        ParseResp parseResp = this.performParsing(chatParseReq);
        if (CollectionUtils.isEmpty((Collection)parseResp.getSelectedParses())) {
            log.debug("chatId:{}, agentId:{}, queryText:{}, parseResp.getSelectedParses() is empty", new Object[]{chatId, agentId, queryText});
            return null;
        }
        ChatExecuteReq executeReq = new ChatExecuteReq();
        executeReq.setQueryId(parseResp.getQueryId());
        executeReq.setParseId(((SemanticParseInfo)parseResp.getSelectedParses().get(0)).getId().intValue());
        executeReq.setQueryText(queryText);
        executeReq.setChatId(parseResp.getChatId());
        executeReq.setUser(User.getFakeUser());
        executeReq.setAgentId(Integer.valueOf(agentId));
        executeReq.setSaveAnswer(true);
        return this.performExecution(executeReq);
    }

    private ChatParseContext buildParseContext(ChatParseReq chatParseReq) {
        ChatParseContext chatParseContext = new ChatParseContext();
        BeanMapper.mapper((Object)chatParseReq, (Object)chatParseContext);
        Agent agent = this.agentService.getAgent(chatParseReq.getAgentId());
        chatParseContext.setAgent(agent);
        return chatParseContext;
    }

    private void supplyMapInfo(ChatParseContext chatParseContext) {
        QueryNLReq queryNLReq = QueryReqConverter.buildText2SqlQueryReq(chatParseContext);
        MapResp mapResp = this.chatQueryService.performMapping(queryNLReq);
        chatParseContext.setMapInfo(mapResp.getMapInfo());
    }

    private ChatExecuteContext buildExecuteContext(ChatExecuteReq chatExecuteReq) {
        ChatExecuteContext chatExecuteContext = new ChatExecuteContext();
        BeanMapper.mapper((Object)chatExecuteReq, (Object)chatExecuteContext);
        SemanticParseInfo parseInfo = this.chatManageService.getParseInfo(chatExecuteReq.getQueryId(), chatExecuteReq.getParseId());
        chatExecuteContext.setParseInfo(parseInfo);
        return chatExecuteContext;
    }

    @Override
    public Object queryData(ChatQueryDataReq chatQueryDataReq, User user) throws Exception {
        Integer parseId = chatQueryDataReq.getParseId();
        SemanticParseInfo parseInfo = this.chatManageService.getParseInfo(chatQueryDataReq.getQueryId(), parseId);
        QueryDataReq queryData = new QueryDataReq();
        BeanMapper.mapper((Object)chatQueryDataReq, (Object)queryData);
        queryData.setParseInfo(parseInfo);
        SqlDataPermissionUtil.buildPermissionFilterBeforeQueryData(queryData);
        return this.chatQueryService.executeDirectQuery(queryData, user);
    }

    @Override
    public SemanticParseInfo queryContext(Integer chatId) {
        return this.chatQueryService.queryContext(chatId);
    }

    @Override
    public Object queryDimensionValue(DimensionValueReq dimensionValueReq, User user) throws Exception {
        Integer agentId = dimensionValueReq.getAgentId();
        Agent agent = this.agentService.getAgent(agentId);
        dimensionValueReq.setDataSetIds(agent.getDataSetIds());
        return this.chatQueryService.queryDimensionValue(dimensionValueReq, user);
    }

    public void saveQueryResult(ChatExecuteReq chatExecuteReq, QueryResult queryResult) {
        if (chatExecuteReq.getParseId() > 1) {
            return;
        }
        this.chatManageService.saveQueryResult(chatExecuteReq, queryResult);
    }
}

