/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.chat.api.pojo.request.PluginQueryReq;
import com.tencent.supersonic.chat.server.persistence.dataobject.PluginDO;
import com.tencent.supersonic.chat.server.persistence.repository.PluginRepository;
import com.tencent.supersonic.chat.server.plugin.ChatPlugin;
import com.tencent.supersonic.chat.server.plugin.PluginParseConfig;
import com.tencent.supersonic.chat.server.plugin.event.PluginAddEvent;
import com.tencent.supersonic.chat.server.plugin.event.PluginDelEvent;
import com.tencent.supersonic.chat.server.plugin.event.PluginUpdateEvent;
import com.tencent.supersonic.chat.server.service.PluginService;
import com.tencent.supersonic.common.util.JsonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PluginServiceImpl
implements PluginService {
    private static final Logger log = LoggerFactory.getLogger(PluginServiceImpl.class);
    private PluginRepository pluginRepository;
    private ApplicationEventPublisher publisher;

    public PluginServiceImpl(PluginRepository pluginRepository, ApplicationEventPublisher publisher) {
        this.pluginRepository = pluginRepository;
        this.publisher = publisher;
    }

    @Override
    public synchronized void createPlugin(ChatPlugin plugin, User user) {
        PluginDO pluginDO = this.convert(plugin, user);
        this.pluginRepository.createPlugin(pluginDO);
        List<ChatPlugin> plugins = this.getPluginList();
        this.publisher.publishEvent((ApplicationEvent)new PluginAddEvent(this, plugins.get(plugins.size() - 1)));
    }

    @Override
    public void updatePlugin(ChatPlugin plugin, User user) {
        Long id = plugin.getId();
        PluginDO pluginDO = this.pluginRepository.getPlugin(id);
        ChatPlugin oldPlugin = this.convert(pluginDO);
        this.convert(plugin, pluginDO, user);
        this.pluginRepository.updatePlugin(pluginDO);
        this.publisher.publishEvent((ApplicationEvent)new PluginUpdateEvent(this, oldPlugin, plugin));
    }

    @Override
    public void deletePlugin(Long id) {
        PluginDO pluginDO = this.pluginRepository.getPlugin(id);
        if (pluginDO != null) {
            this.pluginRepository.deletePlugin(id);
            this.publisher.publishEvent((ApplicationEvent)new PluginDelEvent(this, this.convert(pluginDO)));
        }
    }

    @Override
    public List<ChatPlugin> getPluginList() {
        ArrayList plugins = Lists.newArrayList();
        List<PluginDO> pluginDOS = this.pluginRepository.getPlugins();
        if (CollectionUtils.isEmpty(pluginDOS)) {
            return plugins;
        }
        return pluginDOS.stream().map(this::convert).collect(Collectors.toList());
    }

    @Override
    public List<ChatPlugin> fetchPluginDOs(String queryText, String type) {
        List<PluginDO> pluginDOS = this.pluginRepository.fetchPluginDOs(queryText, type);
        return this.convertList(pluginDOS);
    }

    @Override
    public List<ChatPlugin> query(PluginQueryReq pluginQueryReq) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)pluginQueryReq.getType())) {
            queryWrapper.lambda().eq(PluginDO::getType, (Object)pluginQueryReq.getType());
        }
        if (StringUtils.isNotBlank((CharSequence)pluginQueryReq.getDataSet())) {
            queryWrapper.lambda().like(PluginDO::getDataSet, (Object)pluginQueryReq.getDataSet());
        }
        if (StringUtils.isNotBlank((CharSequence)pluginQueryReq.getParseMode())) {
            queryWrapper.lambda().eq(PluginDO::getParseMode, (Object)pluginQueryReq.getParseMode());
        }
        if (StringUtils.isNotBlank((CharSequence)pluginQueryReq.getName())) {
            queryWrapper.lambda().like(PluginDO::getName, (Object)pluginQueryReq.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)pluginQueryReq.getPattern())) {
            queryWrapper.lambda().like(PluginDO::getPattern, (Object)pluginQueryReq.getPattern());
        }
        if (StringUtils.isNotBlank((CharSequence)pluginQueryReq.getCreatedBy())) {
            queryWrapper.lambda().eq(PluginDO::getCreatedBy, (Object)pluginQueryReq.getCreatedBy());
        }
        List<PluginDO> pluginDOS = this.pluginRepository.query((QueryWrapper<PluginDO>)queryWrapper);
        if (StringUtils.isNotBlank((CharSequence)pluginQueryReq.getPattern())) {
            pluginDOS = pluginDOS.stream().filter(pluginDO -> pluginDO.getPattern().contains(pluginQueryReq.getPattern()) || pluginDO.getName() != null && pluginDO.getName().contains(pluginQueryReq.getPattern())).collect(Collectors.toList());
        }
        return this.convertList(pluginDOS);
    }

    @Override
    public Optional<ChatPlugin> getPluginByName(String name) {
        log.info("name:{}", (Object)name);
        return this.getPluginList().stream().filter(plugin -> {
            PluginParseConfig functionCallConfig = this.getPluginParseConfig((ChatPlugin)((Object)plugin));
            if (functionCallConfig == null) {
                return false;
            }
            return functionCallConfig.getName().equalsIgnoreCase(name);
        }).findFirst();
    }

    private PluginParseConfig getPluginParseConfig(ChatPlugin plugin) {
        if (StringUtils.isBlank((CharSequence)plugin.getParseModeConfig())) {
            return null;
        }
        PluginParseConfig functionCallConfig = (PluginParseConfig)JsonUtil.toObject((String)plugin.getParseModeConfig(), PluginParseConfig.class);
        if (Objects.isNull(functionCallConfig) || StringUtils.isEmpty((CharSequence)functionCallConfig.getName())) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)functionCallConfig.getName())) {
            return null;
        }
        return functionCallConfig;
    }

    @Override
    public List<ChatPlugin> queryWithAuthCheck(PluginQueryReq pluginQueryReq, User user) {
        return this.authCheck(this.query(pluginQueryReq), user);
    }

    @Override
    public Map<String, ChatPlugin> getNameToPlugin() {
        List<ChatPlugin> pluginList = this.getPluginList();
        return pluginList.stream().filter(plugin -> {
            PluginParseConfig functionCallConfig = this.getPluginParseConfig((ChatPlugin)((Object)plugin));
            return functionCallConfig != null;
        }).collect(Collectors.toMap(a -> {
            PluginParseConfig functionCallConfig = (PluginParseConfig)JsonUtil.toObject((String)a.getParseModeConfig(), PluginParseConfig.class);
            return functionCallConfig.getName();
        }, a -> a, (k1, k2) -> k1));
    }

    private List<ChatPlugin> authCheck(List<ChatPlugin> plugins, User user) {
        return plugins;
    }

    public ChatPlugin convert(PluginDO pluginDO) {
        ChatPlugin plugin = new ChatPlugin();
        BeanUtils.copyProperties((Object)pluginDO, (Object)((Object)plugin));
        if (StringUtils.isNotBlank((CharSequence)pluginDO.getDataSet())) {
            plugin.setDataSetList(Arrays.stream(pluginDO.getDataSet().split(",")).map(Long::parseLong).collect(Collectors.toList()));
        }
        return plugin;
    }

    public PluginDO convert(ChatPlugin plugin, User user) {
        PluginDO pluginDO = new PluginDO();
        BeanUtils.copyProperties((Object)((Object)plugin), (Object)pluginDO);
        pluginDO.setCreatedAt(new Date());
        pluginDO.setCreatedBy(user.getName());
        pluginDO.setUpdatedAt(new Date());
        pluginDO.setUpdatedBy(user.getName());
        pluginDO.setDataSet(StringUtils.join(plugin.getDataSetList(), (String)","));
        return pluginDO;
    }

    public PluginDO convert(ChatPlugin plugin, PluginDO pluginDO, User user) {
        BeanUtils.copyProperties((Object)((Object)plugin), (Object)pluginDO);
        pluginDO.setUpdatedAt(new Date());
        pluginDO.setUpdatedBy(user.getName());
        pluginDO.setDataSet(StringUtils.join(plugin.getDataSetList(), (String)","));
        return pluginDO;
    }

    public List<ChatPlugin> convertList(List<PluginDO> pluginDOS) {
        if (!CollectionUtils.isEmpty(pluginDOS)) {
            return pluginDOS.stream().map(this::convert).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }
}

