/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.util;

import com.tencent.supersonic.chat.server.executor.ChatExecutor;
import com.tencent.supersonic.chat.server.parser.ChatParser;
import com.tencent.supersonic.chat.server.plugin.recognize.PluginRecognizer;
import com.tencent.supersonic.chat.server.processor.execute.ExecuteResultProcessor;
import com.tencent.supersonic.chat.server.processor.parse.ParseResultProcessor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.SpringFactoriesLoader;

public class ComponentFactory {
    private static final Logger log = LoggerFactory.getLogger(ComponentFactory.class);
    private static List<ParseResultProcessor> parseProcessors = new ArrayList<ParseResultProcessor>();
    private static List<ExecuteResultProcessor> executeProcessors = new ArrayList<ExecuteResultProcessor>();
    private static List<ChatParser> chatParsers = new ArrayList<ChatParser>();
    private static List<ChatExecutor> chatExecutors = new ArrayList<ChatExecutor>();
    private static List<PluginRecognizer> pluginRecognizers = new ArrayList<PluginRecognizer>();

    public static List<ParseResultProcessor> getParseProcessors() {
        return CollectionUtils.isEmpty(parseProcessors) ? ComponentFactory.init(ParseResultProcessor.class, parseProcessors) : parseProcessors;
    }

    public static List<ExecuteResultProcessor> getExecuteProcessors() {
        return CollectionUtils.isEmpty(executeProcessors) ? ComponentFactory.init(ExecuteResultProcessor.class, executeProcessors) : executeProcessors;
    }

    public static List<ChatParser> getChatParsers() {
        return CollectionUtils.isEmpty(chatParsers) ? ComponentFactory.init(ChatParser.class, chatParsers) : chatParsers;
    }

    public static List<ChatExecutor> getChatExecutors() {
        return CollectionUtils.isEmpty(chatExecutors) ? ComponentFactory.init(ChatExecutor.class, chatExecutors) : chatExecutors;
    }

    public static List<PluginRecognizer> getPluginRecognizers() {
        return CollectionUtils.isEmpty(pluginRecognizers) ? ComponentFactory.init(PluginRecognizer.class, pluginRecognizers) : pluginRecognizers;
    }

    private static <T> List<T> init(Class<T> factoryType, List list) {
        list.addAll(SpringFactoriesLoader.loadFactories(factoryType, (ClassLoader)Thread.currentThread().getContextClassLoader()));
        return list;
    }

    private static <T> T init(Class<T> factoryType) {
        return (T)SpringFactoriesLoader.loadFactories(factoryType, (ClassLoader)Thread.currentThread().getContextClassLoader()).get(0);
    }
}

