/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.persistence.repository.impl;

import com.tencent.supersonic.chat.server.persistence.dataobject.ChatDO;
import com.tencent.supersonic.chat.server.persistence.dataobject.QueryDO;
import com.tencent.supersonic.chat.server.persistence.mapper.ChatMapper;
import com.tencent.supersonic.chat.server.persistence.repository.ChatRepository;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;

@Repository
@Primary
public class ChatRepositoryImpl
implements ChatRepository {
    private static final Logger log = LoggerFactory.getLogger(ChatRepositoryImpl.class);
    private final ChatMapper chatMapper;

    public ChatRepositoryImpl(ChatMapper chatMapper) {
        this.chatMapper = chatMapper;
    }

    @Override
    public Long createChat(ChatDO chatDO) {
        this.chatMapper.createChat(chatDO);
        return chatDO.getChatId();
    }

    @Override
    public List<ChatDO> getAll(String creator, Integer agentId) {
        return this.chatMapper.getAll(creator, agentId);
    }

    @Override
    public Boolean updateChatName(Long chatId, String chatName, String lastTime, String creator) {
        return this.chatMapper.updateChatName(chatId, chatName, lastTime, creator);
    }

    @Override
    public Boolean updateLastQuestion(Long chatId, String lastQuestion, String lastTime) {
        return this.chatMapper.updateLastQuestion(chatId, lastQuestion, lastTime);
    }

    @Override
    public Boolean updateConversionIsTop(Long chatId, int isTop) {
        return this.chatMapper.updateConversionIsTop(chatId, isTop);
    }

    @Override
    public boolean updateFeedback(QueryDO queryDO) {
        return this.chatMapper.updateFeedback(queryDO);
    }

    @Override
    public Boolean deleteChat(Long chatId, String userName) {
        return this.chatMapper.deleteChat(chatId, userName);
    }
}

