/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.persistence.repository.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.tencent.supersonic.chat.server.persistence.dataobject.PluginDO;
import com.tencent.supersonic.chat.server.persistence.mapper.PluginDOMapper;
import com.tencent.supersonic.chat.server.persistence.repository.PluginRepository;
import com.tencent.supersonic.common.util.ContextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class PluginRepositoryImpl
implements PluginRepository {
    private static final Logger log = LoggerFactory.getLogger(PluginRepositoryImpl.class);
    private PluginDOMapper pluginDOMapper;

    public PluginRepositoryImpl(PluginDOMapper pluginDOMapper) {
        this.pluginDOMapper = pluginDOMapper;
    }

    @Override
    public List<PluginDO> getPlugins() {
        return this.pluginDOMapper.selectList((Wrapper)new QueryWrapper());
    }

    @Override
    public List<PluginDO> fetchPluginDOs(String queryText, String type) {
        ArrayList<PluginDO> pluginDOList = new ArrayList<PluginDO>();
        PluginRepository pluginRepository = (PluginRepository)ContextUtils.getBean(PluginRepository.class);
        List<PluginDO> pluginDOS = pluginRepository.getPlugins();
        for (PluginDO pluginDO : pluginDOS) {
            Pattern pluginPattern;
            Matcher pluginMatcher;
            String pattern = pluginDO.getPattern();
            if (!StringUtils.isNotEmpty((CharSequence)pattern) || !(pluginMatcher = (pluginPattern = Pattern.compile(pattern)).matcher(queryText)).find()) continue;
            log.info("pluginMatcher.find() is true, queryText:{}", (Object)queryText);
            log.info("pluginDO:{}", (Object)pluginDO);
            pluginDOList.add(pluginDO);
        }
        return pluginDOList;
    }

    @Override
    public void createPlugin(PluginDO pluginDO) {
        this.pluginDOMapper.insert(pluginDO);
    }

    @Override
    public void updatePlugin(PluginDO pluginDO) {
        this.pluginDOMapper.updateById(pluginDO);
    }

    @Override
    public PluginDO getPlugin(Long id) {
        return (PluginDO)this.pluginDOMapper.selectById(id);
    }

    @Override
    public List<PluginDO> query(QueryWrapper<PluginDO> queryWrapper) {
        return this.pluginDOMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public void deletePlugin(Long id) {
        this.pluginDOMapper.deleteById(id);
    }
}

