/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.processor.parse;

import com.tencent.supersonic.chat.server.pojo.ParseContext;
import com.tencent.supersonic.chat.server.processor.parse.ParseResultProcessor;
import com.tencent.supersonic.common.util.ContextUtils;
import com.tencent.supersonic.headless.api.pojo.DataSetSchema;
import com.tencent.supersonic.headless.api.pojo.EntityInfo;
import com.tencent.supersonic.headless.api.pojo.response.ParseResp;
import com.tencent.supersonic.headless.chat.query.QueryManager;
import com.tencent.supersonic.headless.server.facade.service.SemanticLayerService;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class EntityInfoProcessor
implements ParseResultProcessor {
    @Override
    public void process(ParseContext parseContext, ParseResp parseResp) {
        List selectedParses = parseResp.getSelectedParses();
        if (CollectionUtils.isEmpty((Collection)selectedParses)) {
            return;
        }
        selectedParses.forEach(parseInfo -> {
            String queryMode = parseInfo.getQueryMode();
            if (QueryManager.containsRuleQuery((String)queryMode) || "PLAIN".equals(queryMode)) {
                return;
            }
            SemanticLayerService semanticService = (SemanticLayerService)ContextUtils.getBean(SemanticLayerService.class);
            DataSetSchema dataSetSchema = semanticService.getDataSetSchema(parseInfo.getDataSetId());
            EntityInfo entityInfo = semanticService.getEntityInfo(parseInfo, dataSetSchema, parseContext.getUser());
            if (QueryManager.isTagQuery((String)queryMode) || QueryManager.isMetricQuery((String)queryMode)) {
                parseInfo.setEntityInfo(entityInfo);
            }
        });
    }
}

