/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.rest;

import com.github.pagehelper.PageInfo;
import com.tencent.supersonic.auth.api.authentication.utils.UserHolder;
import com.tencent.supersonic.chat.api.pojo.request.PageQueryInfoReq;
import com.tencent.supersonic.chat.api.pojo.response.QueryResp;
import com.tencent.supersonic.chat.api.pojo.response.ShowCaseResp;
import com.tencent.supersonic.chat.server.persistence.dataobject.ChatDO;
import com.tencent.supersonic.chat.server.service.ChatManageService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/chat/manage", "/openapi/chat/manage"})
public class ChatController {
    @Autowired
    private ChatManageService chatService;

    @PostMapping(value={"/save"})
    public Boolean save(@RequestParam(value="chatName") String chatName, @RequestParam(value="agentId", required=false) Integer agentId, HttpServletRequest request, HttpServletResponse response) {
        this.chatService.addChat(UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response), chatName, agentId);
        return true;
    }

    @GetMapping(value={"/getAll"})
    public List<ChatDO> getAllConversions(@RequestParam(value="agentId", required=false) Integer agentId, HttpServletRequest request, HttpServletResponse response) {
        String userName = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response).getName();
        return this.chatService.getAll(userName, agentId);
    }

    @PostMapping(value={"/delete"})
    public Boolean deleteConversion(@RequestParam(value="chatId") long chatId, HttpServletRequest request, HttpServletResponse response) {
        String userName = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response).getName();
        return this.chatService.deleteChat(chatId, userName);
    }

    @PostMapping(value={"/updateChatName"})
    public Boolean updateConversionName(@RequestParam(value="chatId") Long chatId, @RequestParam(value="chatName") String chatName, HttpServletRequest request, HttpServletResponse response) {
        String userName = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response).getName();
        return this.chatService.updateChatName(chatId, chatName, userName);
    }

    @PostMapping(value={"/updateQAFeedback"})
    public Boolean updateQAFeedback(@RequestParam(value="id") Integer id, @RequestParam(value="score") Integer score, @RequestParam(value="feedback", required=false) String feedback) {
        return this.chatService.updateFeedback(id, score, feedback);
    }

    @PostMapping(value={"/updateChatIsTop"})
    public Boolean updateConversionIsTop(@RequestParam(value="chatId") Long chatId, @RequestParam(value="isTop") int isTop) {
        return this.chatService.updateChatIsTop(chatId, isTop);
    }

    @PostMapping(value={"/pageQueryInfo"})
    public PageInfo<QueryResp> pageQueryInfo(@RequestBody PageQueryInfoReq pageQueryInfoCommand, @RequestParam(value="chatId") long chatId, HttpServletRequest request, HttpServletResponse response) {
        pageQueryInfoCommand.setUserName(UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response).getName());
        return this.chatService.queryInfo(pageQueryInfoCommand, chatId);
    }

    @GetMapping(value={"/getChatQuery/{queryId}"})
    public QueryResp getChatQuery(@PathVariable(value="queryId") Long queryId) {
        return this.chatService.getChatQuery(queryId);
    }

    @PostMapping(value={"/queryShowCase"})
    public ShowCaseResp queryShowCase(@RequestBody PageQueryInfoReq pageQueryInfoCommand, @RequestParam(value="agentId") int agentId) {
        return this.chatService.queryShowCase(pageQueryInfoCommand, agentId);
    }
}

