/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.rest;

import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.utils.UserHolder;
import com.tencent.supersonic.chat.api.pojo.request.ChatExecuteReq;
import com.tencent.supersonic.chat.api.pojo.request.ChatParseReq;
import com.tencent.supersonic.chat.api.pojo.request.ChatQueryDataReq;
import com.tencent.supersonic.chat.server.service.ChatQueryService;
import com.tencent.supersonic.common.pojo.exception.InvalidArgumentException;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.api.pojo.request.DimensionValueReq;
import com.tencent.supersonic.headless.api.pojo.response.ParseResp;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/chat/query", "/openapi/chat/query"})
public class ChatQueryController {
    @Autowired
    private ChatQueryService chatQueryService;

    @PostMapping(value={"search"})
    public Object search(@RequestBody ChatParseReq chatParseReq, HttpServletRequest request, HttpServletResponse response) {
        chatParseReq.setUser(UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response));
        return this.chatQueryService.search(chatParseReq);
    }

    @PostMapping(value={"parse"})
    public Object parse(@RequestBody ChatParseReq chatParseReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        chatParseReq.setUser(UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response));
        return this.chatQueryService.performParsing(chatParseReq);
    }

    @PostMapping(value={"execute"})
    public Object execute(@RequestBody ChatExecuteReq chatExecuteReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        chatExecuteReq.setUser(UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response));
        return this.chatQueryService.performExecution(chatExecuteReq);
    }

    @PostMapping(value={"/"})
    public Object query(@RequestBody ChatParseReq chatParseReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        chatParseReq.setUser(user);
        ParseResp parseResp = this.chatQueryService.performParsing(chatParseReq);
        if (CollectionUtils.isEmpty((Collection)parseResp.getSelectedParses())) {
            throw new InvalidArgumentException("parser error,no selectedParses");
        }
        SemanticParseInfo semanticParseInfo = (SemanticParseInfo)parseResp.getSelectedParses().get(0);
        ChatExecuteReq chatExecuteReq = ChatExecuteReq.builder().build();
        BeanUtils.copyProperties((Object)chatParseReq, (Object)chatExecuteReq);
        chatExecuteReq.setQueryId(parseResp.getQueryId());
        chatExecuteReq.setParseId(semanticParseInfo.getId().intValue());
        return this.chatQueryService.performExecution(chatExecuteReq);
    }

    @PostMapping(value={"queryData"})
    public Object queryData(@RequestBody ChatQueryDataReq chatQueryDataReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        chatQueryDataReq.setUser(UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response));
        return this.chatQueryService.queryData(chatQueryDataReq, UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response));
    }

    @PostMapping(value={"queryDimensionValue"})
    public Object queryDimensionValue(@RequestBody @Valid DimensionValueReq dimensionValueReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.chatQueryService.queryDimensionValue(dimensionValueReq, UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response));
    }
}

