/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.service.impl;

import com.google.common.collect.Lists;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.chat.api.pojo.request.ChatExecuteReq;
import com.tencent.supersonic.chat.api.pojo.request.ChatParseReq;
import com.tencent.supersonic.chat.api.pojo.request.ChatQueryDataReq;
import com.tencent.supersonic.chat.server.agent.Agent;
import com.tencent.supersonic.chat.server.executor.ChatQueryExecutor;
import com.tencent.supersonic.chat.server.parser.ChatQueryParser;
import com.tencent.supersonic.chat.server.pojo.ExecuteContext;
import com.tencent.supersonic.chat.server.pojo.ParseContext;
import com.tencent.supersonic.chat.server.processor.execute.ExecuteResultProcessor;
import com.tencent.supersonic.chat.server.processor.parse.ParseResultProcessor;
import com.tencent.supersonic.chat.server.service.AgentService;
import com.tencent.supersonic.chat.server.service.ChatManageService;
import com.tencent.supersonic.chat.server.service.ChatQueryService;
import com.tencent.supersonic.chat.server.srmExtend.SqlDataPermissionUtil;
import com.tencent.supersonic.chat.server.util.ComponentFactory;
import com.tencent.supersonic.chat.server.util.QueryReqConverter;
import com.tencent.supersonic.common.jsqlparser.FieldExpression;
import com.tencent.supersonic.common.jsqlparser.SqlAddHelper;
import com.tencent.supersonic.common.jsqlparser.SqlRemoveHelper;
import com.tencent.supersonic.common.jsqlparser.SqlReplaceHelper;
import com.tencent.supersonic.common.jsqlparser.SqlSelectHelper;
import com.tencent.supersonic.common.pojo.enums.FilterOperatorEnum;
import com.tencent.supersonic.common.pojo.enums.TimeDimensionEnum;
import com.tencent.supersonic.common.util.BeanMapper;
import com.tencent.supersonic.common.util.ContextUtils;
import com.tencent.supersonic.common.util.DateUtils;
import com.tencent.supersonic.common.util.JsonUtil;
import com.tencent.supersonic.headless.api.pojo.DataSetSchema;
import com.tencent.supersonic.headless.api.pojo.EntityInfo;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.api.pojo.request.DimensionValueReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryFilter;
import com.tencent.supersonic.headless.api.pojo.request.QueryNLReq;
import com.tencent.supersonic.headless.api.pojo.request.SemanticQueryReq;
import com.tencent.supersonic.headless.api.pojo.response.MapResp;
import com.tencent.supersonic.headless.api.pojo.response.ParseResp;
import com.tencent.supersonic.headless.api.pojo.response.QueryResult;
import com.tencent.supersonic.headless.api.pojo.response.QueryState;
import com.tencent.supersonic.headless.api.pojo.response.SearchResult;
import com.tencent.supersonic.headless.api.pojo.response.SemanticQueryResp;
import com.tencent.supersonic.headless.api.pojo.response.SemanticTranslateResp;
import com.tencent.supersonic.headless.chat.query.QueryManager;
import com.tencent.supersonic.headless.chat.query.SemanticQuery;
import com.tencent.supersonic.headless.server.facade.service.ChatLayerService;
import com.tencent.supersonic.headless.server.facade.service.RetrieveService;
import com.tencent.supersonic.headless.server.facade.service.SemanticLayerService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.ParenthesedExpressionList;
import net.sf.jsqlparser.schema.Column;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ChatQueryServiceImpl
implements ChatQueryService {
    private static final Logger log = LoggerFactory.getLogger(ChatQueryServiceImpl.class);
    @Autowired
    private ChatManageService chatManageService;
    @Autowired
    private ChatLayerService chatLayerService;
    @Autowired
    private SemanticLayerService semanticLayerService;
    @Autowired
    private RetrieveService retrieveService;
    @Autowired
    private AgentService agentService;
    private List<ChatQueryParser> chatQueryParsers = ComponentFactory.getChatParsers();
    private List<ChatQueryExecutor> chatQueryExecutors = ComponentFactory.getChatExecutors();
    private List<ParseResultProcessor> parseResultProcessors = ComponentFactory.getParseProcessors();
    private List<ExecuteResultProcessor> executeResultProcessors = ComponentFactory.getExecuteProcessors();

    @Override
    public List<SearchResult> search(ChatParseReq chatParseReq) {
        ParseContext parseContext = this.buildParseContext(chatParseReq);
        Agent agent = parseContext.getAgent();
        if (!agent.enableSearch()) {
            return Lists.newArrayList();
        }
        QueryNLReq queryNLReq = QueryReqConverter.buildText2SqlQueryReq(parseContext);
        return this.retrieveService.retrieve(queryNLReq);
    }

    @Override
    public ParseResp performParsing(ChatParseReq chatParseReq) {
        ParseResp parseResp = new ParseResp(chatParseReq.getQueryText());
        this.chatManageService.createChatQuery(chatParseReq, parseResp);
        ParseContext parseContext = this.buildParseContext(chatParseReq);
        SqlDataPermissionUtil.buildPermissionFilterBeforeParse(parseContext);
        this.supplyMapInfo(parseContext);
        for (ChatQueryParser chatQueryParser : this.chatQueryParsers) {
            chatQueryParser.parse(parseContext, parseResp);
        }
        for (ParseResultProcessor processor : this.parseResultProcessors) {
            processor.process(parseContext, parseResp);
        }
        chatParseReq.setQueryText(parseContext.getQueryText());
        parseResp.setQueryText(parseContext.getQueryText());
        this.chatManageService.batchAddParse(chatParseReq, parseResp);
        this.chatManageService.updateParseCostTime(parseResp);
        return parseResp;
    }

    @Override
    public QueryResult performExecution(ChatExecuteReq chatExecuteReq) {
        ChatQueryExecutor chatQueryExecutor;
        QueryResult queryResult = new QueryResult();
        ExecuteContext executeContext = this.buildExecuteContext(chatExecuteReq);
        Iterator<Object> iterator = this.chatQueryExecutors.iterator();
        while (iterator.hasNext() && (queryResult = (chatQueryExecutor = iterator.next()).execute(executeContext)) == null) {
        }
        if (queryResult != null) {
            for (ExecuteResultProcessor processor : this.executeResultProcessors) {
                processor.process(executeContext, queryResult);
            }
            this.saveQueryResult(chatExecuteReq, queryResult);
        }
        return queryResult;
    }

    @Override
    public QueryResult parseAndExecute(int chatId, int agentId, String queryText) {
        ChatParseReq chatParseReq = new ChatParseReq();
        chatParseReq.setQueryText(queryText);
        chatParseReq.setChatId(Integer.valueOf(chatId));
        chatParseReq.setAgentId(Integer.valueOf(agentId));
        chatParseReq.setUser(User.getFakeUser());
        ParseResp parseResp = this.performParsing(chatParseReq);
        if (CollectionUtils.isEmpty((Collection)parseResp.getSelectedParses())) {
            log.debug("chatId:{}, agentId:{}, queryText:{}, parseResp.getSelectedParses() is empty", new Object[]{chatId, agentId, queryText});
            return null;
        }
        ChatExecuteReq executeReq = new ChatExecuteReq();
        executeReq.setQueryId(parseResp.getQueryId());
        executeReq.setParseId(((SemanticParseInfo)parseResp.getSelectedParses().get(0)).getId().intValue());
        executeReq.setQueryText(queryText);
        executeReq.setChatId(Integer.valueOf(chatId));
        executeReq.setUser(User.getFakeUser());
        executeReq.setAgentId(Integer.valueOf(agentId));
        executeReq.setSaveAnswer(true);
        return this.performExecution(executeReq);
    }

    private ParseContext buildParseContext(ChatParseReq chatParseReq) {
        ParseContext parseContext = new ParseContext();
        BeanMapper.mapper((Object)chatParseReq, (Object)parseContext);
        Agent agent = this.agentService.getAgent(chatParseReq.getAgentId());
        parseContext.setAgent(agent);
        return parseContext;
    }

    private void supplyMapInfo(ParseContext parseContext) {
        QueryNLReq queryNLReq = QueryReqConverter.buildText2SqlQueryReq(parseContext);
        MapResp mapResp = this.chatLayerService.performMapping(queryNLReq);
        parseContext.setMapInfo(mapResp.getMapInfo());
    }

    private ExecuteContext buildExecuteContext(ChatExecuteReq chatExecuteReq) {
        ExecuteContext executeContext = new ExecuteContext();
        BeanMapper.mapper((Object)chatExecuteReq, (Object)executeContext);
        SemanticParseInfo parseInfo = this.chatManageService.getParseInfo(chatExecuteReq.getQueryId(), chatExecuteReq.getParseId());
        Agent agent = this.agentService.getAgent(chatExecuteReq.getAgentId());
        executeContext.setAgent(agent);
        executeContext.setParseInfo(parseInfo);
        return executeContext;
    }

    @Override
    public Object queryData(ChatQueryDataReq chatQueryDataReq, User user) throws Exception {
        String correctorSql;
        Integer parseId = chatQueryDataReq.getParseId();
        SemanticParseInfo parseInfo = this.chatManageService.getParseInfo(chatQueryDataReq.getQueryId(), parseId);
        parseInfo = this.mergeSemanticParseInfo(parseInfo, chatQueryDataReq);
        DataSetSchema dataSetSchema = this.semanticLayerService.getDataSetSchema(parseInfo.getDataSetId());
        SemanticQuery semanticQuery = QueryManager.createQuery((String)parseInfo.getQueryMode());
        semanticQuery.setParseInfo(parseInfo);
        List<String> fields = new ArrayList<String>();
        if (Objects.nonNull(parseInfo.getSqlInfo()) && StringUtils.isNotBlank((CharSequence)parseInfo.getSqlInfo().getCorrectedS2SQL())) {
            correctorSql = parseInfo.getSqlInfo().getCorrectedS2SQL();
            fields = SqlSelectHelper.getAllFields((String)correctorSql);
        }
        if ("LLM_S2SQL".equalsIgnoreCase(parseInfo.getQueryMode()) && this.checkMetricReplace(fields, chatQueryDataReq.getMetrics())) {
            log.info("llm begin replace metrics!");
            SchemaElement metricToReplace = (SchemaElement)chatQueryDataReq.getMetrics().iterator().next();
            this.replaceMetrics(parseInfo, metricToReplace);
        } else if ("LLM_S2SQL".equalsIgnoreCase(parseInfo.getQueryMode())) {
            log.info("llm begin revise filters!");
            correctorSql = this.reviseCorrectS2SQL(chatQueryDataReq, parseInfo);
            parseInfo.getSqlInfo().setCorrectedS2SQL(correctorSql);
            semanticQuery.setParseInfo(parseInfo);
            SemanticQueryReq semanticQueryReq = semanticQuery.buildSemanticQueryReq();
            SemanticTranslateResp explain = this.semanticLayerService.translate(semanticQueryReq, user);
            parseInfo.getSqlInfo().setQuerySQL(explain.getQuerySQL());
        } else {
            log.info("rule begin replace metrics and revise filters!");
            this.validFilter(semanticQuery.getParseInfo().getDimensionFilters());
            this.validFilter(semanticQuery.getParseInfo().getMetricFilters());
            semanticQuery.initS2Sql(dataSetSchema, user);
        }
        SemanticQueryReq semanticQueryReq = semanticQuery.buildSemanticQueryReq();
        QueryResult queryResult = this.doExecution(semanticQueryReq, semanticQuery.getParseInfo(), user);
        queryResult.setChatContext(semanticQuery.getParseInfo());
        SemanticLayerService semanticService = (SemanticLayerService)ContextUtils.getBean(SemanticLayerService.class);
        EntityInfo entityInfo = semanticService.getEntityInfo(parseInfo, dataSetSchema, user);
        queryResult.setEntityInfo(entityInfo);
        return queryResult;
    }

    private boolean checkMetricReplace(List<String> oriFields, Set<SchemaElement> metrics) {
        if (CollectionUtils.isEmpty(oriFields)) {
            return false;
        }
        if (CollectionUtils.isEmpty(metrics)) {
            return false;
        }
        List metricNames = metrics.stream().map(SchemaElement::getName).collect(Collectors.toList());
        return !oriFields.containsAll(metricNames);
    }

    private String reviseCorrectS2SQL(ChatQueryDataReq queryData, SemanticParseInfo parseInfo) {
        HashMap<String, Map<String, String>> filedNameToValueMap = new HashMap<String, Map<String, String>>();
        HashMap havingFiledNameToValueMap = new HashMap();
        String correctorSql = parseInfo.getSqlInfo().getCorrectedS2SQL();
        log.info("correctorSql before replacing:{}", (Object)correctorSql);
        List whereExpressionList = SqlSelectHelper.getWhereExpressions((String)correctorSql);
        List havingExpressionList = SqlSelectHelper.getHavingExpressions((String)correctorSql);
        ArrayList<Expression> addWhereConditions = new ArrayList<Expression>();
        ArrayList<Expression> addHavingConditions = new ArrayList<Expression>();
        HashSet<String> removeWhereFieldNames = new HashSet<String>();
        HashSet<String> removeHavingFieldNames = new HashSet<String>();
        this.updateFilters(whereExpressionList, queryData.getDimensionFilters(), parseInfo.getDimensionFilters(), addWhereConditions, removeWhereFieldNames);
        this.updateDateInfo(queryData, parseInfo, filedNameToValueMap, whereExpressionList, addWhereConditions, removeWhereFieldNames);
        correctorSql = SqlReplaceHelper.replaceValue((String)correctorSql, filedNameToValueMap);
        correctorSql = SqlRemoveHelper.removeWhereCondition((String)correctorSql, removeWhereFieldNames);
        this.updateFilters(havingExpressionList, queryData.getDimensionFilters(), parseInfo.getDimensionFilters(), addHavingConditions, removeHavingFieldNames);
        correctorSql = SqlReplaceHelper.replaceHavingValue((String)correctorSql, havingFiledNameToValueMap);
        correctorSql = SqlRemoveHelper.removeHavingCondition((String)correctorSql, removeHavingFieldNames);
        correctorSql = SqlAddHelper.addWhere((String)correctorSql, addWhereConditions);
        correctorSql = SqlAddHelper.addHaving((String)correctorSql, addHavingConditions);
        log.info("correctorSql after replacing:{}", (Object)correctorSql);
        return correctorSql;
    }

    private void replaceMetrics(SemanticParseInfo parseInfo, SchemaElement metric) {
        List oriMetrics = parseInfo.getMetrics().stream().map(SchemaElement::getName).collect(Collectors.toList());
        String correctorSql = parseInfo.getSqlInfo().getCorrectedS2SQL();
        log.info("before replaceMetrics:{}", (Object)correctorSql);
        log.info("filteredMetrics:{},metrics:{}", oriMetrics, (Object)metric);
        HashMap<String, Pair> fieldMap = new HashMap<String, Pair>();
        if (!CollectionUtils.isEmpty(oriMetrics) && !oriMetrics.contains(metric.getName())) {
            fieldMap.put((String)oriMetrics.get(0), Pair.of((Object)metric.getName(), (Object)metric.getDefaultAgg()));
            correctorSql = SqlReplaceHelper.replaceAggFields((String)correctorSql, fieldMap);
        }
        log.info("after replaceMetrics:{}", (Object)correctorSql);
        parseInfo.getSqlInfo().setCorrectedS2SQL(correctorSql);
    }

    private QueryResult doExecution(SemanticQueryReq semanticQueryReq, SemanticParseInfo parseInfo, User user) throws Exception {
        SemanticQueryResp queryResp = this.semanticLayerService.queryByReq(semanticQueryReq, user);
        QueryResult queryResult = new QueryResult();
        if (queryResp != null) {
            queryResult.setQueryAuthorization(queryResp.getQueryAuthorization());
        }
        String sql = queryResp == null ? null : queryResp.getSql();
        List resultList = queryResp == null ? new ArrayList() : queryResp.getResultList();
        List columns = queryResp == null ? new ArrayList() : queryResp.getColumns();
        queryResult.setQuerySql(sql);
        queryResult.setQueryResults(resultList);
        queryResult.setQueryColumns(columns);
        queryResult.setQueryMode(parseInfo.getQueryMode());
        queryResult.setQueryState(QueryState.SUCCESS);
        return queryResult;
    }

    private void updateDateInfo(ChatQueryDataReq queryData, SemanticParseInfo parseInfo, Map<String, Map<String, String>> filedNameToValueMap, List<FieldExpression> fieldExpressionList, List<Expression> addConditions, Set<String> removeFieldNames) {
        if (Objects.isNull(queryData.getDateInfo())) {
            return;
        }
        if (queryData.getDateInfo().getUnit() > 1) {
            queryData.getDateInfo().setStartDate(DateUtils.getBeforeDate((int)(queryData.getDateInfo().getUnit() + 1)));
            queryData.getDateInfo().setEndDate(DateUtils.getBeforeDate((int)1));
        }
        for (FieldExpression fieldExpression : fieldExpressionList) {
            if (!TimeDimensionEnum.DAY.getChName().equals(fieldExpression.getFieldName())) continue;
            removeFieldNames.add(TimeDimensionEnum.DAY.getChName());
            GreaterThanEquals greaterThanEquals = new GreaterThanEquals();
            this.addTimeFilters(queryData.getDateInfo().getStartDate(), greaterThanEquals, addConditions);
            MinorThanEquals minorThanEquals = new MinorThanEquals();
            this.addTimeFilters(queryData.getDateInfo().getEndDate(), minorThanEquals, addConditions);
            break;
        }
        block1: for (FieldExpression fieldExpression : fieldExpressionList) {
            for (QueryFilter queryFilter : queryData.getDimensionFilters()) {
                if (!queryFilter.getOperator().equals((Object)FilterOperatorEnum.LIKE) || !FilterOperatorEnum.LIKE.getValue().toLowerCase().equals(fieldExpression.getOperator().toLowerCase())) continue;
                HashMap<String, Object> replaceMap = new HashMap<String, Object>();
                String preValue = fieldExpression.getFieldValue().toString();
                Object curValue = queryFilter.getValue().toString();
                if (preValue.startsWith("%")) {
                    curValue = "%" + (String)curValue;
                }
                if (preValue.endsWith("%")) {
                    curValue = (String)curValue + "%";
                }
                replaceMap.put(preValue, curValue);
                filedNameToValueMap.put(fieldExpression.getFieldName(), replaceMap);
                continue block1;
            }
        }
        parseInfo.setDateInfo(queryData.getDateInfo());
    }

    private <T extends ComparisonOperator> void addTimeFilters(String date, T comparisonExpression, List<Expression> addConditions) {
        Column column = new Column(TimeDimensionEnum.DAY.getChName());
        StringValue stringValue = new StringValue(date);
        comparisonExpression.setLeftExpression((Expression)column);
        comparisonExpression.setRightExpression((Expression)stringValue);
        addConditions.add((Expression)comparisonExpression);
    }

    private void updateFilters(List<FieldExpression> fieldExpressionList, Set<QueryFilter> metricFilters, Set<QueryFilter> contextMetricFilters, List<Expression> addConditions, Set<String> removeFieldNames) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(metricFilters)) {
            return;
        }
        block0: for (QueryFilter dslQueryFilter : metricFilters) {
            for (FieldExpression fieldExpression : fieldExpressionList) {
                if (fieldExpression.getFieldName() == null || !fieldExpression.getFieldName().contains(dslQueryFilter.getName())) continue;
                removeFieldNames.add(dslQueryFilter.getName());
                if (dslQueryFilter.getOperator().equals((Object)FilterOperatorEnum.EQUALS)) {
                    EqualsTo equalsTo = new EqualsTo();
                    this.addWhereFilters(dslQueryFilter, equalsTo, contextMetricFilters, addConditions);
                    continue block0;
                }
                if (dslQueryFilter.getOperator().equals((Object)FilterOperatorEnum.GREATER_THAN_EQUALS)) {
                    GreaterThanEquals greaterThanEquals = new GreaterThanEquals();
                    this.addWhereFilters(dslQueryFilter, greaterThanEquals, contextMetricFilters, addConditions);
                    continue block0;
                }
                if (dslQueryFilter.getOperator().equals((Object)FilterOperatorEnum.GREATER_THAN)) {
                    GreaterThan greaterThan = new GreaterThan();
                    this.addWhereFilters(dslQueryFilter, greaterThan, contextMetricFilters, addConditions);
                    continue block0;
                }
                if (dslQueryFilter.getOperator().equals((Object)FilterOperatorEnum.MINOR_THAN_EQUALS)) {
                    MinorThanEquals minorThanEquals = new MinorThanEquals();
                    this.addWhereFilters(dslQueryFilter, minorThanEquals, contextMetricFilters, addConditions);
                    continue block0;
                }
                if (dslQueryFilter.getOperator().equals((Object)FilterOperatorEnum.MINOR_THAN)) {
                    MinorThan minorThan = new MinorThan();
                    this.addWhereFilters(dslQueryFilter, minorThan, contextMetricFilters, addConditions);
                    continue block0;
                }
                if (!dslQueryFilter.getOperator().equals((Object)FilterOperatorEnum.IN)) continue block0;
                InExpression inExpression = new InExpression();
                this.addWhereInFilters(dslQueryFilter, inExpression, contextMetricFilters, addConditions);
                continue block0;
            }
        }
    }

    private void addWhereInFilters(QueryFilter dslQueryFilter, InExpression inExpression, Set<QueryFilter> contextMetricFilters, List<Expression> addConditions) {
        Column column = new Column(dslQueryFilter.getName());
        ParenthesedExpressionList parenthesedExpressionList = new ParenthesedExpressionList();
        List valueList = JsonUtil.toList((String)JsonUtil.toString((Object)dslQueryFilter.getValue()), String.class);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)valueList)) {
            return;
        }
        valueList.stream().forEach(o -> {
            StringValue stringValue = new StringValue(o);
            parenthesedExpressionList.add((Object)stringValue);
        });
        inExpression.setLeftExpression((Expression)column);
        inExpression.setRightExpression((Expression)parenthesedExpressionList);
        addConditions.add((Expression)inExpression);
        contextMetricFilters.stream().forEach(o -> {
            if (o.getName().equals(dslQueryFilter.getName())) {
                o.setValue(dslQueryFilter.getValue());
                o.setOperator(dslQueryFilter.getOperator());
            }
        });
    }

    private <T extends ComparisonOperator> void addWhereFilters(QueryFilter dslQueryFilter, T comparisonExpression, Set<QueryFilter> contextMetricFilters, List<Expression> addConditions) {
        Object columnName = dslQueryFilter.getName();
        if (StringUtils.isNotBlank((CharSequence)dslQueryFilter.getFunction())) {
            columnName = dslQueryFilter.getFunction() + "(" + dslQueryFilter.getName() + ")";
        }
        if (Objects.isNull(dslQueryFilter.getValue())) {
            return;
        }
        Column column = new Column((String)columnName);
        comparisonExpression.setLeftExpression((Expression)column);
        if (StringUtils.isNumeric((CharSequence)dslQueryFilter.getValue().toString())) {
            LongValue longValue = new LongValue(Long.parseLong(dslQueryFilter.getValue().toString()));
            comparisonExpression.setRightExpression((Expression)longValue);
        } else {
            StringValue stringValue = new StringValue(dslQueryFilter.getValue().toString());
            comparisonExpression.setRightExpression((Expression)stringValue);
        }
        addConditions.add((Expression)comparisonExpression);
        contextMetricFilters.stream().forEach(o -> {
            if (o.getName().equals(dslQueryFilter.getName())) {
                o.setValue(dslQueryFilter.getValue());
                o.setOperator(dslQueryFilter.getOperator());
            }
        });
    }

    private SemanticParseInfo mergeSemanticParseInfo(SemanticParseInfo parseInfo, ChatQueryDataReq queryData) {
        if ("LLM_S2SQL".equals(parseInfo.getQueryMode())) {
            return parseInfo;
        }
        if (!CollectionUtils.isEmpty((Collection)queryData.getDimensions())) {
            parseInfo.setDimensions(queryData.getDimensions());
        }
        if (!CollectionUtils.isEmpty((Collection)queryData.getMetrics())) {
            parseInfo.setMetrics(queryData.getMetrics());
        }
        if (!CollectionUtils.isEmpty((Collection)queryData.getDimensionFilters())) {
            parseInfo.setDimensionFilters(queryData.getDimensionFilters());
        }
        if (!CollectionUtils.isEmpty((Collection)queryData.getMetricFilters())) {
            parseInfo.setMetricFilters(queryData.getMetricFilters());
        }
        if (Objects.nonNull(queryData.getDateInfo())) {
            parseInfo.setDateInfo(queryData.getDateInfo());
        }
        return parseInfo;
    }

    private void validFilter(Set<QueryFilter> filters) {
        for (QueryFilter queryFilter : filters) {
            if (Objects.isNull(queryFilter.getValue())) {
                filters.remove(queryFilter);
            }
            if (!queryFilter.getOperator().equals((Object)FilterOperatorEnum.IN) || !CollectionUtils.isEmpty((Collection)JsonUtil.toList((String)JsonUtil.toString((Object)queryFilter.getValue()), String.class))) continue;
            filters.remove(queryFilter);
        }
    }

    @Override
    public Object queryDimensionValue(DimensionValueReq dimensionValueReq, User user) {
        Integer agentId = dimensionValueReq.getAgentId();
        Agent agent = this.agentService.getAgent(agentId);
        dimensionValueReq.setDataSetIds(agent.getDataSetIds());
        return this.semanticLayerService.queryDimensionValue(dimensionValueReq, user);
    }

    public void saveQueryResult(ChatExecuteReq chatExecuteReq, QueryResult queryResult) {
        if (chatExecuteReq.getParseId() > 1) {
            return;
        }
        this.chatManageService.saveQueryResult(chatExecuteReq, queryResult);
    }
}

