/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.persistence.repository.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.tencent.supersonic.chat.api.pojo.request.ChatParseReq;
import com.tencent.supersonic.chat.api.pojo.request.PageQueryInfoReq;
import com.tencent.supersonic.chat.api.pojo.response.QueryResp;
import com.tencent.supersonic.chat.api.pojo.response.SimilarQueryRecallResp;
import com.tencent.supersonic.chat.server.persistence.dataobject.ChatParseDO;
import com.tencent.supersonic.chat.server.persistence.dataobject.ChatQueryDO;
import com.tencent.supersonic.chat.server.persistence.mapper.ChatParseMapper;
import com.tencent.supersonic.chat.server.persistence.mapper.ChatQueryDOMapper;
import com.tencent.supersonic.chat.server.persistence.mapper.custom.ShowCaseCustomMapper;
import com.tencent.supersonic.chat.server.persistence.repository.ChatQueryRepository;
import com.tencent.supersonic.common.util.JsonUtil;
import com.tencent.supersonic.common.util.PageUtils;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.api.pojo.response.ParseResp;
import com.tencent.supersonic.headless.api.pojo.response.ParseTimeCostResp;
import com.tencent.supersonic.headless.api.pojo.response.QueryResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
@Primary
public class ChatQueryRepositoryImpl
implements ChatQueryRepository {
    private static final Logger log = LoggerFactory.getLogger(ChatQueryRepositoryImpl.class);
    @Autowired
    private ChatQueryDOMapper chatQueryDOMapper;
    @Autowired
    private ChatParseMapper chatParseMapper;
    @Autowired
    private ShowCaseCustomMapper showCaseCustomMapper;

    @Override
    public PageInfo<QueryResp> getChatQuery(PageQueryInfoReq pageQueryInfoReq, Long chatId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (chatId != null) {
            queryWrapper.lambda().eq(ChatQueryDO::getChatId, (Object)chatId);
        }
        if (StringUtils.isNotBlank((CharSequence)pageQueryInfoReq.getUserName())) {
            queryWrapper.lambda().eq(ChatQueryDO::getUserName, (Object)pageQueryInfoReq.getUserName());
        }
        if (!CollectionUtils.isEmpty((Collection)pageQueryInfoReq.getIds())) {
            queryWrapper.lambda().in(ChatQueryDO::getQuestionId, (Collection)pageQueryInfoReq.getIds());
        }
        queryWrapper.lambda().orderByDesc(ChatQueryDO::getQuestionId);
        PageInfo pageInfo = PageHelper.startPage((int)pageQueryInfoReq.getCurrent(), (int)pageQueryInfoReq.getPageSize()).doSelectPageInfo(() -> this.chatQueryDOMapper.selectList((Wrapper)queryWrapper));
        PageInfo chatQueryVOPageInfo = PageUtils.pageInfo2PageInfoVo((PageInfo)pageInfo);
        chatQueryVOPageInfo.setList(pageInfo.getList().stream().filter(o -> !StringUtils.isEmpty((CharSequence)o.getQueryResult())).map(this::convertTo).sorted(Comparator.comparingInt(o -> o.getQuestionId().intValue())).collect(Collectors.toList()));
        return chatQueryVOPageInfo;
    }

    @Override
    public QueryResp getChatQuery(Long queryId) {
        ChatQueryDO chatQueryDO = this.getChatQueryDO(queryId);
        if (Objects.isNull(chatQueryDO)) {
            return new QueryResp();
        }
        return this.convertTo(chatQueryDO);
    }

    @Override
    public ChatQueryDO getChatQueryDO(Long queryId) {
        return (ChatQueryDO)this.chatQueryDOMapper.selectById(queryId);
    }

    @Override
    public List<QueryResp> queryShowCase(PageQueryInfoReq pageQueryInfoReq, int agentId) {
        return this.showCaseCustomMapper.queryShowCase(pageQueryInfoReq.getLimitStart(), pageQueryInfoReq.getPageSize(), agentId, pageQueryInfoReq.getUserName()).stream().map(this::convertTo).collect(Collectors.toList());
    }

    private QueryResp convertTo(ChatQueryDO chatQueryDO) {
        QueryResp queryResp = new QueryResp();
        BeanUtils.copyProperties((Object)chatQueryDO, (Object)queryResp);
        QueryResult queryResult = (QueryResult)JsonUtil.toObject((String)chatQueryDO.getQueryResult(), QueryResult.class);
        if (queryResult != null) {
            queryResult.setQueryId(chatQueryDO.getQuestionId());
            queryResp.setQueryResult(queryResult);
        }
        queryResp.setSimilarQueries(JSONObject.parseArray((String)chatQueryDO.getSimilarQueries(), SimilarQueryRecallResp.class));
        queryResp.setParseTimeCost((ParseTimeCostResp)JsonUtil.toObject((String)chatQueryDO.getParseTimeCost(), ParseTimeCostResp.class));
        return queryResp;
    }

    @Override
    public Long createChatQuery(ChatParseReq chatParseReq) {
        ChatQueryDO chatQueryDO = new ChatQueryDO();
        chatQueryDO.setChatId((long)chatParseReq.getChatId());
        chatQueryDO.setCreateTime(new Date());
        chatQueryDO.setUserName(chatParseReq.getUser().getName());
        chatQueryDO.setQueryText(chatParseReq.getQueryText());
        chatQueryDO.setAgentId(chatParseReq.getAgentId());
        chatQueryDO.setQueryResult("");
        try {
            this.chatQueryDOMapper.insert(chatQueryDO);
        }
        catch (Exception e) {
            log.info("database insert has an exception:{}", (Object)e.toString());
        }
        return chatQueryDO.getQuestionId();
    }

    @Override
    public List<ChatParseDO> batchSaveParseInfo(ChatParseReq chatParseReq, ParseResp parseResult, List<SemanticParseInfo> candidateParses) {
        ArrayList<ChatParseDO> chatParseDOList = new ArrayList<ChatParseDO>();
        this.getChatParseDO(chatParseReq, parseResult.getQueryId(), candidateParses, chatParseDOList);
        if (!CollectionUtils.isEmpty(candidateParses)) {
            this.chatParseMapper.batchSaveParseInfo(chatParseDOList);
        }
        return chatParseDOList;
    }

    public void getChatParseDO(ChatParseReq chatParseReq, Long queryId, List<SemanticParseInfo> parses, List<ChatParseDO> chatParseDOList) {
        for (int i = 0; i < parses.size(); ++i) {
            ChatParseDO chatParseDO = new ChatParseDO();
            chatParseDO.setChatId((long)chatParseReq.getChatId());
            chatParseDO.setQuestionId(queryId);
            chatParseDO.setQueryText(chatParseReq.getQueryText());
            chatParseDO.setParseInfo(JsonUtil.toString((Object)parses.get(i)));
            chatParseDO.setIsCandidate(1);
            if (i == 0) {
                chatParseDO.setIsCandidate(0);
            }
            chatParseDO.setParseId(parses.get(i).getId());
            chatParseDO.setCreateTime(new Date());
            chatParseDO.setUserName(chatParseReq.getUser().getName());
            chatParseDOList.add(chatParseDO);
        }
    }

    @Override
    public int updateChatQuery(ChatQueryDO chatQueryDO) {
        return this.chatQueryDOMapper.updateById(chatQueryDO);
    }

    @Override
    public void updateChatQuery(ChatQueryDO chatQueryDO, UpdateWrapper<ChatQueryDO> updateWrapper) {
        this.chatQueryDOMapper.update(chatQueryDO, (Wrapper)updateWrapper);
    }

    @Override
    public ChatParseDO getParseInfo(Long questionId, int parseId) {
        return this.chatParseMapper.getParseInfo(questionId, parseId);
    }

    @Override
    public List<ChatParseDO> getParseInfoList(List<Long> questionIds) {
        return this.chatParseMapper.getParseInfoList(questionIds);
    }

    @Override
    public List<ParseResp> getContextualParseInfo(Integer chatId) {
        List<ChatParseDO> chatParseDOList = this.chatParseMapper.getContextualParseInfo(chatId);
        List<ParseResp> semanticParseInfoList = chatParseDOList.stream().map(parseInfo -> {
            ParseResp parseResp = new ParseResp(parseInfo.getQueryText());
            ArrayList<SemanticParseInfo> selectedParses = new ArrayList<SemanticParseInfo>();
            selectedParses.add((SemanticParseInfo)JSONObject.parseObject((String)parseInfo.getParseInfo(), SemanticParseInfo.class));
            parseResp.setSelectedParses(selectedParses);
            return parseResp;
        }).collect(Collectors.toList());
        return semanticParseInfoList;
    }
}

